#include "mbed.h"
#include "rtos.h"
 #include "ultrasonic.h"

DigitalOut led1(LED1);
InterruptIn sw2(SW2);
uint32_t button_pressed;
Thread *thread2;
ultrasonic us = ultrasonic(PTC2, PTC3, 100, 1000);

void sw2_press(void)
{
    thread2->signal_set(0x1);
    
}

void led_thread(void const *argument)
{
    while (true) {
        led1 = !led1;
        Thread::wait(1000);
    }
}

void button_thread(void const *argument)
{
    while (true) {
        Thread::signal_wait(0x1);
        float x = us.getCurrentDistance();
        printf("distance = %f\n", x);
        button_pressed++;
    }
}

int main()
{
    Thread thread(led_thread);
    thread2 = new Thread(button_thread);
    //teste

    button_pressed = 0;
    sw2.fall(&sw2_press);
    while (true) {
        Thread::wait(5000);
        printf("SW2 was pressed (last 5 seconds): %d \n", button_pressed);
        fflush(stdout);
        button_pressed = 0;
    }
}
