#ifndef RTP_HEADER
#define RTP_HEADER

#define RECV_PORT 5004

struct rtp_header {
    int version; // 2 bits
    int padding; // 1 bit
    int extension; // 1 bit
    int csrc_count; // 3 bits
    // byte boundary
    int marker; // 1 bit
    int payload_type; // 7 bits
    // byte boundary
    int seq_number; // 16 bits
    // byte boundary
    int timestamp;
    // byte boundary
    int ssrc;
    
    int header_len;
    int data_len;
};

void rtp_decompose(char *, int, struct rtp_header *, char **); 

#endif