#include "rtp.h"

void rtp_decompose(char * buf, int buf_len, struct rtp_header * hdr, char ** wav_data) {
    hdr->version        = (buf[0] & 0xC0) >> 6;
    hdr->padding        = (buf[0] & 0x20) >> 5;
    hdr->extension      = (buf[0] & 0x10) >> 4;
    hdr->csrc_count     = (buf[0] & 0x0F);

    hdr->marker         = (buf[1] & 0x80) >> 7;
    hdr->payload_type   = (buf[1] & 0x7F);

    hdr->seq_number     = (buf[2] << 8)  | buf[3];
    hdr->timestamp      = (buf[4] << 24) | (buf[5] << 16) | (buf[6] << 8) | buf[7];
    hdr->ssrc           = (buf[8] << 24) | (buf[9] << 16) | (buf[10] << 8) | buf[11];

    hdr->header_len     = 12;
    hdr->data_len       = buf_len - hdr->header_len;

    //memcpy(wav_data+offset,(buf + hdr->header_len), hdr->data_len);
    *wav_data = buf+hdr->header_len;
}
