#include "mbed.h" //Inclui biblioteca mbed

//Pinos do motor de passo
DigitalOut EN_A (D10);
DigitalOut IN1_A (D5);
DigitalOut IN2_A (D4);
DigitalOut EN_B (A4);
DigitalOut IN1_B (A0);
DigitalOut IN2_B (A1);

//pinos motor DC
PwmOut EN_A_DC (D11);
DigitalOut IN1_A_DC (D12);
DigitalOut IN2_A_DC (D13);

Timeout desaciona_DC; //timeout que define quantidade tempo o motor DC vai rodar

int motor; //escolhe qual motor vai ser acionado
int enable_passo=0; // liga/desliga motor de passo
int enable_DC=0; // liga/desliga motor DC
int sentido_passo; //define sentido de rotação do motor de passo
int sentido_DC; //define sentido de rotação do motor de passo
float velocidade_passo; //define velocidade do motor de passo em RPM
float velocidade_DC; //define velocidade do motor DC em RPM
int numero_rotacoes_passo=0; //define quantas vezes o motor de passo vai rodar
int numero_de_passos_passo_pratico=0; //define a quantidade de passos que o motor deu
float tempo_rotacionando_DC=0; //Define por quanto tempo  o motor DC vai estar acionado
float numero_de_passos_por_volta_passo=200; //A quantidade de passos por volta do motor de passo é 200
float tempo_passo; //Calcula o wait a ser utilizado para cada fase
float duty_cycle_DC=1; //define o duty cycle
int ligado_DC; //aciona ou desaciona o motor DC no meio do suo

void desliga() //Muda valor de ligado_DC
{
    ligado_DC=!ligado_DC;
}

int main()

{
    
    while(1) {
        
        //Perguntas para atribuir valor das variáveis 
        printf("Digite 0 para motor de passo ou 1 para DC \r\n");
        scanf("%d", &motor );
        if(motor==0) {
            printf("Digite 1 para acionar o motor de passo e 0 para desacionar\r\n");
            scanf("%d", &enable_passo);
            if(enable_passo==1){
                printf("Digite 0 para sentido horario e 1 para sentido anti-horario\r\n");
                scanf("%d", &sentido_passo);
                printf("Digite a Velocidade em RPM do motor de passo (valor entre 0 e 60 RPM)\r\n");
                scanf("%f", &velocidade_passo);
                printf("Digite o número de rotações do motor de passo\r\n");
                scanf("%d", &numero_rotacoes_passo);
            }
        } else if(motor==1) {
            printf("Digite 1 para acionar o motor DC e 0 para desacionar\r\n");
            scanf("%d", &enable_DC);
            if(enable_DC==1) {
                printf("Digite 0 para sentido horario e 1 para sentido anti-horario\r\n");
                scanf("%d", &sentido_DC);
                printf("Digite a Velocidade em RPM do motor DC (valor entre 900 e 2000 RPM))\r\n");
                scanf("%f", &velocidade_DC);
                printf("Digite o tempo de rotação do motor DC em segundos\r\n");
                scanf("%f", &tempo_rotacionando_DC);
            }
        }
        
        if(motor==0) {        //escolhe qual motor será ativado. No caso o de passo.
    
            tempo_passo=0.3/velocidade_passo; //Calcula o tempo do passo pela velocidade inserida pelo usuário
            numero_de_passos_passo_pratico=0; //Contador de passos
            while(numero_de_passos_passo_pratico < numero_de_passos_por_volta_passo*numero_rotacoes_passo) { //roda o motor até numero de rotações definidas
                if(enable_passo) {
                    //Define se o motor rotacionará no sentido horario ou anti-horario
                    switch(sentido_passo) {
                        case 0:

                            //passo 0

                            EN_A = 1;
                            IN1_A = 1;
                            IN2_A = 0;
                            EN_B = 1;
                            IN1_B = 1;
                            IN2_B = 0;
                            wait(tempo_passo); //periodo definido anteriormente

                            //passo 1

                            EN_A = 1;
                            IN1_A = 0;
                            IN2_A = 1;
                            EN_B = 1;
                            IN1_B = 1;
                            IN2_B = 0;
                            wait(tempo_passo); //periodo definido anteriormente

                            //passo 2

                            EN_A = 1;
                            IN1_A = 0;
                            IN2_A = 1;
                            EN_B =1 ;
                            IN1_B = 0;
                            IN2_B = 1;
                            wait(tempo_passo); //periodo definido anteriormente

                            //passo 3

                            EN_A = 1;
                            IN1_A = 1;
                            IN2_A = 0;
                            EN_B = 1;
                            IN1_B = 0;
                            IN2_B = 1;
                            wait(tempo_passo); //periodo definido anteriormente
                            break;

                        case 1:

                            //passo 3

                            EN_A = 1;
                            IN1_A = 1;
                            IN2_A = 0;
                            EN_B = 1;
                            IN1_B = 0;
                            IN2_B = 1;
                            wait(tempo_passo); //periodo definido anteriormente

                            //passo 2

                            EN_A = 1;
                            IN1_A = 0;
                            IN2_A = 1;
                            EN_B = 1;
                            IN1_B = 0;
                            IN2_B = 1;
                            wait(tempo_passo); //periodo definido anteriormente

                            //passo 1

                            EN_A = 1;
                            IN1_A = 0;
                            IN2_A = 1;
                            EN_B = 1;
                            IN1_B = 1;
                            IN2_B = 0;
                            wait(tempo_passo); //periodo definido anteriormente

                            //passo 0

                            EN_A = 1;
                            IN1_A = 1;
                            IN2_A = 0;
                            EN_B = 1;
                            IN1_B = 1;
                            IN2_B = 0;
                            wait(tempo_passo); //periodo definido anteriormente

                            break;
                            
                    }
                    numero_de_passos_passo_pratico+=4;
                } else {
                    //se botão enable desativado, desativa o EN_A e EN_B
                    EN_A=0;
                    EN_B=0;
                }
            }
        } else if(motor==1) {         //escolhe qual motor será ativado. No caso o DC

            ligado_DC=1;
            desaciona_DC.attach(&desliga, tempo_rotacionando_DC); //aciona o Timeout pelo tempo definidopelo usuário. Este timout desligara o motor.
            
            //O duty cycle foi calculado de acordo com a linha de tendência do gráfico obtido variando a velocidade pelo PWM a partir de testes.
            duty_cycle_DC = 8*(0.00000000001)*(velocidade_DC*velocidade_DC*velocidade_DC) - 4*(0.0000001)*(velocidade_DC*velocidade_DC) + 0.0005*velocidade_DC - 0.0274;
            if(enable_DC) {
                if(sentido_DC==0) { //define se o motor rotacionará pelo sentido horário ou anti-horario
                    IN1_A_DC=0;
                    IN2_A_DC=1;

                    while(ligado_DC) { 
                        EN_A_DC.write(duty_cycle_DC); //Aciona motor DC na velocidade e sentido definido peo tempo também definido pelo usuário

                    }
                } else if(sentido_DC==1) {
                    IN1_A_DC=1;
                    IN2_A_DC=0;
                    while(ligado_DC) {
                        EN_A_DC.write(duty_cycle_DC);
                    }
                }
            }
            IN1_A_DC=0; //desaciona o motor DC
            IN2_A_DC=0;
            EN_A_DC.write(0);
        }
    }
}
