
#include "mbed.h"

AnalogIn potenciometro(A5);                          //declara a entrada do potenciômetro
PwmOut dc(D10);                                      //declara a saída do PWM
InterruptIn encoder(D7);                             //declara entrada do encoder

Ticker tempo_alto;                                   //declara um ticker
int contador=0;                                      //icício do contador zerado
int periodo=1;
int periodo_min=60/periodo;                          //faz a conta do período
float rpm=0;                                         //icício do rpm zerado
float duty_cycle=0;                                  //icício do duty cycle zerado

void alto(){                                         //declara a função alto
    contador++;                                      //soma 1 no contador
    }

void calcula_rpm(){                                       //declara a função começa
    rpm=contador*periodo_min/(30);                   //faz a conta do rpm
    contador=0;                                      //zera o contador depois de calculo de rpm
    }

int main(){
    dc.period(0.010);                                // define o periodo do PWM
    encoder.rise(&alto);                             //quando o encoder retorna 1 a função &alto é chamada
    tempo_alto.attach(&calcula_rpm, periodo);             //a funcao "calcula_rpm" é acionada quando passar o tempo de "periodo"
    
    while(1){    
        duty_cycle=potenciometro.read();             //o duty cycle é definido pelo potenciometro
        dc.write(duty_cycle);                        //o valor de duty cycle é colocado no PWM
        printf("duty cycle: %f rpm: %f \r\n " ,duty_cycle*100, rpm);   //o valor de rpm e do duty cycle é printado

    }
}

