/* HTTP and RPC * MBED RECEIVES AND SEND DATA TO A VISUAL BASIC 2008 PROGRAMM */
/* IP OF MBED IS USED BY VISUAL BASIC PRG  */

#include "mbed.h"
#include "EthernetNetIf.h"
#include "HTTPServer.h"
#include "RPCVariable.h"
#include "RPCFunction.h"
#include "TextLCD.h"

// The LCD is connected as below
TextLCD lcd(p21, p22, p23, p24, p25, p26); // rs, e, d4-d7

AnalogIn ain1(p15);
AnalogIn ain2(p16);

float temp;
float volt;

using namespace mbed;

//***************************************************************
//Create a function of the required format - READ DATE and HOUR
void DateHour(char * input, char * output);
//Attach it to an RPC object
RPCFunction LeDataHora(&DateHour, "LeDataHora");

void DateHour(char * input, char * output)
{
    time_t seconds = time(NULL);
    sprintf(output, "%s", ctime(&seconds));
}
//***************************************************************
//Create a function of the required format - CONTROL LED BRIGHT
void dimLed(char * input, char * output);
//Attach it to an RPC object
RPCFunction rpc_dimLed(&dimLed, "LedDimmer");

void dimLed(char * input, char * output)
{
    float x;
    sscanf(input, "%f", &x);
    PwmOut myLed4 (LED4);
    myLed4 = x/100;
    sprintf(output, "%f", x);
}
//**************************************************************
//Create a function of the required format - READ THE POTENTIOMETER CONNECTED TO p15
void Levolt(char * input, char * output);

RPCFunction Voltagem(&Levolt, "Voltagem");

void Levolt(char * input, char * output)
{
//    float volt;
    volt = ain1.read() * 3.3;
    sprintf (output,"%2.2f", volt);
}
//**************************************************************
//Create a function of the required format - READ THE TEMPERATURE USING A LM35 CONNECTED TO p16
void Letemp(char * input, char * output);

RPCFunction Temperatura(&Letemp, "Temperatura");

void Letemp(char * input, char * output)
{
//    float temp;
    temp = ain2.read() * 330;
    sprintf (output, "%2.1f", temp);
}
//**************************************************************

//Create the variables
//float f;
//int i;
//char c;
//Connect the variables to the RPCVariable Object
//RPCVariable<float> rpc_f(&f, "f");
//RPCVariable<int> rpc_i(&i, "i");
//RPCVariable<char> rpc_c(&c, "c");

//Define the LED´s and Buttons
DigitalOut led1(LED1, "led1");
DigitalOut led2(LED2, "led2");
DigitalOut led3(LED3, "led3");
DigitalIn button1(p20, "button1");// BUTTON IS CONNECTED BETWEEN p20 AND VOUT VIA A 2.2K RESISTOR

LocalFileSystem fs("webfs");

EthernetNetIf eth;
HTTPServer svr;

int main()
{
    Base::add_rpc_class<AnalogIn>();
    Base::add_rpc_class<AnalogOut>();
    Base::add_rpc_class<DigitalIn>();
    Base::add_rpc_class<DigitalOut>();
    Base::add_rpc_class<DigitalInOut>();
    Base::add_rpc_class<PwmOut>();
    Base::add_rpc_class<Timer>();
    Base::add_rpc_class<BusOut>();
    Base::add_rpc_class<BusIn>();
    Base::add_rpc_class<BusInOut>();
    Base::add_rpc_class<Serial>();


    printf("Setting up...\n\r");
    EthernetErr ethErr = eth.setup();
    if(ethErr) {
        printf("Error %d in setup.\n\r", ethErr);
        return -1;
    }
    printf("Setup OK\n\r");

    FSHandler::mount("/webfs", "/files"); //Mount /webfs path on /files web path
    FSHandler::mount("/webfs", "/"); //Mount /webfs path on web root path

    svr.addHandler<SimpleHandler>("/hello");
    svr.addHandler<RPCHandler>("/rpc");
    svr.addHandler<FSHandler>("/files");
    svr.addHandler<FSHandler>("/"); //Default handler
    //Example : Access to mbed.htm : http://a.b.c.d/mbed.htm or http://a.b.c.d/files/mbed.htm

    svr.bind(80);

    printf("Listening...\n\r");

    Timer tm;
    tm.start();
    //Listen indefinitely
    while(true) {
        Net::poll();
        if(tm.read()>.1) {
            //led1=!led1; //Show that we are alive
            printf("Working...\n\r");

            //time_t seconds = time(NULL);
            //printf("Data e hora = %s\n\r", ctime(&seconds));

            //f = 0.23;
            //i =  i + 1;
            //c = 'a';
            volt = ain1.read() * 3.3;
            temp = ain2.read() * 330; /* temp = ain.read() * 3.3 * 100; */
            lcd.locate(0,0);
            lcd.printf ("Voltagem= %2.2f V \n", volt);
            lcd.locate(0,1);
            lcd.printf ("Temp= %2.1f C \n", temp);

            tm.start();
        }
    }
}
