//CÓDIGO 1-B

#include "mbed.h"
#include "stdlib.h"
#include <LiquidCrystal_I2C.h>
#include <iostream>
#include <string>

Serial pc(USBTX, USBRX); // tx, rx

//Los puertos SDA  y SD8 están referenciados en el archivo LiquidCrystal_I2C.cpp
// SDA -> PTC9
// SCL -> PTC8
//                     DIR   TIPO
LiquidCrystal_I2C lcd(0x4E, 16, 2);

I2CSlave slave(I2C_SDA, I2C_SCL);

char addr = 0xA0;


int main()
{
    pc.printf("\x1b[2J");       //CLEAR
    pc.printf("\033[1;1H");     //Mueve cursor al origen
    
   
    char buf[50];
    
 
    // Inicia la LCD
    lcd.begin();
    
    slave.address(addr);
    slave.frequency (100000);
    pc.printf("SLAVE: %d\r\n", addr);
    
    // Turn on the blacklight.
    lcd.backlight();
    lcd.clear();
    lcd.print("SLAVE");
    char msg[] = " *Si* ";
    while (1) 
    {
        int i = slave.receive();
        
        switch (i) {
            case I2CSlave::ReadAddressed:
                slave.write(msg, strlen(msg) + 1); // Includes null char
                slave.stop();
                slave.receive();
                break;
            case I2CSlave::WriteGeneral:
                slave.read(buf, 30);
                printf("Read G: %s\n", buf);
                slave.stop();
                slave.receive();
                break;
            case I2CSlave::WriteAddressed:
                slave.read(buf, 30);
                pc.printf("Read A: %s\n", buf);
                lcd.clear();
                lcd.print(buf);
                slave.stop();
                slave.receive();
                break;
        }
        for (int i = 0; i < 10; i++) {
            buf[i] = 0;    // Clear buffer
        }
       
    }
}
 