/*
 * Copyright (c) 2006-2020 Arm Limited and affiliates.
 * SPDX-License-Identifier: Apache-2.0
 */
#include <mbed.h>

Serial pc(USBTX, USBRX); 

I2CSlave slave(I2C_SDA, I2C_SCL);

char addr = 0xA0;

int main()
{
    char buf[10];
    char msg[] = "Slave!";
    pc.printf("\x1b[2J");       //CLEAR
    pc.printf("\r");     //Mueve cursor al origen
    pc.printf("SLAVE\r\n");
    
    slave.address(addr);
    slave.frequency (100000);
    pc.printf("SLAVE: %d\r\n",addr);
    
    while (1) 
    {
        int i = slave.receive();
        switch (i) {
            case I2CSlave::ReadAddressed:
                slave.write(msg, strlen(msg) + 1); // Includes null char
                break;
            case I2CSlave::WriteGeneral:
                slave.read(buf, 10);
                printf("Read G: %s\n", buf);
                break;
            case I2CSlave::WriteAddressed:
                slave.read(buf, 10);
                printf("Read A: %s\n", buf);
                break;
        }
        for (int i = 0; i < 10; i++) {
            buf[i] = 0;    // Clear buffer
        }
       
    }
}