#include "mbed.h"

#define BUFFER_SIZE 8
#define SLAVE_ADDR 0xA0

Serial pc(USBTX, USBRX); 
I2C master(I2C_SDA, I2C_SCL);

static const char* to_send[] = { "abcde", "12345", "EFGHI" };
int main() 
{
    pc.printf("\x1b[2J");       //CLEAR
    pc.printf("\r");           //Mueve cursor al origen
    pc.printf("MASTER\r\n");
    
    master.frequency (100000);
    char buf[BUFFER_SIZE];
    int send_index = 0;
    while (1) 
    {
        strcpy(buf, to_send[send_index]);
        
        // Write the new message to the slave
        if (master.write(SLAVE_ADDR, buf, BUFFER_SIZE) == 0) 
        {
            pc.printf("Written to slave: %s\r\n", buf);
        } 
        // Read what the slave has (should be identical)
        
        if (master.read(SLAVE_ADDR, buf, BUFFER_SIZE) == 0) {
            pc.printf("Read from slave: %s\r\n", buf);
        }
        
        // Change the message we're writing to the slave
        send_index++;
        if (send_index > 2) {
            send_index = 0;
        }
        
    }
}
