//CÓDIGO 1-A

#include "mbed.h"
#include "MMA8451Q.h"
#include "stdio.h"
#include "stdlib.h"

#define MMA8451_I2C_ADDRESS (0x1d << 1)
Serial pc(USBTX, USBRX);


#define BUFFER_SIZE 50
#define SLAVE_ADDR 0xA0
I2C master(I2C_SDA, I2C_SCL);


 
int main(void)
{
    master.frequency (100000);
    pc.printf("\x1b[2J");       //CLEAR
    pc.printf("\r");           //Mueve cursor al origen
    pc.printf("MASTER\r\n");
    
    char buf[BUFFER_SIZE];
    
    MMA8451Q acc(PTE25, PTE24, MMA8451_I2C_ADDRESS);
    //            SDA    SCL         DIRECCIÓN
    
    PwmOut rled(LED1);
    PwmOut gled(LED2);
    PwmOut bled(LED3);
    
    if (master.read(SLAVE_ADDR, buf, BUFFER_SIZE) == 0) {
            pc.printf("CONECTADO %s\r\n", buf);
    }
    
    float x, y, z;
    
    while (true) {
        
        x = abs(acc.getAccX());
        y = abs(acc.getAccY());
        z = abs(acc.getAccZ());
        
        rled = 1.0f - x;
        gled = 1.0f - y;
        bled = 1.0f - z;
        
        sprintf(buf, "%1.2f, %1.2f, %1.2f", x, y, z);
        pc.printf("%s\r\n", buf);
        if (master.write(SLAVE_ADDR, buf, BUFFER_SIZE) == 0) 
        {
            wait(0.2);
            pc.printf("Written to slave: %s\r\n", buf);
        } 
        
        wait(1);
     
        if (master.write(SLAVE_ADDR, buf, BUFFER_SIZE) == 0) 
        {
            wait(0.2);
            pc.printf("Written to slave: %s\r\n", buf);
        } 
        
        
    }
} 