//CÓDIGO 1-A

#include "mbed.h"
#include "MMA8451Q.h"
 
Serial pc(USBTX, USBRX);

#define MMA8451_I2C_ADDRESS (0x1d << 1)
 
int main(void)
{
    MMA8451Q acc(PTE25, PTE24, MMA8451_I2C_ADDRESS);
    //            SDA    SCL         DIRECCIÓN
    
    PwmOut rled(LED1);
    PwmOut gled(LED2);
    PwmOut bled(LED3);
 
    pc.printf("MMA8451 ID: %d\n", acc.getWhoAmI());
 
    while (true) {
        float x, y, z;
        
        x = abs(acc.getAccX());
        y = abs(acc.getAccY());
        z = abs(acc.getAccZ());
        
        rled = 1.0f - x;
        gled = 1.0f - y;
        bled = 1.0f - z;
        wait(0.5);
        pc.printf("X: %1.2f, Y: %1.2f, Z: %1.2f\r\n", x, y, z);
    }
}