#include "FermeStepper.h"

#include "mbed.h"

int fermemotorSpeed; // Stepper speed

fermeMotor::fermeMotor(PinName A0, PinName A1, PinName A2, PinName A3, PinName B0, PinName B1, PinName B2, PinName B3) : _A0(A0), _A1(A1), _A2(A2), _A3(A3), _B0(B0), _B1(B1), _B2(B2), _B3(B3)  { // Defenition of motor pins
    _A0=0;      // recepticle conveyor Pin 1
    _A1=0;      // recepticle conveyor Pin 2
    _A2=0;      // recepticle conveyor Pin 3
    _A3=0;      // recepticle conveyor Pin 4
    _B0=0;      // microtrack conveyor Pin 1
    _B1=0;      // microtrack conveyor Pin 2
    _B2=0;      // microtrack conveyor Pin 3
    _B3=0;      // microtrack conveyor Pin 4
}

void fermeMotor::anticlockwise(int flag1, int flag2, int motorspeed)        // flag1 for recepticle conveyor, flag2 for microtrack conveyor
{
    for(int i = 0; i<8; i++)
    {
        if(flag1 == 1)
        {
        switch(i)
        {
            case 0: 
                  _A0=0;
                  _A1=0;
                  _A2=1;
                  _A3=0;            
            break;
            
            case 1:             
                  _A0=0;
                  _A1=0;
                  _A2=0;
                  _A3=0;                
            break;
           
            case 2:            
                  _A0=0;
                  _A1=0;
                  _A2=0;
                  _A3=1;                
            break;
            
            case 3:             
                  _A0=0;
                  _A1=1;
                  _A2=0;
                  _A3=1;                
            break;
            
            case 4:             
                  _A0=0;
                  _A1=1;
                  _A2=1;
                  _A3=1;
            break;
            
            case 5:             
                  _A0=1;
                  _A1=1;
                  _A2=1;
                  _A3=1;                             
            break;
            
            case 6:             
                  _A0=1;
                  _A1=0;
                  _A2=1;
                  _A3=1;                
            break;
            
            case 7:             
                  _A0=1;
                  _A1=0;
                  _A2=1;
                  _A3=0;                
            break;
        }
        wait_us(motorspeed); // wait time defines the speed 
        }
        
        else if(flag1 == 0)
        {            
        switch(i)
        {
            case 0: 
                  _A0=0;
                  _A1=0;
                  _A2=0;
                  _A3=0;            
            break;
            
            case 1:             
                  _A0=0;
                  _A1=0;
                  _A2=0;
                  _A3=0;
            break;
           
            case 2:            
                  _A0=0;
                  _A1=0;
                  _A2=0;
                  _A3=0;
            break;
            
            case 3:             
                  _A0=0;
                  _A1=0;
                  _A2=0;
                  _A3=0;
            break;
            
            case 4:             
                  _A0=0;
                  _A1=0;
                  _A2=0;
                  _A3=0;
            break;
            
            case 5: 
                  _A0=0;
                  _A1=0;
                  _A2=0;
                  _A3=0;
            break;
            
            case 6:             
                  _A0=0;
                  _A1=0;
                  _A2=0;
                  _A3=0;
            break;
            
            case 7:             
                  _A0=0;
                  _A1=0;
                  _A2=0;
                  _A3=0;
            break;
        }
        wait_us(motorspeed); // wait time defines the speed 
        }
        
    if(flag2 == 1)
       {        
        switch(i) 
        {
            case 0:   
                   _B0=1;
                   _B1=0;
                   _B2=0;
                   _B3=1;       
            break;
            
            case 1: 
                   _B0=1;
                   _B1=0;
                   _B2=0;
                   _B3=0;
            break;
            
            case 2: 
                   _B0=1;
                   _B1=1;
                   _B2=0;
                   _B3=0;
            break;
            
            case 3: 
                   _B0=0;
                   _B1=1;
                   _B2=0;
                   _B3=0;
            break;
            
            case 4:                    
                   _B0=0;
                   _B1=1;
                   _B2=1;
                   _B3=0;
            break;
           
            case 5: 
                   _B0=0;
                   _B1=0;
                   _B2=1;
                   _B3=0;                   
            break;
            
            case 6:                    
                   _B0=0;
                   _B1=0;
                   _B2=1;
                   _B3=1;                   
            break;
            
            case 7: 
                  _B0=0;
                  _B1=0;
                  _B2=0;
                  _B3=1;
            break;
        }
        wait_us(motorspeed); // wait time defines the speed 
    }
        
     else if(flag2 == 0)
        {            
        switch(i)
        {
            case 0: 
                  _B0=0;
                  _B1=0;
                  _B2=0;
                  _B3=0;           
            break;
            
            case 1: 
                  _B0=0;
                  _B1=0;
                  _B2=0;
                  _B3=0;            
           break;
           
           case 2:
                  _B0=0;
                  _B1=0;
                  _B2=0;
                  _B3=0;                            
            break;
            
            case 3: 
            
                  _B0=0;
                  _B1=0;
                  _B2=0;
                  _B3=0;           
            break;
            
            case 4: 
                  _B0=0;
                  _B1=0;
                  _B2=0;
                  _B3=0;
            break;
            
            case 5: 
                  _B0=0;
                  _B1=0;
                  _B2=0;
                  _B3=0;            
            break;
            
            case 6: 
                  _B0=0;
                  _B1=0;
                  _B2=0;
                  _B3=0;            
            break;
            
            case 7: 
                  _B0=0;
                  _B1=0;
                  _B2=0;
                  _B3=0;            
            break;
        }
        wait_us(motorspeed); // wait time defines the speed 
     }   
    }
}

void fermeMotor::clockwise(int flag1, int flag2, int motorspeed) 
{ 
    for (int i = 7; i >= 0; i--) 
    {               
        if(flag1 == 1)
        {        
        switch(i) 
        {
            case 0:                             
                  _A0=0;
                  _A1=0;
                  _A2=0;
                  _A3=1;                            
            break;
            
            case 1:             
                   _A0=0;
                   _A1=0;
                   _A2=1;
                   _A3=1;            
            break;
            
            case 2:             
                   _A0=0;
                   _A1=0;
                   _A2=1;
                   _A3=0;                           
            break;
            
            case 3:             
                   _A0=0;
                   _A1=1;
                   _A2=1;
                   _A3=0;            
            break;
            
            case 4:             
                   _A0=0;
                   _A1=1;
                   _A2=0;
                   _A3=0;            
            break;
           
            case 5:             
                   _A0=1;
                   _A1=1;
                   _A2=0;
                   _A3=0;            
            break;
            
            case 6:             
                   _A0=1;
                   _A1=0;
                   _A2=0;
                   _A3=0;            
            break;
            
            case 7:             
                   _A0=1;
                   _A1=0;
                   _A2=0;
                   _A3=1;                            
            break;
        }
        wait_us(motorspeed); // wait time defines the speed 
    }
    
    else if(flag1 == 0)
        {            
        switch(i) 
        {
            case 0:                             
                  _A0=0;
                  _A1=0;
                  _A2=0;
                  _A3=0;                            
            break;
            
            case 1:             
                  _A0=0;
                  _A1=0;
                  _A2=0;
                  _A3=0;            
            break;
            
            case 2:             
                  _A0=0;
                  _A1=0;
                  _A2=0;
                  _A3=0;           
            break;
            
            case 3:             
                  _A0=0;
                  _A1=0;
                  _A2=0;
                  _A3=0;            
            break;
            
            case 4:             
                  _A0=0;
                  _A1=0;
                  _A2=0;
                  _A3=0;            
            break;
           
            case 5:             
                  _A0=0;
                  _A1=0;
                  _A2=0;
                  _A3=0;            
            break;
            
            case 6:             
                  _A0=0;
                  _A1=0;
                  _A2=0;
                  _A3=0;            
            break;
            
            case 7:             
                  _A0=0;
                  _A1=0;
                  _A2=0;
                  _A3=0;            
            break;
        }
        wait_us(motorspeed); // wait time defines the speed 
    }
    
    if(flag2 == 1)
        {
        switch(i)
        {
            case 0: 
                  _B0=1;
                  _B1=0;
                  _B2=1;
                  _B3=0;                  
            break;
            
            case 1:             
                  _B0=1;
                  _B1=0;
                  _B2=1;
                  _B3=1;                              
           break;
           
           case 2:           
                  _B0=1;
                  _B1=1;
                  _B2=1;
                  _B3=1;                                                
            break;
            
            case 3: 
                  _B0=0;
                  _B1=1;
                  _B2=1;
                  _B3=1;                            
            break;
            
            case 4: 
                  _B0=0;
                  _B1=1;
                  _B2=0;
                  _B3=1;
            break;
            
            case 5: 
                  _B0=0;
                  _B1=0;
                  _B2=0;
                  _B3=1;
            break;
            
            case 6: 
                  _B0=0;
                  _B1=0;
                  _B2=0;
                  _B3=0;                               
            break;
            
            case 7: 
                  _B0=0;
                  _B1=0;
                  _B2=1;
                  _B3=0;                       
            break;
        }
        wait_us(motorspeed); // wait time defines the speed 
     }
     
    else if(flag2 == 0)
       {
        switch(i) 
        {
            case 0:             
                  _B0=0;
                  _B1=0;
                  _B2=0;
                  _B3=0;            
            break;
            
            case 1: 
                  _B0=0;
                  _B1=0;
                  _B2=0;
                  _B3=0;
            break;
            
            case 2: 
                  _B0=0;
                  _B1=0;
                  _B2=0;
                  _B3=0;
            break;
            
            case 3: 
                  _B0=0;
                  _B1=0;
                  _B2=0;
                  _B3=0;
            break;
            
            case 4: 
                  _B0=0;
                  _B1=0;
                  _B2=0;
                  _B3=0;
            break;
           
            case 5: 
                  _B0=0;
                  _B1=0;
                  _B2=0;
                  _B3=0;
            break;
            
            case 6: 
                  _B0=0;
                  _B1=0;
                  _B2=0;
                  _B3=0;
            break;
            
            case 7: 
                  _B0=0;
                  _B1=0;
                  _B2=0;
                  _B3=0;
            break;
        }
        wait_us(motorspeed); // wait time defines the speed 
    }        
    }
}

void fermeMotor::fstep(int num_stepsA, int num_stepsB, int direction, int speed) 
{
    int count=0; // initalize step count
    fermemotorSpeed=speed; //set motor speed
    int num_steps = (num_stepsA > num_stepsB) ? num_stepsA : num_stepsB;
    int flagA = 0;
    int flagB = 0;
    if (direction==0) // turn clockwise
    {    
    do {
            if(count < num_stepsA) flagA=1;
            else flagA=0;
            if(count < num_stepsB) flagB=1;
            else flagB=0;
            clockwise(flagA, flagB, fermemotorSpeed);
            count++;
       } while (count < num_steps); // turn number of steps applied 
    }
        
    else if (direction==1)// turn anticlockwise: default direction for recepticle and microtrack conveyor to go forward
    { 
        count=0;
        do 
        {
            if(count < num_stepsA) flagA=1;
            else flagA=0;
            if(count<num_stepsB) flagB=1;
            else flagB=0;
            anticlockwise(flagA, flagB, fermemotorSpeed);
            count++;
        } while (count < num_steps);// turn number of steps applied 
   }
}

/* The 2 stepper motors, recepticle and microtrack run in different directions in JuiceWorks machine.
The direction of the recepticle stepper motor is anticlockwise (i.e. direction = 1) and the direction of the microtrack stepper motor is clockwise (i.e. direction = 0).
Thus here in the function fermeMotor, direction = 1 is send as an default argument. This indicates that the the recepticle conveyor will move forward (anticlockwisse direction = 1)
and the microtrack stepper will move forward in the clockwise direction = 0.
*/