#ifndef Mot_inter_H
#define Mot_inter_H

#include "mbed.h"

/** Jednostavna klasa za pokretanje motora spojenog na H-most, 
  * te prisilno zaustavljanje pomoću interrupt tipkala
  * Autor klase: Josip Lupinski
  */

class Mot_inter{
    public:
        /** Konstruktor H-mosta
        * @param A PWM signal za upravlajnje visokom stranom tranzistora H-mosta A
        * @param B PWM signal za upravlajnje visokom stranom tranzistora H-mosta b
        * @param C INTERRUPT signal za naglo zaustavljanje motora
        * @param D INTERRUPT signal za naglo zaustavljanje motora
        */
        Mot_inter(PinName A, PinName B, PinName C, PinName D);
    
        /** Naredba za pokretanje motora u jednom smjeru
        */
        void naprijed();
    
        /** Naredba za pokretanje motora u drugom smjeru
        */
        void natrag();
    
        /** Naredba za naglo zaustavljanje motora
        */
        void stop();
    
    private:
        PwmOut *A, *B;  //pointeri za Pwm Out objekte
        InterruptIn C;
        InterruptIn D;
        
        /** Naredba za naglo zaustavljanje motora kada se bilo koja tipka aktivira
        */
        void pritisnuto(void);  

};
#endif