#include "mbed.h"
 
Serial pc(USBTX, USBRX);
Serial esp(p28, p27); // tx, rx
DigitalOut reset(p26);
DigitalOut  out1(p23);
DigitalOut led1(LED1);
DigitalOut  led2(LED2);
DigitalOut  led3(LED3);   
DigitalOut led4(LED4);
Timer t;
AnalogIn   Ain2(p19);
 
int  count,ended,timeout,DataRX,bufflen,bufl,servreq,webcounter;
float AdcIn,Ht;
char temp[6];
char webcount[8];
char buf[2024];
char snd[4096];
char webbuff[4096]; 
char webdata[1024];
 
char ssid[32] = "DBkings";     // enter WiFi router ssid inside the quotes
char pwd [32] = "420errrdae"; // enter WiFi router password inside the quotes
 
void SendCMD(),SendWEB(),getreply(),ESPconfig(),ESPsetbaudrate(),startserver(),ReadWebData(),callback(),gettemp(),refresh();
 void dev_recv()
{
    led1 = !led1;
    out1=!out1;
    while(esp.readable()) {
        pc.putc(esp.getc());
    }
}
 
void pc_recv()
{
    led4 = !led4;
    while(pc.readable()) {
        esp.putc(pc.getc());
    }
}

void callback()
{
    led3=!led3;
    refresh();
    while (esp.readable()) {
        snd[count] = esp.getc();
        count++;
    }
    if(strlen(snd)>bufflen) {
        DataRX=1;
        led3=0;
    }
}
 
int main()
{
    reset=0; //hardware reset for 8266
    pc.baud(9600);  // set what you want here depending on your terminal program speed
    pc.printf("\f\n\r-------------ESP8266 Hardware Reset-------------\n\r");
    wait(0.5);
    reset=1;
    timeout=2;
    getreply();
    bufflen=200;
 
    esp.baud(9600);   // change this to the new ESP8266 baudrate if it is changed at any time.
 
    //ESPsetbaudrate();   //******************  include this routine to set a different ESP8266 baudrate  ******************
 
    //ESPconfig();        //******************  include Config to set the ESP8266 configuration  ***********************
    //wait(10);
    startserver();
 
 
 
 //   pc.attach(&pc_recv, Serial::RxIrq);
   // esp.attach(&dev_recv, Serial::RxIrq);
    
    // continuosly get AP list and IP
    while(1) {
        if(DataRX==1) {
            ReadWebData();
            if (servreq == 1) {
                startserver();
            }
            esp.attach(&callback);
            pc.printf("  -------------------------------------\n\n");
            pc.printf("\n\n  HTTP Packet: \n\n%s\n", webdata);
            pc.printf("  -------------------------------------\n\n");
            servreq=0;
        }
    }
 
}
 
// Sets new ESP8266 baurate, change the esp.baud(xxxxx) to match your new setting once this has been executed
void ESPsetbaudrate()
{
    strcpy(snd, "AT+CIOBAUD=115200\r\n");   // change the numeric value to the required baudrate
    SendCMD();
}
 
//  +++++++++++++++++++++++++++++++++ This is for ESP8266 config only, run this once to set up the ESP8266 +++++++++++++++
void ESPconfig()
{

    wait(5);
    pc.printf("\f---------- Starting ESP Config ----------\r\n\n");
        strcpy(snd,".\r\n.\r\n");
    SendCMD();
        wait(1);
    pc.printf("---------- Reset & get Firmware ----------\r\n");
    strcpy(snd,"node.restart()\r\n");
    SendCMD();
    timeout=5;
    getreply();
    pc.printf(buf);
 
    wait(2);
 
    pc.printf("\n---------- Get Version ----------\r\n");
    strcpy(snd,"print(node.info())\r\n");
    SendCMD();
    timeout=4;
    getreply();
    pc.printf(buf);
 
    wait(3);
 
    // set CWMODE to 1=Station,2=AP,3=BOTH, default mode 1 (Station)
    pc.printf("\n---------- Setting Mode ----------\r\n");
    strcpy(snd, "wifi.setmode(wifi.STATION)\r\n");
    SendCMD();
    timeout=4;
    getreply();
    pc.printf(buf);
 
    wait(2);
 
   
 
    pc.printf("\n---------- Listing Access Points ----------\r\n");
    strcpy(snd, "function listap(t)\r\n");
        SendCMD();
        wait(1);
        strcpy(snd, "for k,v in pairs(t) do\r\n");
        SendCMD();
        wait(1);
        strcpy(snd, "print(k..\" : \"..v)\r\n");
        SendCMD();
        wait(1);
        strcpy(snd, "end\r\n");
        SendCMD();
        wait(1);
        strcpy(snd, "end\r\n");
        SendCMD();
        wait(1);
        strcpy(snd, "wifi.sta.getap(listap)\r\n");
    SendCMD();
    wait(1);
        timeout=15;
    getreply();
    pc.printf(buf);
 
    wait(2);
 
    pc.printf("\n---------- Connecting to AP ----------\r\n");
    pc.printf("ssid = %s   pwd = %s\r\n",ssid,pwd);
    strcpy(snd, "wifi.sta.config(\"");
    strcat(snd, ssid);
    strcat(snd, "\",\"");
    strcat(snd, pwd);
    strcat(snd, "\")\r\n");
    SendCMD();
    timeout=10;
    getreply();
    pc.printf(buf);
 
    wait(5);
 
    pc.printf("\n---------- Get IP's ----------\r\n");
    strcpy(snd, "print(wifi.sta.getip())\r\n");
    SendCMD();
    timeout=3;
    getreply();
    pc.printf(buf);
 
    wait(1);
 
    pc.printf("\n---------- Get Connection Status ----------\r\n");
    strcpy(snd, "print(wifi.sta.status())\r\n");
    SendCMD();
    timeout=5;
    getreply();
    pc.printf(buf);
 
    pc.printf("\n\n\n  If you get a valid (non zero) IP, ESP8266 has been set up.\r\n");
    pc.printf("  Run this if you want to reconfig the ESP8266 at any time.\r\n");
    pc.printf("  It saves the SSID and password settings internally\r\n");
    pc.printf("\r\nDONE");
 }
        
void startserver()
{        
    pc.printf("\n---------- Get IP's ----------\r\n");
    strcpy(snd, "print(wifi.sta.getip())\r\n");
    SendCMD();
    timeout=3;
    getreply();
    pc.printf(buf);
    gettemp();
 
    wait(1);
        pc.printf("\n---------- Setting up http server ----------\r\n");
        strcpy(snd, "srv=net.createServer(net.TCP)\r\n");
        SendCMD();
        wait(1);
        strcpy(snd, "srv:listen(80,function(conn)\r\n");
        SendCMD();
        wait(1);
        strcpy(snd, "conn:on(\"receive\",function(conn,payload)\r\n");
        SendCMD();
        wait(1);
        strcpy(snd, "print(payload)\r\n");
        SendCMD();
        wait(5);
        
        strcpy(snd, "conn:send(\"<!DOCTYPE html>\")\r\n");
        SendCMD();
        wait(1);
        
        strcpy(snd, "conn:send(\"<html>\")\r\n");
        SendCMD();
        wait(1);
      
       strcpy(snd, "conn:send(\"<body>\")\r\n");
        SendCMD();
        wait(1);
        
        strcpy(snd, "conn:send(\"<h1> IOT Smart Socket</h1>\")\r\n");
      SendCMD();
        wait(1);
        
        strcpy(snd, "conn:send(\"<h2> Turn Smart Socket On and Off</h2>\")\r\n");
        SendCMD();
        wait(1);
        
        strcpy(snd, "conn:send(\"<p><form><strong> Power:&nbsp&nbsp<input type='text' size=6 value='\")\r\n");
        SendCMD();
        wait(1);
        
        sprintf(snd, "conn:send(\"%s'\")\r\n", temp);
        SendCMD();
        wait(1);
        
        strcpy(snd, "conn:send(\"</sup>Watts\")\r\n");
        SendCMD();
        wait(1); 
           
      if(led2==0) {
      
        strcpy(snd, "conn:send(\"<p><input type='radio' name='led2' value='0' checked>  Socket off\")\r\n");
        SendCMD();
        wait(1);
        
        strcpy(snd, "conn:send(\"<input type='radio' name='led2' value='1' >  Socket on\")\r\n");
        SendCMD();
        wait(1);
        } else {
        strcpy(snd, "conn:send(\"<p><input type='radio' name='led2' value='0'>  Socket off\")\r\n");
        SendCMD();
        wait(1);
        
        strcpy(snd, "conn:send(\"<input type='radio' name='led2' value='1' checked> Socket on\")\r\n");
        SendCMD();
        wait(1);
        } 

      
        strcpy(snd, "conn:send(\"</form><form></strong><p><input type='button' onClick='window.top.location.reload()' value='send-refresh' style='background: #3498db;'</form>\")\r\n");
        SendCMD();
        ReadWebData();
        wait(1);
        
        //strcpy(snd, "conn:send(\"</form>\")\r\n");
        //SendCMD();
        //wait(1);
        
        strcpy(snd, "conn:send(\"</body>\")\r\n");
        SendCMD();
        wait(1);
        
        strcpy(snd, "conn:send(\"</html>\")\r\n");
        SendCMD();
        wait(1);
        
        strcpy(snd, "end)\r\n");
        SendCMD();
        wait(1);
        
        strcpy(snd, "conn:on(\"sent\",function(conn) conn:close() end)\r\n");
        SendCMD();
        wait(1);
        
        strcpy(snd, "end)\r\n");
        SendCMD();
        wait(1);
        timeout=17;
        
    getreply();
    pc.printf(buf);
        pc.printf("\r\nServer Started");
        //ReadWebData();
        esp.attach(&callback);
}
 
void SendCMD()
{
    esp.printf("%s", snd);
}
 
void getreply()
{
    memset(buf, '\0', sizeof(buf));
    t.start();
    ended=0;
    count=0;
    while(!ended) {
        if(esp.readable()) {
            buf[count] = esp.getc();
            count++;
        }
        if(t.read() > timeout) {
            ended = 1;
            t.stop();
            t.reset();
        }
    }
}
void ReadWebData()
{
    wait_ms(200);
    esp.attach(NULL);
    DataRX=0;
    memset(webdata, '\0', sizeof(webdata));
    int x = strcspn (snd,"+");
    if(x) {
        strcpy(webdata, snd + x);
        //int numMatched = sscanf(webdata,"+IPD,%d,%d:%s", &linkID, &ipdLen, type);
        if( strstr(webdata, "led2=1") != NULL ) {
            led2=1;
        }
        if( strstr(webdata, "led2=0") != NULL ) {
            led2=0;
        }
   /*     if( strstr(webdata, "Out1=1") != NULL ) {
            Out1=1;
        }
        if( strstr(webdata, "Out1=0") != NULL ) {
            Out1=0;
        }
        if( strstr(webdata, "Out2=1") != NULL ) {
            Out2=1;
        }
        if( strstr(webdata, "Out2=0") != NULL ) {
            Out2=0;
        }
        if( strstr(webdata, "Out3=1") != NULL ) {
            Out3=1;
        }
        if( strstr(webdata, "Out3=0") != NULL ) {
            Out3=0;
        } */
        //sprintf(channel, "%d",linkID);
        if (strstr(webdata, "GET") != NULL) {
            servreq=1;
        }
        if (strstr(webdata, "POST") != NULL) {
            servreq=1;
        }
        webcounter++;
        sprintf(webcount, "%d",webcounter);
    } else {
        memset(snd, '\0', sizeof(snd));
        esp.attach(&callback);
    }
}
void SendWEB()
{
    int i=0;
    if(esp.writeable()) {
        while(webbuff[i]!='\0') {
            esp.putc(webbuff[i]);
            i++;
        }
    }
} 
void gettemp()
{
    
    AdcIn=Ain2.read();
    Ht = (AdcIn*120); // set the numeric to the exact MCU analog reference voltage for greater accuracy  
    sprintf(temp,"%2.3f",Ht);
    //pc.printf(temp);
}
void refresh()
{
 
  out1=!out1;
  if (out1==0){
      sprintf(temp,"%2.3d",0);}
      else {
          gettemp();}
  wait(.2);
  pc.printf("\n---------- Restarted ----------\r\n");
        strcpy(snd, "srv=net.createServer(net.TCP)\r\n");
        SendCMD();
        wait(.2);
        strcpy(snd, "srv:listen(80,function(conn)\r\n");
        SendCMD();
        wait(.2);
        strcpy(snd, "conn:on(\"receive\",function(conn,payload)\r\n");
        SendCMD();
        wait(.2);
        strcpy(snd, "print(payload)\r\n");
        SendCMD();
        wait(.3);
        
        strcpy(snd, "conn:send(\"<!DOCTYPE html>\")\r\n");
        SendCMD();
        wait(.2);
        
        strcpy(snd, "conn:send(\"<html>\")\r\n");
        SendCMD();
        wait(.2);
      
       strcpy(snd, "conn:send(\"<body>\")\r\n");
        SendCMD();
        wait(.2);
        
        strcpy(snd, "conn:send(\"<h1> IOT Smart Socket</h1>\")\r\n");
      SendCMD();
        wait(.2);
        
        strcpy(snd, "conn:send(\"<h2> Turn Smart Socket On and Off</h2>\")\r\n");
        SendCMD();
        wait(.2);
        
        strcpy(snd, "conn:send(\"<p><form><strong> Power:&nbsp&nbsp<input type='text' size=6 value='\")\r\n");
        SendCMD();
        wait(.2);
        
        sprintf(snd, "conn:send(\"%s'\")\r\n", temp);
        SendCMD();
        wait(.2);
        
        strcpy(snd, "conn:send(\"</sup>Watts\")\r\n");
        SendCMD();
        wait(.2); 
           
      if(out1==0) {
      
        strcpy(snd, "conn:send(\"<p><input type='radio' name='led2' value='0' checked>  Socket off\")\r\n");
        SendCMD();
        wait(.2);
        
        strcpy(snd, "conn:send(\"<input type='radio' name='led2' value='1' >  Socket on\")\r\n");
        SendCMD();
        wait(.2);
        } else {
        strcpy(snd, "conn:send(\"<p><input type='radio' name='led2' value='1'>  Socket off\")\r\n");
        SendCMD();
        wait(.2);
        
        strcpy(snd, "conn:send(\"<input type='radio' name='led2' value='0' checked> Socket on\")\r\n");
        SendCMD();
        wait(.2);
        } 

      
        strcpy(snd, "conn:send(\"</form><form></strong><p><input type='button' onClick='window.top.location.reload()' value='send-refresh' style='background: #3498db;'</form>\")\r\n");
        SendCMD();
        ReadWebData();
        wait(.2);
        
        
        strcpy(snd, "conn:send(\"</body>\")\r\n");
        SendCMD();
        wait(.2);
        
        strcpy(snd, "conn:send(\"</html>\")\r\n");
        SendCMD();
        wait(.2);
        
        strcpy(snd, "end)\r\n");
        SendCMD();
        wait(.3);
        
        strcpy(snd, "conn:on(\"sent\",function(conn) conn:close() end)\r\n");
        SendCMD();
        wait(.3);
        
        strcpy(snd, "end)\r\n");
        SendCMD();
        wait(.3);
        timeout=17;
        
    getreply();
    pc.printf(buf);
        pc.printf("\r\nRestarted");
        //ReadWebData();
        esp.attach(&callback);
}
  