#include "mbed.h"
#include "FreeRTOS.h"
#include "task.h"

#define TASK_STACK_SIZE 128

/* Prototypes for the standard FreeRTOS callback/hook functions implemented 
 * within this file. The extern "C" is required to avoid name mangling between 
 * C and C++ code. 
 */
extern "C" 
{
#if ( configUSE_MALLOC_FAILED_HOOK == 1 )
void vApplicationMallocFailedHook( void );
#endif
#if ( configCHECK_FOR_STACK_OVERFLOW > 0 )
void vApplicationStackOverflowHook( TaskHandle_t pxTask, char *pcTaskName );
#endif
}

DigitalOut led1(LED1);

void task (void*);

int main() 
{
    led1 = 0;
    
    // Create a task.
    xTaskCreate( task, "T01", TASK_STACK_SIZE, NULL, configMAX_PRIORITIES - 1, NULL );
    
    // Start FreeRTOS scheduler.
    vTaskStartScheduler();
    
    // Should never reach here.
    for(;;);
}

/* 
 * Blink LED1 every second (1000 ticks).
 */
void task (void *param)
{
    TickType_t xPreviousWakeTime = ( TickType_t ) 0U;
    
    for(;;) {
        led1 = !led1;
        
        // Delay the task until next period (1 sec)
        vTaskDelayUntil( &xPreviousWakeTime, ( TickType_t ) 1000 );
    }
}

#if ( configUSE_MALLOC_FAILED_HOOK == 1 )
void vApplicationMallocFailedHook( void )
{
    taskDISABLE_INTERRUPTS();
    
    DigitalOut led4(LED4);

    for( ;; ) {
        led4 = 1;
        wait_ms(1000);
        led4 = 0;
        wait_ms(1000);
    }
}
#endif

#if ( configCHECK_FOR_STACK_OVERFLOW > 0 )
void vApplicationStackOverflowHook( TaskHandle_t pxTask, char *pcTaskName )
{
    ( void ) pcTaskName;
    ( void ) pxTask;

    taskDISABLE_INTERRUPTS();
    
    DigitalOut led4(LED4);

    for( ;; ) {
        led4 = 1;
        wait_ms(500);
        led4 = 0;
        wait_ms(500);
    }
}
#endif