// LSM9DS90/uLCD Demo
// ECE 4180 Lab Code Template

#include "mbed.h"
#include "LSM9DS0.h"
#include "uLCD_4DGL.h"
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
  
// uncomment this line to enable the uLCD for Part 4 of the lab
#define PART_4

// SDO_XM and SDO_G are pulled up, so our addresses are:
#define LSM9DS0_XM_ADDR  0x1D // Would be 0x1E if SDO_XM is LOW
#define LSM9DS0_G_ADDR   0x6B // Would be 0x6A if SDO_G is LOW

// refresh time. set to 500 for part 2 and 50 for part 4
#define REFRESH_TIME_MS 200

// Verify that the pin assignments below match your breadboard
LSM9DS0 imu(p9, p10, LSM9DS0_G_ADDR, LSM9DS0_XM_ADDR);
Serial pc(USBTX, USBRX);

#ifdef PART_4
uLCD_4DGL lcd(p28, p27, p30);
#endif

//Init Serial port and LSM9DS0 chip
void setup()
{
#ifdef PART_4
    lcd.baudrate(3000000);
    lcd.background_color(0);
    lcd.cls();
    
    lcd.printf("Initializing...");
#endif

    // Use the begin() function to initialize the LSM9DS0 library.
    // You can either call it with no parameters (the easy way):
    uint16_t status = imu.begin();
}

class Brick { 

public:
    int x; 
    int y;
    int color;
    int width;
    int height;
    bool exist;
    
    Brick(){
        width = 10;
        height = 5;
        exist = true;
    }
    
    void set(int x, int y){
        this->x = x;
        this->y = y;    
    }
};

int main()
{
    setup();  //Setup sensor and Serial
    lcd.cls();

    int score = 0;
    Brick* wall[32];
    srand(time(0));
    for(int i = 0; i < 8; i ++){
        for( int j = 0; j < 4; j++){
            Brick * brick = new Brick();
            brick->set(5 + i * brick->width, 20 + j * brick->height);
            int c = 0;
            int num = rand() % 8 + 1;
            switch (num) {
                case 1:
                    c = 0xff0000;
                    break;
                case 2:
                    c = 0xffff00;
                    break;
                case 3:
                    c = 0x00FF00;
                    break;
                case 4:
                    c = 0x0000FF;
                    break;
                case 5:
                    c = 0xFFC0CB;
                    break;
                case 6:
                    c = 0xA52A2A;
                    break;
                case 7:
                    c = 0xd3d3d3;
                    break;
                case 8:
                    c = 0x800080;
                    break; 
                default:
                    c = 0x445566;
            }
            brick->color = c;
            wall[i*4 + j] = brick;
        }
    }
    
    float player_x = 60.0;
    float player_y = 120.0;
    float p_width = 30.0;
    
    float ball_x = 23.0;
    float ball_y = 49.0;
    float ball_vx = 15.0;
    float ball_vy = 15.0;
    float ball_r = 2.0;
    float width = 110.0;
    float height = 120.0;
    bool end = false;
    bool win = false;
    
    while (!end && !win)
    {
        lcd.cls();
        lcd.printf("score is %d", score);
        imu.readMag();
        imu.readAccel();
        
        for(int i = 0; i < 32; i++ ){
            if(wall[i]->exist){
                lcd.filled_rectangle(wall[i]->x, wall[i]->y, wall[i]->x + wall[i]->width, wall[i]->y + wall[i]->height, wall[i]->color);        
            }
        }
        
        lcd.circle(ball_x, ball_y, ball_r, RED);
        lcd.line(player_x, player_y, player_x + p_width, player_y, BLUE);
        
        ball_x += ball_vx * 0.7;
        ball_y += ball_vy * 0.7;
        player_x = player_x - imu.ax_raw * 0.003;
        
        if(player_x + p_width > width){
            player_x = width - p_width;    
        }
        
        if(player_x < 0){
            player_x = 0;     
        }
        
        if(ball_x + ball_r > width){
            ball_x = width - ball_r;
            ball_vx *= -1;
        }
        
        if(ball_x - ball_r < 0){
            ball_x = ball_r;
            ball_vx *= -1;   
        }
        
        if(ball_y + ball_r > height){
            if(ball_x < player_x || ball_x > player_x + p_width){
                end = true;
            } else {
                ball_y = height - ball_r;
                ball_vy *= -1;
            }
        }
        
        if(ball_y - ball_r < 0){
            ball_y = ball_r;
            ball_vy *= -1;
        }
        
         for(int i = 0; i < 32; i++ ){
            if(wall[i]->exist){
                if (!(ball_x > wall[i]->x + wall[i]->width || 
                ball_x + ball_r < wall[i]->x ||
                ball_y > wall[i]->y + wall[i]->height ||
                ball_y + ball_r < wall[i]->y)){
                        wall[i]->exist = false;
                        score++;
                }    
            }
        }
        if(score == 32){
            win = true;    
        }
        wait_ms(REFRESH_TIME_MS);
    }
    lcd.cls();
    
    if(win){
        lcd.printf("You Win!!!");
    } else {
        lcd.printf("Game Over...");
    }
}
