#include "mbed.h"
#include "BiQuad.h"
#include "HIDScope.h"
#include "BiQuadchains_zelfbeun.h"
//#include "MODSERIAL.h"

//MODSERIAL pc(USBTX, USBRX);

//Input system
AnalogIn emg1(A0); //right biceps
AnalogIn emg2(A1); //right triceps
AnalogIn emg3(A2); //left biceps
AnalogIn emg4(A3); //left triceps
DigitalOut ledje1(LED_GREEN); 
DigitalOut ledje2(LED_RED); 
DigitalOut ledje3(LED_BLUE); 

//EMG tickers, these tickers are called in the mainscript with fsample 500Hz, also sends to HIDscope with same fsample
Ticker sample_ticker; 


//HIDscope to check whether filter is functional or not
HIDScope scope(4);  // number of channels




//Filtered EMG signals from the end of the chains
double emg1_filtered, emg2_filtered, emg3_filtered, emg4_filtered;
volatile int i = 0;

void emgsample(){
    //All EMG signal through Highpass
    double emgread1 = emg1.read();
    double emgread2 = emg2.read();
    double emgread3 = emg3.read();
    double emgread4 = emg4.read();
  
    double emg1_highpassed = highp1.step(emgread1);
    double emg2_highpassed = highp2.step(emgread2);
    double emg3_highpassed = highp3.step(emgread3);
    double emg4_highpassed = highp4.step(emgread4);
    
    //All EMG highpassed through Notch
    double emg1_notched = notch1.step(emg1_highpassed);
    double emg2_notched = notch2.step(emg2_highpassed);
    double emg3_notched = notch3.step(emg3_highpassed);
    double emg4_notched = notch4.step(emg4_highpassed);
    
    //All EMG notched rectify
    double emg1_abs = abs(emg1_notched);
    double emg2_abs = abs(emg2_notched);
    double emg3_abs = abs(emg3_notched);
    double emg4_abs = abs(emg4_notched);
    
    //All EMG abs into lowpass
    emg1_filtered = lowp1.step(emg1_abs);
    emg2_filtered = lowp2.step(emg2_abs);
    emg3_filtered = lowp3.step(emg3_abs);
    emg4_filtered = lowp4.step(emg4_abs);
    
    
    //Send data to HIDScope
    scope.set(0,emg1_filtered );
    scope.set(1,emg2_filtered);
    scope.set(2,emg3_filtered);
    scope.set(3,emg4_filtered);
    scope.send();
    
    //Ticker for i 
    i++;
    }
   
    //Define doubles for calibration and ticker
    double ts = 0.001; //tijdsstap
    double calibration_time = 55; //time EMG calibration should take
    
    volatile double temp_highest_emg1 = 0;
    volatile double temp_highest_emg2 = 0;
    volatile double temp_highest_emg3 = 0;
    volatile double temp_highest_emg4 = 0;
    
    
    //void icounter(){
    //    i++;
    //    }
    
    void CalibrationEMG()
    {
        static float samples = calibration_time/ts;

        while(i<samples){
            if(i>0 && i<(10/calibration_time*samples))
                {
                ledje1=!ledje1;
                if(emg1_filtered>temp_highest_emg1)
                    {
                    temp_highest_emg1= emg1_filtered;
                    }
                }
            if(i>(10/calibration_time*samples) && i<(15/calibration_time*samples))
                {
                ledje1=0;   
                ledje2=0;
                ledje3=0;
                }
            if(i>(15/calibration_time*samples) && i<(25/calibration_time*samples))
                {
                ledje2=!ledje2;
                if(emg2_filtered>temp_highest_emg2)
                    {
                    temp_highest_emg2= emg2_filtered;
                    }
                }
            if(i>(25/calibration_time*samples) && i<(30/calibration_time*samples))
                {
                ledje1=0;   
                ledje2=0;
                ledje3=0;          
                }
            if(i>(30/calibration_time*samples) && i<(40/calibration_time*samples))
                {
                ledje3=!ledje3;
                if(emg3_filtered>temp_highest_emg3)
                    {
                    temp_highest_emg3= emg3_filtered;
                    }
                }
            if(i>(40/calibration_time*samples) && i<(45/calibration_time*samples))
                {
                ledje1=0;   
                ledje2=0;
                ledje3=0;       
                }
            if(i>(45/calibration_time*samples) && i<(55/calibration_time*samples))
                {
                ledje2=!ledje2;
                ledje3=!ledje3;
                if(emg3_filtered>temp_highest_emg3)
                    {
                    temp_highest_emg3= emg3_filtered;
                    }
                }
    ledje1=1;
    ledje2=1;
    ledje3=1;
    

    }
    
    /* pc.printf("Highest value right biceps= %f \r\n", temp_highest_emg1);
    pc.printf("Highest value right triceps= %f \r\n", temp_highest_emg2);
    pc.printf("Highest value left biceps= %f \r\n", temp_highest_emg3);
    pc.printf("Highest value left triceps= %f \r\n", temp_highest_emg4);
    */
}
int main() {
    //Turn the leds off
    ledje1 = 1;
    ledje2 = 1;
    ledje3 = 1;
    
     //pc.baud(115200);
     
    highp1.add( &highp1_1 ).add( &highp1_2 );
    notch1.add( &notch1_1 ).add( &notch1_2 );
    lowp1.add( &lowp1_1 ).add(&lowp1_2);
    
    highp2.add( &highp2_1 ).add( &highp2_2 );
    notch2.add( &notch2_1 ).add( &notch2_2 );
    lowp2.add( &lowp2_1 ).add(&lowp2_2);    
    
    highp3.add( &highp3_1 ).add( &highp3_2 );
    notch3.add( &notch3_1 ).add( &notch3_2 );
    lowp3.add( &lowp3_1 ).add(&lowp3_2);
     
    highp4.add( &highp4_1 ).add( &highp4_2 );
    notch4.add( &notch4_1 ).add( &notch4_2 );
    lowp4.add( &lowp4_1 ).add(&lowp4_2);
    
    //Treshholding
    double threshold1 = temp_highest_emg1*0.75;
    double threshold2 = temp_highest_emg2*0.75;
    double threshold3 = temp_highest_emg3*0.75;
    double threshold4 = temp_highest_emg4*0.75;
    
    
    
    sample_ticker.attach(&emgsample, ts);
    
    CalibrationEMG();
    
    
    while(true){}

}