#include "mbed.h"
#include "TS_DISCO_F746NG.h"
#include "LCD_DISCO_F746NG.h"

//configura pino de interrupção para utilizar no botão da placa (botão azul)
InterruptIn button(USER_BUTTON);

//configura um pino de saida (no caso o D0)
DigitalOut led(D0);

LCD_DISCO_F746NG lcd; //objetod e controle do display lcd
TS_DISCO_F746NG ts; //objeto de controle do TOUCH

//pressionou o botão
void pressed()
{
    led = 1; //ativa o led
}
//soltou o botão
void released()
{
    led = 0; //desativa o led
}

int main()
{
    // Assign functions to button
    button.fall(&released); //botão solto
    button.rise(&pressed); //botão pressionado
    
    TS_StateTypeDef TS_State; //variavel de controle para identificar toque na tela
    uint16_t x, y; 
    uint8_t status; 
    status = ts.Init(lcd.GetXSize(), lcd.GetYSize()); //inicializa o TOUCH
    
    //touch inicializado com sucesso
    if (status != TS_OK) {
        lcd.Clear(LCD_COLOR_RED);
        lcd.SetBackColor(LCD_COLOR_RED);
        lcd.SetTextColor(LCD_COLOR_WHITE);
        lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"TOUCHSCREEN INIT FAIL", CENTER_MODE);
    } else { //touch com falha
        lcd.Clear(LCD_COLOR_GREEN);
        lcd.SetBackColor(LCD_COLOR_GREEN);
        lcd.SetTextColor(LCD_COLOR_WHITE);
        lcd.DisplayStringAt(0, LINE(5), (uint8_t *)"TOUCHSCREEN INIT OK", CENTER_MODE);
    }
    
    wait(1);
    lcd.Clear(LCD_COLOR_BLUE);
    lcd.SetBackColor(LCD_COLOR_BLUE);
    lcd.SetTextColor(LCD_COLOR_WHITE);
    lcd.DrawCircle(230, 135, 40); //desenha o circulo na tela
    
    
    while (1) {
        
        ts.GetState(&TS_State); //verifica toque na tela
        if (TS_State.touchDetected) {   //houve toque
                x = TS_State.touchX[0];
                y = TS_State.touchY[0];  
                double d = sqrt( pow(x - 230.0, 2.0) + pow(y - 135.0,2.0) ); //distancia entre o ponto tocado e o centro do circulo
                if(d <= 40) //toque dentro do circulo
                {
                    status = 1; //controle que tocou no circulo
                    lcd.FillCircle(230, 135, 40); //pinta o circulo de branco
                    led = 1; //ativa o led
                }
        }
        else { //sem toque detectado
            if(status == 1) { //se anteriormente tocou no circulo
                lcd.Clear(LCD_COLOR_BLUE); //limpa a tela 
                lcd.DrawCircle(230, 135, 40); //desenha o circulo
                status = 0; //controle que nao tocou no circulo
                led = 0; //desativa o led
            }
        }

            
    }
}
