/*
                  |<--Temperature/Humidity sensor
            ----->|<--Movemtent sensor
           |      |-->HBRIDGE-->MOTORS
           v       
    *FRDM board     |
    *Webcam c270    |
    *Serial_USB     |  
    or sensors      |
    *usb memory     |
    *cellphone      |<--->USB_HUB <--->MR3020 <---->INTERNET<----->USER
    .                                 (openwrt)
    .                                 8080 server
    .
   -------------------------------------------------------------- 
                    All supported in a 5V 2200mA battery pack
                                    |        
                            inalambric charger
 */
#include "mbed.h"
////////// serial variables
bool Rxenable = false;
char inputString []="00000";         //a string to hold incoming data
bool stringComplete = false;  //whether the string is complete
int  i_pnt =0;
bool DEBUG =false;
Serial pc(USBTX, USBRX);
//TX RX pins, see https://mbed.org/handbook/mbed-FRDM-KL25Z
Serial uart(PTC4, PTC3);
//to test is you can use a hard bridge (piece of cable) between PTC4 and PTC3 open a terminal and write something :) 
//you can integrate this to improve some interesting aplicattions like this:
//http://www.instructables.com/id/Temperature-sensor--weatherstation/http://www.instructables.com/id/Temperature-sensor--weatherstation/ 
DigitalOut LED1_P(LED1);
DigitalOut LED2_P(LED2);
DigitalOut LED3_P(LED3);
/*
 SerialEvent occurs whenever a new data comes in the
 hardware serial RX.  This routine is run between each
 time loop() runs, so using delay inside loop can delay
 response.  Multiple bytes of data may be available.
 */
void serialEvent() {
  if (pc.readable()) 
  {
  if (DEBUG) pc.printf("pc.read\n");
  char inChar = (char)pc.getc(); // get the new byte:
    if (inChar == '@' && Rxenable==false) 
    {     // Can start recording after @ symbol
    if (DEBUG) pc.printf("char@received\n");
    Rxenable = true;
    }
    if (Rxenable==true) 
    {
    i_pnt=i_pnt+1;    
    inputString[i_pnt] =  inChar; // add it to the inputString:
    if (DEBUG) pc.printf("pnt %i\t char received %c\n",i_pnt,inChar);
    // if the incoming character:q is a carriage return, set a flag
    // so the main loop: can do something about it:
    if (inChar == '\r') 
     {
    stringComplete = true;
    Rxenable = false;
    if (DEBUG) pc.printf("inchar r\n");
    if (DEBUG) printf("input string%s\n",inputString);
     i_pnt=0;
    } 
    }
  }
}

void process_command()
{
  char command=inputString[2];
    if (DEBUG) pc.printf("command %c\n",command);  
  switch (command) {
    case '1':  
    //car_forward();
    LED1_P=1;
    LED2_P=0;
    LED3_P=0;
    if (DEBUG) pc.printf("case1"); 
//    stringComplete=false;    
    break;   
    case '2':
    LED1_P=0;
    LED2_P=1;
    LED3_P=0;
    if (DEBUG) pc.printf("case2"); 
//    stringComplete=false;    
    //car_headLight();
    break;   
    case '3':
    LED1_P=1;
    LED2_P=1;
    LED3_P=0;
    if (DEBUG) pc.printf("case3"); 
 //   stringComplete=false;    
    //car_headLight();
    break; 
    case '4':
    LED1_P=0;
    LED2_P=0;
    LED3_P=1;
    if (DEBUG) pc.printf("case4"); 
 //   stringComplete=false;    
    //car_headLight();
    break; 
    case '5':
    LED1_P=1;
    LED2_P=0;
    LED3_P=1;
    if (DEBUG) pc.printf("case5"); 
 //   stringComplete=false;    
    //car_headLight();
    break; 
    case '6':
    LED1_P=0;
    LED2_P=1;
    LED3_P=1;
    if (DEBUG) pc.printf("case6"); 
 //   stringComplete=false;    
    //car_headLight();
    break; 
    case '7':
    LED1_P=1;
    LED2_P=1;
    LED3_P=1;
    if (DEBUG) pc.printf("case7"); 
 //   stringComplete=false;    
    //car_headLight();
    break; 
    case '8':
    LED1_P=0;
    LED2_P=1;
    LED3_P=0;
    if (DEBUG) pc.printf("case8"); 
 //   stringComplete=false;    
    //car_headLight();
    break; 
    case 'S':
    LED1_P=1;
    LED2_P=0;
    LED3_P=1;
    if (DEBUG) pc.printf("caseS"); 
 //   stringComplete=false;    
    //car_headLight();
    break; 
  }  
}

int main() {
pc.printf("Openwrt-car wifi application\n");
pc.baud(9600);
wait(0.001);
LED1_P=1;
LED2_P=1;
LED3_P=1;
while(1) {
serialEvent();
 if (stringComplete) {
    process_command();
    //inputString = "00000"; //clear the string:
    stringComplete = false;
   }
  }
}