#include "ur_Bertl.h"
#include "mbed.h"
#include "const.h"
#include "Robot.h"

class task_Bertl : public ur_Bertl
{
public:
    void TurnRight() {
        TurnLeft();
        TurnLeft();
        TurnLeft();
    }
    void Move2Boxes() {
        Move();
        Move();
    }
    void ClearAllBeepersToTheWall();
};



void task_Bertl :: ClearAllBeepersToTheWall()
{
    while (FrontIsClear()) {
        if ( NextToABeeper()) {
            PickBeeper();
            Move();}
        else {
            Move();}
    }
}

int main ()
{
    task_Bertl karel;

    // Task 1 & 2

    while(karel.WaitUntilButtonPressed()){}

    while(karel.IsButtonPressed(BTN_FLL)) { // Vorne Links
        karel.TurnLedOn(0x01);
        wait(0.3);
        karel.TurnLedOn(0x00);
        wait(0.3);
    }

    while(karel.IsButtonPressed(BTN_FRR)) { // Vorne Rechts
        karel.TurnLedOn(0x04);
        wait(0.3);
        karel.TurnLedOn(0x00);
        wait(0.3);
    }

    while(karel.IsButtonPressed(BTN_BR)) { // Hinten Rechts
        karel.TurnLedOn(0x80 | 0x40);
        wait(0.3);
        karel.TurnLedOn(0x00);
        wait(0.3);
    }
    
    while(karel.IsButtonPressed(BTN_BL)) { // Hinten Links
        karel.TurnLedOn(0x20 | 0x10 );
        wait(0.3);
        karel.TurnLedOn(0x00);
        wait(0.3);
    }

    while(!karel.IsButtonPressed(BTN_FLL && BTN_FRR && BTN_BR && BTN_BL)) {
        karel.TurnLedOn(0x00);}
    
    
    if(karel.IsButtonPressed(BTN_BM))
        karel.TurnLedOff(0xFF);

}