#include "PMS1003.h"


void PMS1003::pmProcess(Serial &serial)
{
  int count = 0;
  byte incomeByte[32];
  boolean pmFlag = false;
  byte data;
  while (1){
    
    if (serial.available()){
      data = serial.read();
      if (data == 0x42 && !pmFlag) {
        pmflag = true;
        count++;
        incomeByte[0] = data;
      }
      else if (pmFlag) {
        count++;
        incomeByte[count - 1] = data;
        if (count >= 32){
          break;
        }
      }
    }
  }
  unsigned int calcsum = 0;
  unsigned int exptsum;
  for (int i = 0; i < 29; i++) {
    calcsum += (unsigned int)incomeByte[i];
  }
  exptsum = ((unsigned int)incomeByte[CHECK_BYTE] << 8) + (unsigned int)incomeByte[CHECK_BYTE + 1];
  if (calcsum == exptsum) {
    pm25 = ((unsigned int)incomeByte[PM25_BYTE] << 8) + (unsigned int)incomeByte[PM25_BYTE + 1];
  } else {
    
    pm25 = -1;
  }
  return;
}

int PMS1003::getPM25() {
  return pm25;
}
