#include "mbed.h"
#include "max32630fthr.h"
#include "Adafruit_SSD1306.h"
#include "USBSerial.h"

MAX32630FTHR pegasus(MAX32630FTHR::VIO_3V3);

I2C oledI2C(P3_4, P3_5); // SDA, SCL

// Hardware serial port over DAPLink
Serial daplink(P2_1, P2_0);

// serial port for pm1003
Serial pmSerial(P3_1, P3_0);
//for 595 drive LED bar
DigitalOut ledbarClk(P5_3);
DigitalOut ledbardat(P5_4);
DigitalOut ledbarlatch(P5_5);
DigitalOut ledEnable(P5_6);
int airBufferPrcess( float a, float b);
void shirftDate(unsigned int date);
/* Analog inputs 0 and 1 have internal dividers to allow measuring 5V signals  
 * The dividers are selected by using inputs AIN_5 and AIN_5 respectively.
 * The full scale range for AIN0-3 is 1.2V
 * The full scale range for AIN4-5 is 6.0V
 */
AnalogIn fireAir(AIN_4); 
AnalogIn alcohol(AIN_5); 

// main() runs in its own thread in the OS
// (note the calls to Thread::wait below for delays)
int main()
{
    char incomeByte[32];
    unsigned int pm25;
    unsigned int pm1;
    unsigned int pm10;
    unsigned int airDisplayDate;
    //unsigned int alcoholDate,fireAirDate;

    //daplink.printf("start \r\n");
    pmSerial.baud(9600);

    Thread::wait(50);  // Give the supplies time to settle before initializing the display
    Adafruit_SSD1306_I2c OLED(oledI2C);  
    //OLED.printf("%ux%u OLED Display\r\n", OLED.width(), OLED.height());
    //OLED.printf("HelloWorld \r");
    //OLED.display();

    //daplink.printf("OLED init over \r\n");
    while(1) {
        Thread::wait(250);
        
        while(pmSerial.getc() !=0x42){}
            if(pmSerial.getc() == 0x4d){
                for(int i = 2; i < 32; i++){
                    incomeByte[i] = pmSerial.getc();
                }
                
                unsigned int calcsum = 0;
                incomeByte[0] = 0x42;
                incomeByte[1] = 0x4d;
                unsigned int exptsum = (incomeByte[30]<<8) + incomeByte[31];
                for(int i = 0; i < 30; i++){
                    calcsum += incomeByte[i];
                   // daplink.printf("income[%d],%d\n",i,incomeByte[i]);
                }
                if( calcsum == exptsum)
                {
                   //daplink.printf("check ok \n");
                   pm1 = incomeByte[10] + incomeByte[11];
                   pm25 = incomeByte[12] + incomeByte[13];
                   pm10 = incomeByte[14] + incomeByte[15];

                   //daplink.printf("pm1:%d\n",pm1);
                   //daplink.printf("pm2.5:%d\n",pm25);
                   //daplink.printf("pm10:%d\n",pm10);

                }
        
        }
       
        Thread::wait(10);
        OLED.clearDisplay();
        OLED.setTextCursor(0,0);
        OLED.printf("Car air memter \n");
        OLED.printf("CO: %1.2f\n", (6.0f * fireAir) );  // fireAir inputs 4
        OLED.printf("alcohol: %1.2f\n", (6.0f * alcohol) );  // alcohol inputs 5
        OLED.printf("PM2.5: %d \n", pm25 );  //
        OLED.printf("PM10 : %d \n", pm10 );  // 
        OLED.printf("PM1  : %d \n", pm1 );  // 
        OLED.display();
        daplink.printf("CO     : %1.2f\n", (6.0f * fireAir) );
        daplink.printf("alcohol: %1.2f\n", (6.0f * alcohol) );
                
        airDisplayDate = airBufferPrcess( (6.0f * fireAir), (6.0f *alcohol) );
        daplink.printf("date for shirtf:%d\n",airDisplayDate);
        ledEnable = 1;
        ledEnable = 0;
        shirftDate( (~airDisplayDate)<<4 );
        Thread::wait(500); 
        //shirftDate( 0x00ffff);
        
        while((pm25 > 100)||(fireAir > 1)||(alcohol > 1)){
            
            OLED.clearDisplay();
            Thread::wait(50);
            OLED.printf("ERROR \n");
            OLED.printf("ERROR \n");
            OLED.printf("ERROR \n");
            OLED.printf("ERROR \n");
            OLED.printf("ERROR \n");
            OLED.printf("ERROR \n");
            OLED.display();
            Thread::wait(500);            
            }
        
    
    }
}

/*传入LB数据,共24位取低位24*/
/*低20位用于两个LED bar*/
void shirftDate(unsigned int date){
    unsigned int _date = date;
    //_date &= 0xfffff;
    for( int i = 24; i >= 0; i-- ){
        if( _date  & (0x01 << i ) ){
            ledbardat = 1;            
        }else{
            ledbardat = 0;
        }
       // daplink.printf("date ledbardat:%d\n",ledbardat);
        Thread::wait(0.5);
        ledbarClk = 0;
        Thread::wait(0.5);
        ledbarClk = 1;
    }
    // /*补充4位空白*/
    // for(int i= 0; i < 4 ; i++){
    //         ledbardat = 0;
    //         ledbarClk = 1;
    //         Thread::wait(0.5);
    //         ledbarClk = 0;
    // }

    ledbarlatch = 0;
    Thread::wait(0.5);
    ledbarlatch = 1;

}

//空气模拟数据处理，a，b分别表示 CO与acohol；
//采用对数级浓度增加对应一位,
int airBufferPrcess( float a, float b)
{
    unsigned int _a , _b;
     _a = (unsigned int)( a / 0.1);
     _b = (unsigned int)( b / 0.1);
     daplink.printf("airDisplayDate:%d\n",_a);
     daplink.printf("airDisplayDate:%d\n",_b);
    unsigned int _ProcessDate[3]={1,1,0};
    for(int i=0;i<10;i++){
        _a >>= 1;
        _b >>= 1;
        if(_a > 0){
            _ProcessDate[0] <<= 1;
            _ProcessDate[0]++;
        }
        if(_b > 0){
            _ProcessDate[1] <<= 1;
            _ProcessDate[1]++;
        }
    _ProcessDate[2] = ( _ProcessDate[0] << 10);
    _ProcessDate[2] += _ProcessDate[1];
    }

    return _ProcessDate[2];
}
