//TRABAJO PRACTICO 1 - SIMON

#include "mbed.h"
#include <stdlib.h>     /* srand, rand */
#include <time.h>       /* time */
#include "tsi_sensor.h"


/* This defines will be replaced by PinNames soon */
#if defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
#define ELEC0 9
#define ELEC1 10
#elif defined (TARGET_KL05Z)
#define ELEC0 9
#define ELEC1 8
#else
#error TARGET NOT DEFINED
#endif



TSIAnalogSlider tsi(ELEC0, ELEC1, 40);



AnalogIn aleatorio(PTB0);

DigitalOut rojo(LED_RED);           //Definimos como salidas los leds
DigitalOut azul(LED_BLUE);          
DigitalOut verde(LED_GREEN);

Ticker resultado;

Ticker gameplay;

Ticker sensor;

void juego();                       //Esta funcion va a manejar el juego    
void indicador_fin_funcion();       //Esta funcion es para el control de leds
void llenado_vector();              //Esta funcion va a guardar los diferentes colores para el juego

int llenado_vector_estado=0,indicador_fin_estado=0,game_over=0,juego_estado,luces_color=0,tiempo_On=0,incremento=0,nivel_max=24,espera=0;



char luces[23];                     //Vector donde se guardan todos los colores del juego
enum {INICIO,ALEATORIO,LLENADO};    
enum {R,G,B};

enum {NO_PIERDO, PERDISTE,SIGUIENTE_NIVEL, GANASTE};

enum {APAGADO,ENCENDIDO};
char indicador_fin;

enum {DEFAULT, ACTUAL, RESPUESTA};
enum {COMIENZO,GANADOR,PERDEDOR};

enum {NO_TOCO,TOCO};
int titileo=0,tocaste_tsi=0;

int nivel;
volatile int u=0;

int n=0,c=0, k=0, j=0,lose=0,comienzo_slider=0;
int main()
{
    rojo=1;
    azul=1;
    verde=1;
    juego_estado = DEFAULT;         //Seteamos en el estado de Default ya que es el reset del juego
    while(1) {
        float d = tsi.readPercentage();      //Lee el tsi para iniciar el juego
       if(comienzo_slider<3){                //Para comenzar el juego se desliza el dedo sobre el tsi,entonces va detectando de a rangos
        if((d>(float)0.1)&&(d<(float)0.3)){  //Mientras se desliza el dedo hay un juego e luces con los colores del led
            rojo=0;
            verde=1;
            azul=1;
            }
        else if((d>(float)0.3)&&(d<(float)0.6)){
            rojo=1;
            verde=0;
            azul=1;
            }
        else if((d>(float)0.6)&&(d<(float)0.9)){
            rojo=1;
            verde=1;
            azul=0;
            }
        else if((d>=(float)0.9)){
            rojo=1;
            verde=1;
            azul=1;
        }
        }      
        if(d==(float)0 && (comienzo_slider==0)){        
            comienzo_slider=1;                          
        }
        if((d>(float)0.3) && (d<(float)0.7) && (comienzo_slider==1)){
            comienzo_slider=2;
        }
        if((d>(float)0.9) && (d<(float)0.99) && (comienzo_slider==2)){
            rojo=1;
            verde=1;
            azul=1;
            printf("QUE COMIENCE EL JUEGO!\r\n\n");
            d=0;
            comienzo_slider=3;
        }
        
        if(comienzo_slider==3){
            juego();
        }
        if(titileo==4) {
            resultado.detach();
            comienzo_slider=0;
            titileo=0;
            game_over=COMIENZO;
            nivel=0;
        }
    }
}
void llenado_vector() //elije un numero aleatorio del 0 al 2 y crea un vector con una secuencia de colores
{
    switch(llenado_vector_estado) {
        case INICIO:
            srand(int(aleatorio * 1000));
            if(n<nivel_max) {
                llenado_vector_estado = ALEATORIO; //se van creando numeros aleatorios hasta que el vector se llene
            }
            break;

        case ALEATORIO:
            c=rand()%3;
            llenado_vector_estado = LLENADO;
            break;

        case LLENADO:
            luces_color=c;
            if(n<nivel_max) {//se lo diferencia entre los 3 colores y se lo asigna al vector
                if(luces_color==R) {
                    luces[n]='R';
                }

                if(luces_color==G) {
                    luces[n]='G';
                }

                if(luces_color==B) {
                    luces[n]='B';
                }
                n++;//lleva la cuenta de la posicion del vector
                llenado_vector_estado = ALEATORIO;
            } else {
                llenado_vector_estado = INICIO;
            }
            break;
    }
}

void indicador_fin_funcion()
{
    switch(indicador_fin_estado) {
        case APAGADO:
            if(indicador_fin=='R') {
                rojo=1;
            }
            if(indicador_fin=='G') {
                verde=1;
            }
            indicador_fin_estado=ENCENDIDO;
            titileo++;
            break;
        case ENCENDIDO:
            if(indicador_fin=='R') {
                rojo=0;
            }
            if(indicador_fin=='G') {
                verde=0;
            }
            indicador_fin_estado=APAGADO;
            break;
    }
}

void muestra()//lee el vector hasta el nivel asignado
{
    tiempo_On++;//se utiliza para contabilizar el tiempo y poder apagar los leds al finalizar
    if(tiempo_On==2) {
        rojo=1;
        verde=1;
        azul=1;
        tiempo_On=0;
    }
    if((u<(nivel+2))&&(tiempo_On==1)) {
        if(luces[u]=='R') {
            rojo=0;
            verde=1;
            azul=1;
        }
        if(luces[u]=='G') {
            rojo=1;
            verde=0;
            azul=1;
        }
        if(luces[u]=='B') {
            rojo=1;
            verde=1;
            azul=0;
        }
        u++;
    }
    if(u==(nivel+1)) {
        rojo=1;
        verde=1;
        azul=1;
    }
}

void leer_tsi()
{

    float v = tsi.readPercentage();

    if(j==nivel) {
        if(nivel==nivel_max) {
            lose=GANASTE;//si el nivel es maximo se gana
        } else {
            lose=SIGUIENTE_NIVEL;//j que es quien detecta color por color detecta que llego al nivel actual, envia al siguiente nivel
            incremento=1;
        }
    }
    if((v>=(float)0.05 )&& (v<=(float)0.33) && (tocaste_tsi==NO_TOCO)) {      //Rojo, si el color que se toca es rojo y no coincide con el vector significa que esta mal y perdio, de lo contrario es correcto y sigue con el juego
        if(luces[j]=='R') {
            j++;
            printf("COLOR SELECCIONADO ROJO \r\n\n");
            v=0;
            azul=1;
            rojo=0;
            verde=1;
            espera=0;
            tocaste_tsi=TOCO;
        } else {
            azul=1;
            rojo=0;
            verde=1;
            lose=PERDISTE;
            printf("HAZ PERDIDO. EL ROJO NO ERA, LO 100TO\n\r");
        }
    } else if((v>=(float)0.40 )&& (v<=(float)0.60) && (tocaste_tsi==NO_TOCO)) {       //Verde, si el color que se toca es verde y no coincide con el vector significa que esta mal y perdio, de lo contrario es correcto y sigue con el juego
        if(luces[j]=='G') {
            j++;
            printf("COLOR SELECCIONADO VERDE \r\n\n");
            v=0;
            azul=1;
            rojo=1;
            verde=0;
            espera=0;
            tocaste_tsi=TOCO;
        } else {
            azul=1;
            rojo=1;
            verde=0;
            printf("HAZ PERDIDO. EL VERDE NO ERA, LO 100TO\n\r");
            lose=PERDISTE;
        }
    } else if((v>=(float)0.70 )&& (v<=(float)0.98) && (tocaste_tsi==NO_TOCO)) {        //Azul, si el color que se toca es azul y no coincide con el vector significa que esta mal y perdio, de lo contrario es correcto y sigue con el juego
        if(luces[j]=='B') {
            j++;
            printf("COLOR SELECCIONADO AZUL \r\n\n");
            v=0;
            azul=0;
            rojo=1;
            verde=1;
            espera=0;
            tocaste_tsi=TOCO;
        } else {
            azul=0;
            rojo=1;
            verde=1;
            printf("HAZ PERDIDO. EL AZUL NO ERA, LO 100TO\n\r");
            lose=PERDISTE;
        }
    }
    else if(v==(float)0){
        tocaste_tsi=NO_TOCO;
    
    }

    if(lose==NO_PIERDO){
        if(espera==1){    
        azul=1;
        rojo=1;
        verde=1;
        espera=0;
        }
        else{
            espera++;
        }
    }
    else if(lose==PERDISTE) {
        azul=1;
        rojo=1;
        verde=1;
        j=0;
        sensor.detach();//deja de leer el tsi
        game_over=PERDEDOR;
        juego_estado=DEFAULT;//vuelve al inicio
        lose=NO_PIERDO;
        printf("FIN DE LA PARTIDA\r\n\n");
    }
    else if(lose==SIGUIENTE_NIVEL) {
        azul=1;
        rojo=1;
        verde=1;
        u=0;
        gameplay.attach(&muestra, 0.35);//muestra los colores hasta el nivel actual
        sensor.detach();//deja de leer el tsi
        juego_estado=ACTUAL;//lleva a incrementar el nivel
        j=0;
        lose=NO_PIERDO;
        printf("\nASCIENDES AL NIVEL %d!\r\n", (nivel+1));
    }
    else if(lose==GANASTE) {
        azul=1;
        rojo=1;
        verde=1;
        j=0;
        sensor.detach();//deja de leer el tsi
        game_over=GANADOR;
        juego_estado=DEFAULT;//vuelve al inicio
        lose=NO_PIERDO;
        printf("\n\nGANASTE!\r\n\n");
    }
}


void juego()
{
    switch(juego_estado) {
        case DEFAULT:
            if(game_over==COMIENZO) {
                nivel=0;
                llenado_vector();
                if(n==nivel_max) {//cuando se llega al nivel maximo
                    juego_estado=ACTUAL;
                    u=0;
                    gameplay.attach(&muestra, 0.35);
                    incremento=1;
                }
            }
            if(game_over==GANADOR) {
                titileo=0;
                indicador_fin='G';//indica el led verde
                resultado.attach(&indicador_fin_funcion, 0.5);//activa el indicador
                game_over=6;
            }
            if(game_over==PERDEDOR) {
                titileo=0;
                indicador_fin='R';//indica el led rojo
                resultado.attach(&indicador_fin_funcion, 0.5);//activa el indicador
                game_over=6;
            }
            break;
        case ACTUAL:
            if(incremento==1) {
                nivel++;//aumenta de nivel
                incremento=0;
            }
            if(u==(nivel+1)) {//continua con el nivel siguiente y espera la espuesta
                gameplay.detach();
                sensor.attach(&leer_tsi,0.05);
                juego_estado=RESPUESTA;
            }
            break;
        case RESPUESTA:
            //estado de reposo
            break;
    }
}
