//TRABAJO PRACTICO 1 - COOLER

#include "mbed.h"
#include <stdlib.h>     /* srand, rand */
#include <time.h>       /* time */
#include "tsi_sensor.h"
#include "Dht11.h" /* LIBRERIA SENSOR */

/* This defines will be replaced by PinNames soon */
#if defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
#define ELEC0 9
#define ELEC1 10
#elif defined (TARGET_KL05Z)
#define ELEC0 9
#define ELEC1 8
#else
#error TARGET NOT DEFINED
#endif



TSIAnalogSlider tsi(ELEC0, ELEC1, 40);


DigitalOut rojo(LED_RED);
DigitalOut verde(LED_GREEN);
DigitalOut azul(LED_BLUE);

DigitalIn vueltas(PTD2);
    
InterruptIn vuel(PTD4);
    
Dht11 sensor(PTD7); 


AnalogIn potenciometro(PTB0);

PwmOut cooler(PTB3);  //Menos significativo unidad

Ticker tiempo;

Ticker escritura;
enum {INICIO,GENERADOR,DETECCION,CHEQUEO};
enum {COMIENZO,ABIERTO,CERRADO};
enum {ROJO,VERDE,AZUL,ON,OFF};

int estado=0, modo=0,comienza_juego,color=0,segundos=0,giros=0,RPM=0,entrada=0,escritura_hab=OFF;

float p=0,incr=0.0005;

DigitalOut myled(LED1);

void sumav(){
    giros++; //por cada vuelta del cooler incrementa un giro
    }


void segundo_reset() //cada un segundo toma el valor de los giros, predice su valor en RPM, los guarda en otra variable y resetea los giros
{
    segundos++;
    if(segundos==1) {
        RPM=giros*60;
        giros=0;
        segundos=0;
    }
}
void escritura_cooler() //cada cierto tiempo escribe al a salida del PWM
{
    cooler.period(0.5f);
    cooler.write(p);
}
void cooler_automatizado()//funcion principal que controla los modos
{
    switch(estado) {
        case COMIENZO:
            if(modo==CERRADO) {//se activa el modo cerrado
                printf("MODO CERRADO ACTIVADO\n\r");
                escritura_hab=OFF;
                estado=CERRADO;
            }
            if(modo==ABIERTO) {//se activa el modo abierto
                printf("MODO ABIERTO ACTIVADO\n\r");
                escritura_hab=OFF;
                estado=ABIERTO;
            }
            break;
        case CERRADO:
            sensor.read(); //indica que se va a leer el DHT11
            if(sensor.getCelsius()==20){ //si la temperatura es 20 se mantiene en 3000 RPM
                if(RPM>3000){
                p=p-incr;
                }
                else{
                p=p+incr;
                }
            }
            if((sensor.getCelsius()>20)&&(sensor.getCelsius()<70)){//en el rango de 20 y 70 grados hace una regla de tres y saca el RPM equivalente y trata de llevar su velocidad al RPM indicado
                int cel = sensor.getCelsius();//lee el sensor en celsius
                int resultado = (cel * 10000) / 70;
                printf("TEMP: %d resultado: %d RPM: %d\r\n",cel,resultado,RPM);//
                if(RPM>resultado){
                p=p-(float)0.0005;//disminuye la velocidad
                }
                else{
                p=p+(float)0.0005;//aumenta la velocidad
                }
                if(p>(float)1){
                p=(float)1;//el cooler al maximo
                }
            }
            if(sensor.getCelsius()>=70){
                p=(float)1;//mas de 70c al maximo
            }
            if(escritura_hab==OFF) {
                escritura.attach(&escritura_cooler,0.2);//se acrtualiza la info del duty cada 200ms
                escritura_hab=ON;
            }
            break;

        case ABIERTO:
    printf("RPM: %d\n\r",RPM);
            if(RPM>=3000){
             p=potenciometro;//si la velocidad es mas grande que la minima le presta atencion al potenciometro
            }
            else{
            p=p+incr;//de lo contrario se incrementa la velocidad
            }
            if(escritura_hab==OFF) {
                escritura.attach(&escritura_cooler,0.2);
                escritura_hab=ON;
            }
                if(p>(float)1){
                p=(float)1;
                }
            break;
    }
}





int main()
{
    rojo=1;
    verde=1;
    azul=1;
    
    tiempo.attach(&segundo_reset,1);
    vuel.rise(&sumav);
    
    while(1) {
        cooler_automatizado();

        float v = tsi.readPercentage();

        if((v>(float)0.15)&&(v<(float)0.4)) {
            rojo=0;
            verde=1;
            azul=1;
            estado=COMIENZO;
            modo=ABIERTO;
            v=0;

        } else if((v>(float)0.3)&&(v<(float)0.6)) {
            rojo=1;
            verde=0;
            azul=1;
        } else if((v>(float)0.5)&&(v<(float)0.9)) {
            rojo=1;
            verde=1;
            azul=0;
            estado=COMIENZO;
            modo=CERRADO;
            v=0;
        } else if((v>=(float)0.9)) {
            rojo=1;
            verde=1;
            azul=1;
        } else if((v<=(float)0.15)) {
            rojo=1;
            verde=1;
            azul=1;
        }
    }

}