//TRABAJO PRACTICO 1 - BOMBA

#include "mbed.h"
#include <stdlib.h>     /* srand, rand */
#include <time.h>       /* time */
#include "tsi_sensor.h"


/* This defines will be replaced by PinNames soon */
#if defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
#define ELEC0 9
#define ELEC1 10
#elif defined (TARGET_KL05Z)
#define ELEC0 9
#define ELEC1 8
#else
#error TARGET NOT DEFINED
#endif



TSIAnalogSlider tsi(ELEC0, ELEC1, 40);


DigitalOut rojo(LED_RED);
DigitalOut verde(LED_GREEN);
DigitalOut azul(LED_BLUE);

DigitalIn cable_1(PTD3);
DigitalIn cable_2(PTD2);
DigitalIn cable_3(PTD0);
DigitalIn cable_4(PTD5);

AnalogIn aleatorio(PTB0);

DigitalOut unidad_0(PTE20);  //Menos significativo unidad
DigitalOut unidad_1(PTB1);
DigitalOut unidad_2(PTB2);
DigitalOut unidad_3(PTB3);  //Mas significativo unidad
DigitalOut decena_1(PTC2);  //Mas significativo decena
DigitalOut decena_0(PTC1);  //Menos significativo decena
DigitalOut decena_3(PTE30);  //Se pone en "1" para que en los display no muestre nada

char cables[3];

Ticker resultado;


Ticker gameplay;
enum {INICIO,GENERADOR,DETECCION,CHEQUEO};
enum {COMIENZO,GANASTE,PERDISTE};
int juego_estado=0;


Ticker muestra_cables;
enum {F,ALEATORIO,LLENADO};
enum {CABLE1,CABLE2,CABLE3,CABLE4};
int generador=0,valor_guardado=0,n_generador=0,valor_generado=0,comienza_juego=0,modo_display=0, n_display=0,tiempo_juego=30;
int cable1_ocupado=0,cable2_ocupado=0,cable3_ocupado=0,cable4_ocupado=0,chequeo_cable1=0,chequeo_cable2=0,chequeo_cable3=0,chequeo_cable4=0,game_state=0;
int conteo_cables=0;
int codigo_generado[3];
int decena=0, unidade=0,apagar=0;

Ticker display;
enum {APAGADO,ENCENDIDO};
enum {PARPADEO,CUENTA_REGRESIVA,ESTATICO};


void display_mostrar(int decenas, int unidades,int apagar) //esta funcion se encarga de controlar los displays dependiendo a la informacion enviada
{
    if(apagar==0) { 
        if(unidades==0) {
            unidad_0=0;
            unidad_1=0;
            unidad_2=0;
            unidad_3=0;
        }
        if(unidades==1) {
            unidad_0=1;
            unidad_1=0;
            unidad_2=0;
            unidad_3=0;
        }
        if(unidades==2) {
            unidad_0=0;
            unidad_1=1;
            unidad_2=0;
            unidad_3=0;
        }
        if(unidades==3) {
            unidad_0=1;
            unidad_1=1;
            unidad_2=0;
            unidad_3=0;
        }
        if(unidades==4) {
            unidad_0=0;
            unidad_1=0;
            unidad_2=1;
            unidad_3=0;
        }
        if(unidades==5) {
            unidad_0=1;
            unidad_1=0;
            unidad_2=1;
            unidad_3=0;
        }
        if(unidades==6) {
            unidad_0=0;
            unidad_1=1;
            unidad_2=1;
            unidad_3=0;
        }
        if(unidades==7) {
            unidad_0=1;
            unidad_1=1;
            unidad_2=1;
            unidad_3=0;
        }
        if(unidades==8) {
            unidad_0=0;
            unidad_1=0;
            unidad_2=0;
            unidad_3=1;
        }
        if(unidades==9) {
            unidad_0=1;
            unidad_1=0;
            unidad_2=0;
            unidad_3=1;
        }
        if(decenas==0) {
            decena_0=0;
            decena_1=0;
            decena_3=0;

        }
        if(decenas==1) {
            decena_0=1;
            decena_1=0;
            decena_3=0;
        }
        if(decenas==2) {
            decena_0=0;
            decena_1=1;
            decena_3=0;
        }
        if(decenas==3) {
            decena_0=1;
            decena_1=1;
            decena_3=0;
        }
    } else {
        decena_0=1;
        decena_1=1;
        decena_3=1;
        unidad_0=1;
        unidad_1=1;
        unidad_2=1;
        unidad_3=1;
    }
}

void generador_aleatorio() //esta funcion genera los valores aleatorios
{
    switch(generador) {
        case COMIENZO:
            srand(int(aleatorio * 1000)); //leemos la entrada de una pata analogica para obtener un valor entero unico y poder generar valores aleatorios
            if(n_generador<4) { //se repeite la secuencia hasta que se obtiene el orden aleatorio de los cables
                generador=ALEATORIO;
            }
            break;

        case ALEATORIO:
            valor_generado=rand()%4; //genera el valor aleatorio
            generador=LLENADO;
            break;

        case LLENADO: //agarra el valor aleatorio generado y lo asigna en el vector siempre y cuando no se haya repetido, de lo contrario lo ignora y genera otro
            valor_guardado=valor_generado;
            if((cable1_ocupado==0)||(cable2_ocupado==0)||(cable3_ocupado==0)||(cable4_ocupado==0)) {//se entra siempre y cuando falte algun cable que asignar
                if((valor_guardado==CABLE1)&&(cable1_ocupado==0)) { //solo se ingresa una vez, por ende el valor de cable es unico y asi susesivamente
                    cables[n_generador]=0;
                    printf("  CABLE %d \r\n",(valor_guardado+1));
                    cable1_ocupado=1;
                    n_generador++;
                }

                if((valor_guardado==CABLE2)&&(cable2_ocupado==0)) {
                    cables[n_generador]=1;
                    printf("  CABLE %d \r\n",(valor_guardado+1));
                    cable2_ocupado=1;
                    n_generador++;
                }

                if((valor_guardado==CABLE3)&&(cable3_ocupado==0)) {
                    cables[n_generador]=2;
                    printf("  CABLE %d \r\n",(valor_guardado+1));
                    cable3_ocupado=1;
                    n_generador++;
                }

                if((valor_guardado==CABLE4)&&(cable4_ocupado==0)) {
                    cables[n_generador]=3;
                    printf("  CABLE %d \r\n",(valor_guardado+1));
                    cable4_ocupado=1;
                    n_generador++;
                }
                generador = ALEATORIO;
            } else {//una vez completado los 4 cables sigue el juego
                n_generador=4;
                juego_estado=DETECCION;
                generador= INICIO;
            }

            break;
    }
}

void display_funcion() //se encarga de hacer la cuenta regresiva automatica del display y del parpadeo, esta funcion esta corriendo permanentemente cada un segundo
{
    switch (modo_display) {
        case CUENTA_REGRESIVA: //descuenta el tiempo y calcula los valores para obtener decenas y unidades separadas
            decena=tiempo_juego/10;
            unidade=tiempo_juego-(decena*10);
            apagar=0;
            display_mostrar(decena,unidade,apagar);//llammos a la funcion display_mostrar que se encarga de mostrar los numeros, se los asignamos separados
            printf("Tiempo %d\n\r",tiempo_juego);
            tiempo_juego--;//descuenta el tiempo
            if(tiempo_juego==0) {//si llega a cero pierde de todas formas
                decena=tiempo_juego/10;
                unidade=tiempo_juego-(decena*10);
                game_state=PERDISTE;
                modo_display=PARPADEO;
            }
            break;

        case PARPADEO: //si alguien gana o pierde se activa el parpadeo
            if(n_display%2==0) {//para poder hcer el efecto de parpadeo incrementamos una funcion y en numeros pares muesta y en impares se apaga
                display_mostrar(decena,unidade,1);
                if(game_state==PERDISTE) {
                    rojo=0;
                }
            } else {
                display_mostrar(decena,unidade,0);
                if(game_state==PERDISTE) {
                    rojo=1;
                }
            }
            //printf("Tiempo %d\n\r",tiempo_juego);
            n_display++;
            break;

    }

}

void juego()
{
    switch (juego_estado) {//la funcion dell juergo base
        case INICIO:
            if(game_state==PERDISTE) {//si se pierde se activa el parpadeo, al perder ademas titila el led rojo
                modo_display=PARPADEO;
                comienza_juego=0;//esto permite que se resetee el juego desde el TSI
            }
            if(game_state==GANASTE) {//si se gana se activa el parpadeo
                modo_display=PARPADEO;
                comienza_juego=0;//esto permite que se resetee el juego desde el TSI
                verde=0;//al ganar el led verde es fijo
            }
            if(game_state==COMIENZO) {//comienza el juego 
                printf(" COMIENZA EL JUEGO \r\n\n");
                printf("Secuencia : \r\n");
                juego_estado=GENERADOR;
            }
            break;

        case GENERADOR:
            generador_aleatorio();//llamada a la funcion, a generar los cables aleatorios
            tiempo_juego=30;//se setea un tiempo maximo de 30 segundos
            modo_display=CUENTA_REGRESIVA;//se activa la cuenta regresiva
            display.attach(&display_funcion, 1);//se llama al a funcion cada un segundo
            break;

        case DETECCION://comienza a detectar los cables
            if((cable_1==1)&&(chequeo_cable1==0)) {        //los cables se sacan una vez por lo tanto solo se puede entrar una vez en este estado, y al primer error se pierde
                if(cables[conteo_cables]==0) {
                    conteo_cables++;//es correcto y se incrementa la variable para buscar el siguiente cable
                    printf("CABLE 1 SACADO CON EXITO \r\n\n");
                    chequeo_cable1=1;
                } else {
                    game_state=PERDISTE;
                    printf("KBOOOM!. HAZ PERDIDO. EL CABLE 1 NO ERA, LO 100TO HEE HEE\n\r");
                    juego_estado=INICIO;
                }
            }
            if((cable_2==1)&&(chequeo_cable2==0)) {        //los cables se sacan una vez por lo tanto solo se puede entrar una vez en este estado, y al primer error se pierde
                if(cables[conteo_cables]==1) {
                    conteo_cables++;//es correcto y se incrementa la variable para buscar el siguiente cable
                    printf("CABLE 2 SACADO CON EXITO \r\n\n");
                    chequeo_cable2=1;
                } else {
                    game_state=PERDISTE;
                    printf("KBOOOM!. HAZ PERDIDO. EL CABLE 2 NO ERA, LO 100TO HEE HEE\n\r");
                    juego_estado=INICIO;
                }
            }
            if((cable_3==1)&&(chequeo_cable3==0)) {        //los cables se sacan una vez por lo tanto solo se puede entrar una vez en este estado, y al primer error se pierde
                if(cables[conteo_cables]==2) {
                    conteo_cables++;//es correcto y se incrementa la variable para buscar el siguiente cable
                    printf("CABLE 3 SACADO CON EXITO \r\n\n");
                    chequeo_cable3=1;
                } else {
                    game_state=PERDISTE;
                    printf("KBOOOM!. HAZ PERDIDO. EL CABLE 3 NO ERA, LO 100TO HEE HEE\n\r");
                    juego_estado=INICIO;
                }
            }
            if((cable_4==1)&&(chequeo_cable4==0)) {        //los cables se sacan una vez por lo tanto solo se puede entrar una vez en este estado, y al primer error se pierde
                if(cables[conteo_cables]==3) {
                    conteo_cables++;//es correcto y se incrementa la variable para buscar el siguiente cable
                    printf("CABLE 4 SACADO CON EXITO \r\n\n");
                    chequeo_cable4=1;
                } else {
                    game_state=PERDISTE;
                    printf("KBOOOM!. HAZ PERDIDO. EL CABLE 4 NO ERA, LO 100TO HEE HEE\n\r");
                    juego_estado=INICIO;
                }
            }
            if((chequeo_cable1==1)&&(chequeo_cable2==1)&&(chequeo_cable3==1)&&(chequeo_cable4==1)) {
                game_state=GANASTE;//cuando los 4 quedan deshabilitados es cuando el jugador gana
                juego_estado=INICIO;
            }
            break;
    }

}

int main()
{
    rojo=1;
    verde=1;
    azul=1;//apago todos los leds
    juego_estado=INICIO;//inicializo el juego
    while(1) {
        float v = tsi.readPercentage();
        if(comienza_juego==1) {//una vez que esta variable este en 1 el juego queda corriendo, de lo contrario espera a que se deslice con el dedo en el TSI para comenzar.
            juego();
        } else {
            if((v>(float)0.1)&&(v<(float)0.3)) {//efecto de los colores
                comienza_juego=0;
                rojo=0;
                verde=1;
                azul=1;
            } else if((v>(float)0.3)&&(v<(float)0.6)) {//efecto de los colores
                rojo=1;
                verde=0;
                azul=1;
            } else if((v>(float)0.6)&&(v<(float)0.9)) {//efecto de los colores
                rojo=1;
                verde=1;
                azul=0;
            } else if((v>=(float)0.9)) {//se resetean las variables para poder iniciar el juego de forma limpia incluso cuando se lo resetee al ganar o perder
                rojo=1;
                verde=1;
                azul=1;
                display.detach();
                n_generador=0;
                chequeo_cable1=0;
                chequeo_cable2=0;
                chequeo_cable3=0;
                chequeo_cable4=0;
                cable1_ocupado=0;
                cable2_ocupado=0;
                cable3_ocupado=0;
                cable4_ocupado=0;
                conteo_cables=0;
                generador=COMIENZO;//inicializa el generador
                game_state=COMIENZO;//inicializa las etapas del juego
                comienza_juego=1;//habilita el juego corriendo el loop y evita que se pueda volver a usar el TSI hasta que el juego no concluya
                juego_estado=INICIO;//inicializa el juego
            }
        }


    }
}
