/*  BME280 BLE sensor -- bme280_wrapper.h
*
*   Licensed under the Apache License, Version 2.0 (the "License");
*   you may not use this file except in compliance with the License.
*   You may obtain a copy of the License at
*
*       http://www.apache.org/licenses/LICENSE-2.0
*
*   Unless required by applicable law or agreed to in writing, software
*   distributed under the License is distributed on an "AS IS" BASIS,
*   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*   See the License for the specific language governing permissions and
*   limitations under the License.
*
*   Copyright 2019 Fedor Chervyakov
*/

#ifndef _BME280_WRAPPER_H_
#define _BME280_WRAPPER_H_

#include "bme280.h"


void user_delay_ms(uint32_t period);
int8_t user_i2c_read(uint8_t dev_id, uint8_t reg_addr, uint8_t *reg_data, uint16_t len);
int8_t user_i2c_write(uint8_t dev_id, uint8_t reg_addr, uint8_t *reg_data, uint16_t len);


class BME280 {
public:
    BME280(PinName sda, PinName scl);    
    struct bme280_data comp_data;
    int force_measurement();
    
private:
    PinName _sda, _scl;
    struct bme280_dev _dev;

    int init();
};

#endif
