#include "mbed.h"
#include "rtos.h"
#include "LM75B.h"
#include "C12832.h"

CANMessage msg;

// STEP 1/////////////////////////////////////////////////////
//baseboard address
#define BASE_ADDRESS 140



// STEP 2//////////////////////////////////////////////////////
// phyiscal inputs
DigitalIn joy_up(p15);
DigitalIn joy_down(p12);
DigitalIn joy_left(p13);
DigitalIn joy_right(p16);
DigitalIn joy_fire(p14);

LM75B sensor(p28,p27);



//STEP 3///////////////////////////////////////////////////////
//physical outputs
DigitalOut led1(LED1);
DigitalOut led2(LED2);
PwmOut spkr(p26);
PwmOut r (p23);
PwmOut g (p24);
PwmOut b (p25);

//STEP 4///////////////////////////////////////////////////////
// message structure can

///////////////////////////////////////////////////////
typedef struct {

    int   id;      /* can id */
    char  data[8]; /*can data */

} can_message_t;





//STEP 4///////////////////////////////////////////////////////
// ipc for can write thread
///////////////////////////////////////////////////////
MemoryPool<can_message_t, 8> can_write_mpool;
Queue<can_message_t, 8> can_write_queue;

//STEP 5///////////////////////////////////////////////////////
// ipc for digital output thread

////////////////////////////////////////////////////////
MemoryPool<can_message_t, 8> digital_output_mpool;
Queue<can_message_t, 8> digital_output_queue;


//STEP 6///////////////////////////////////////////////////////
// ipc for analog output thread

////////////////////////////////////////////////////////
MemoryPool<can_message_t, 8> analog_output_mpool;
Queue<can_message_t, 8> analog_output_queue;

//STEP 7///////////////////////////////////////////////////////
// set up canbus
///////////////////////////////////////////////////////
CAN can1(p30, p29);
//CAN can1(p9, p10);

//STEP 8///////////////////////////////////////////////////////
/* digital input Thread */
//////////////////////////////////////////////////////
void digital_input_thread (void const *args) {

    while (true) {

        can_message_t *message = can_write_mpool.alloc();
        message->id = BASE_ADDRESS + 0; 
        message->data[0] = joy_up;
        message->data[1] = joy_down;
        message->data[2] = joy_left;
        message->data[3] = joy_right;
        message->data[4] = joy_fire;
  


        can_write_queue.put(message);
        
        //fun bit nod yes on fire
        if(joy_left)
            {
            can_message_t *message = can_write_mpool.alloc();
            message->id = 142; 
            message->data[0] = 5;

            can_write_queue.put(message);   
            }
        else if(joy_fire)
            {
            can_message_t *message = can_write_mpool.alloc();
            message->id = 144; //even addresses only for now !!!!
            message->data[0] = 1;

            can_write_queue.put(message);                 
            }
        else if(joy_right == 1)
            {
            can_message_t *message = can_write_mpool.alloc();
            message->id = 144; 
            message->data[0] = 2;

            can_write_queue.put(message);      
            }
        else if(joy_up == 1)
            {
            can_message_t *message = can_write_mpool.alloc();
            message->id = 144; 
            message->data[0] = 4;

            can_write_queue.put(message);      
            }
        else if(joy_down == 1)
            {
            can_message_t *message = can_write_mpool.alloc();
            message->id = 144; 
            message->data[0] = 3;

            can_write_queue.put(message);      
            }
     
        Thread::wait(500);
    }

}

//STEP 9///////////////////////////////////////////////////////
/* analog input Thread */
//////////////////////////////////////////////////////
void analog_input_thread (void const *args) {

//if (sensor.open()) {

       // printf("Device detected!\n");
    while (true) {
        can_message_t *message = can_write_mpool.alloc();
        message->id = BASE_ADDRESS + 4; 
        message->data[0] = sensor.read();
        can_write_queue.put(message);

        Thread::wait(500);
    }
 //else{

  //  printf("Device faulty!\n");

    //}
}

//STEP 10///////////////////////////////////////////////////////
// Can write thread
//////////////////////////////////////////////////////
void can_write_thread(void const *args) {

  while (true) {
        osEvent evt = can_write_queue.get();
         if (evt.status == osEventMessage) {
         can_message_t *message = (can_message_t*)evt.value.p;

         //send canbus message
         //can1.write(CANMessage(message->id, message->data, 8));
         can1.write(CANMessage(message->id,message->data, 8));
         can_write_mpool.free(message);
        }

  }

}



//STEP 11///////////////////////////////////////////////////////
//Can read thread
//////////////////////////////////////////////////////
void can_read_thread (void const *args) {

 while (true) {
        printf("loop()\n");
        if(can1.read(msg))  
            {
        
         if(msg.id == BASE_ADDRESS + 4) // Then its an analog out message
            {
            //send to analog output ipc
            can_message_t *message = analog_output_mpool.alloc();
            message->id = msg.id; 
            message->data[0] = msg.data[0];
            analog_output_queue.put(message);

            Thread::wait(500);
            }
   

        else if(msg.id == BASE_ADDRESS + 6) //then its an do message
            {
            //send to digital output ipc
            can_message_t *message = digital_output_mpool.alloc();

            message->id = msg.id; 
            message->data[0] = msg.data[0];

            digital_output_queue.put(message);
            Thread::wait(500);

            } 

      //  else {

            //handler for other messages

         //   }

         Thread::wait(100);

      }//end of if can.read

 }//end of while(1)

} //end of thread







//STEP 12///////////////////////////////////////////////////////
// Analog_ouptut_thread
//////////////////////////////////////////////////////
void Analog_ouptut_thread(void const *args) {

  while (true) {

        osEvent evt = analog_output_queue.get();
       

          if (evt.status == osEventMessage) {
            can_message_t *message = (can_message_t*)evt.value.p;
           

           //drive the speaker based on can message
          //// spkr.period(1/(2000 + (message->data[0]* 50))); //generate a tone based on data[0] value range from 2000 + 0*50 to 2000 + 255*50
          // spkr=0.5;
           r = message->data[0]/255;
            g = message->data[1]/255;
             b = message->data[2]/255;
             
           //led1 test
           led1 = !led1;
           
               
          analog_output_mpool.free(message);
          }
  }

}



//STEP 13///////////////////////////////////////////////////////
// Digital_ouptut_thread
//////////////////////////////////////////////////////
void Digital_output_thread(void const *args) {

  while (true) {

        osEvent evt = digital_output_queue.get();
       

        if (evt.status == osEventMessage) {
            can_message_t *message = (can_message_t*)evt.value.p;
            
        //drive the digital ouptut based on can message
        
            if (message->data[0] == 1 )  
            {   
             led1 = 1;
             }
            else if(message->data[0] == 0 )
             {
             led1 = 0;
             }
             
            if (message->data[0] == 2 )  
            {   
             led2 = 1;
             }

            else if (message->data[0] == 3 ) 
            {

             led2 = 0;
             }
             

            digital_output_mpool.free(message);

        } //end of if statement

  }//end of while loop

}



//STEP 13///////////////////////////////////////////////////////
// START THREADS
//////////////////////////////////////////////////////
int main() {
Thread thread1(Digital_output_thread);

Thread thread2(Analog_ouptut_thread);

Thread thread3(can_read_thread);

Thread thread4(can_write_thread);

Thread thread5(analog_input_thread );

Thread thread6(digital_input_thread);


while(true)

    {

    led2 !=led2;

    Thread::wait(500);

    }



}