#include "TLSConnection.h"
#include <stdlib.h>
#include <stdio.h>
#include "cert.h"
#include <string.h>

static int receiveFunc(CYASSL* ssl, char *buf, int sz, void *ctx)
{    
    int fd = *(int*)ctx;
    fd_set rfds;
    FD_ZERO(&rfds);
    FD_SET(fd, &rfds);
    
    if (lwip_select(FD_SETSIZE, &rfds, NULL, NULL, NULL) < 0)
        return -1;
            
    return lwip_recv(fd, buf, sz, 0);
}

static int sendFunc(CYASSL* ssl, char *buf, int sz, void *ctx)
{
    int fd = *(int*)ctx;
    fd_set wfds;
    FD_ZERO(&wfds);
    FD_SET(fd, &wfds);
    
    if (lwip_select(FD_SETSIZE, NULL, &wfds, NULL, NULL) < 0)
        return -1;
            
    return lwip_send(fd, buf, sz, 0);    
}

const static int HTTPS_PORT = 443;

TLSConnection::TLSConnection():
    Socket(),
    Endpoint(),
    _is_connected(false),
    _ssl_ctx(),
    _ssl()
{
}


bool TLSConnection::connect(const char *host)
{
    if (init_socket(SOCK_STREAM) < 0)
        return false;

    if (set_address(host, HTTPS_PORT) != 0)
        return false;

    if (lwip_connect(_sock_fd, (const struct sockaddr *) &_remoteHost, sizeof(_remoteHost)) < 0) {
        close();
        return false;
    }

    CyaSSL_Init();
    
    CYASSL_METHOD* method = CyaTLSv1_2_client_method();
    if(method == NULL)
    {
        return false;
    }

    _ssl_ctx = CyaSSL_CTX_new(method);
    if(_ssl_ctx == NULL)
    {
        return false;
    }    
    CyaSSL_SetIOSend(_ssl_ctx, &sendFunc);
    CyaSSL_SetIORecv(_ssl_ctx, &receiveFunc);
    CyaSSL_CTX_load_verify_buffer(_ssl_ctx,(unsigned char*)root_cert, root_cert_len,SSL_FILETYPE_ASN1);

    _ssl = CyaSSL_new(_ssl_ctx);
    if(_ssl == NULL) 
    {
        return false;
    }
    CyaSSL_set_fd(_ssl, _sock_fd);

    int result = CyaSSL_connect(_ssl);
    if(result!=SSL_SUCCESS) 
    {
        printf("error=%d\n", result);
        return false;
    }  

    _is_connected = true;

    return true;
}

bool TLSConnection::is_connected(void)
{
    return _is_connected;
}

int TLSConnection::send_all(char *data, int length)
{
    if(!_is_connected)
        return 0;
        
    return CyaSSL_write(_ssl, data, length);
}

int TLSConnection::receive(char *data, int length)
{
    if(!_is_connected)
        return 0;
        
    return CyaSSL_read(_ssl, data, length);
}

bool TLSConnection::close(bool shutdown)
{
    if(!_is_connected)
        return true;

    _is_connected = false;

    CyaSSL_CTX_free(_ssl_ctx);
    CyaSSL_Cleanup();  

    return Socket::close(shutdown) == 0;
}

