/** This example shows how to create 
    a small TLS server using the TLS library.
*/

#include "mbed.h"
#include "EthernetInterface.h"
#include "TLSConnection.h"
#include "TLSServer.h"

const char host[] = "mbed.org";

const char page[] = " \
<html>   \
    <head>\
        <title>MBED</title>\
    </head>\
    <body>\
    Hello World !\
    </body>\
</html>";

int main() 
{
    set_time(1379062044 );
    EthernetInterface eth;
    if(eth.init() || eth.connect())
    {
        printf("Error with EthernetInterface\n\r");
        return -1;
    }
    printf("IP address is %s\n", eth.getIPAddress());
    
    TLSServer srv;
    if(!srv.init())
    {
        printf("Failed to intialize server\n");
        return -1;
    }
    
    TLSConnection con;
    if(srv.accept(con))
    {
        printf("New connection from %s\n", con.get_address());
        char buffer[512];
        
        while(con.is_connected())
        {
            int read = con.receive(buffer, 511);
            if(read == 0)
            {
                break;
            }
            if(read != -1)
            {
                buffer[read] = '\0';
                printf("%s", buffer);
                
                sprintf(buffer, "HTTP/1.0 200 OK\r\nContent-Length: %d", strlen(page));
                strcat(buffer, "\r\n\r\n");
                strcat(buffer, page);
                
                con.send_all(buffer, strlen(buffer));
            }
            else
            {
                printf("error occured\n");
                break;
            }   
        }
        
        con.close();
    }
    eth.disconnect();
    
    return 0;
}
