/** This example show how to use the TLS_cyassl library
    to connect to a server using TLS.
*/

#include "mbed.h"
#include "EthernetInterface.h"
#include "TLSConnection.h"
#include "TLSServer.h"

const char host[] = "mbed.org";

int main() 
{
    set_time(1379062044);
    EthernetInterface eth;
    if(eth.init() || eth.connect())
    {
        printf("Error with EthernetInterface\n\r");
        return -1;
    }
    
    TLSConnection con;
    if(!con.connect(host))
    {
        printf("Failed to connect to %s\n", host);
    }
    else
    {
        printf("Connected to %s\n !", host); 
        con.close();   
    }
    
    eth.disconnect();
    
    return 0;
}
