/*
    This example shows how to use TLS library. It
    establishes a connection to mbed.org and then
    closes this connection immediately.

    Don't forget to copy certificates on your
    mbed before running this program. You can
    download them as a zip package from the wiki:
    http://mbed.org/users/feb11/code/TLSExample/
*/



#include "mbed.h"
#include "EthernetInterface.h"
#include "CertificateManager.h"
#include "TLSConnection.h"

const char host[] = "mbed.org";
LocalFileSystem local("local");

int main()
{
    /*
        Ensure that the mbed has a time value
        approximately equal to the correct timestamp.
        This is needed because the certificate manager
        uses the timestamp to check whether certificates
        expired.

        Don't hesitate to remove this line if your mbed
        already store a correct time value, or update
        this value.
    */
    set_time(1378376823);

    /* Starting Ethernet */
    EthernetInterface eth;
    if(eth.init() || eth.connect()) {
        printf("Error with EthernetInterface\n\r");
        return -1;
    }

    /*
        Loading certificates in precomputed mode.
        Notice that cert4 is the root certificate.
    */
    CertificateManager::add("/local/cert1.der");
    CertificateManager::add("/local/cert2.der");
    CertificateManager::add("/local/cert3.der");
    CertificateManager::add("/local/cert4.der");
    if(!CertificateManager::load(true)) {
        printf("Failed to load certificates\n");
        return -1;
    }

    /* Starting connection to mbed.org */
    TLSConnection con;
    if(con.connect(host)) {
        printf("Connected to %s !\n", host);

        /*
            Since no memory is needed once the connection
            is established, we don't need to call
            CertificateManager::clear() to free memory.
        */
        con.close();
    } else {
        printf("Failed to connect to %s\n", host);
    }

    eth.disconnect();

    return 0;
}

