#include "mbed.h"
#define Frequence 500 // définition d'une constante frequence=500

Serial pc(USBTX,USBRX);   // déclaration d'un objet PC port série sur USB
Serial uart(PG_14, PG_9); // déclaration d'un objet UART sur broche 
                          // GPIO PG_14 pour TX et PG_9 pour RX
InterruptIn alarme(D2);
Timer chrono;
Ticker clignotement;      // Ticker pour faire clignoter une LED toutes les 0,5s
PwmOut monpwm(PE_13);     // PWM sur la broche D3 arduino
AnalogIn potentiometre(PC_3);  // entrée associée à A2 Arduino

//  Variables globales
DigitalOut myled1 (LED1);
DigitalOut myled2 (LED2);
DigitalOut myled3 (LED3);

float ma_variable;
float ma_variable2=100;

// Programme de clignotement pour le Ticker
void clignote()
    {
        myled1=!myled1;
    }

void alarme_declanchee() {
    for (int i=0; i<20; i++) 
    {
        myled2=!myled2;
        wait_ms(300);
    }
}

int main()          // début du programme principal 
{
    alarme.rise(&alarme_declanchee);  // déclanchement du programme alarme_declanchee lors d'un 
   // front montant sur la broche GPIO D2 (interuption déclarée du nom de alarme
    
    DigitalOut hp_out(PE_13);    // Sortie digitale hp-out sur la broche PE_13
    DigitalIn mybutton (USER_BUTTON);  // Entrée digitale mybutton sur le bouton 
                                        // utilisateur USER_BUTTON

    
    // Variables locales car dans le main()
    char c;
    float tension;  // Tension sur la broche A2 portentiométre PE_3
    int count;
    int i;     // définir la variable i en integer
    int j=0;     // définir la variable j en integer avec initialisation j=0
    float tableau[10];
    
    monpwm.period_ms(2);       // période du signal PWM 2ms
    monpwm.pulsewidth_ms(1);   // largeur d'impulsion 1ms donc rapport cyclique 50%
    // monpwm.write(0.5);      identique à la ligne du dessus, rapport cyclique 0.5
    
    pc.printf ("\n Début du programme \n");
    tension = 3.3*potentiometre.read();   // Valeur entre 0 et 1 multipliée par 3,3V
    pc.printf ("\n La tension est de %.4f volt \n",tension);    
    
    uart.baud(9600);   // régler la vitesse de transmission du port série à 9600 bauds
    
    uart.format(8,SerialBase::None,1);     // 8 bits, Parity None, Stop bit =1
    uart.putc(41);   // envoyer le caractére ASCII numéro 41 lettre "A" sur le port série uart                                   
    
    for (i=0; i<=10; i++) {
        tableau[i] = sqrt((double)i);
        }
    chrono.reset();
     while (1) {
         if (mybutton ==1) {
             clignotement.attach(&clignote,500); // periode de clignotement de 0,5 secondes
                                                    // clignotement c'est le ticker défini en haut
                                                    // clignote c'est le programme void clignote
             chrono.start();
             hp_out = !hp_out;
             wait_ms(500);  // delai de 500 ms
             wait(0.5);     // delai de 500 ms
             }
             else {
                 hp_out=0;
                 }
    
     if (mybutton ==1) hp_out = !hp_out;   // valable pour une seule instruction
     if (mybutton ==1) { hp_out = !hp_out; }  // idem ligne du haut
     
     if (pc.readable()==1) {     // si une donnée est disponible sur le port série PC alors
         c=pc.getc();            // Lire le caractère sur le port série PC et le placer dans C
         pc.putc(c);              // envoyer le caracère dans c vers le port série PC
         if (c=='a') { 
            pc.printf("\n vous avez appuye sur a  \n");
         }
     ma_variable = ma_variable+100;
     ma_variable +=100; // idem au dessus
     
     ma_variable++;  // augmente de 1
     ma_variable2++; // passe de 100 à 101 
    
    if (c=='a'&&ma_variable<400) { ma_variable=0;}  // opérateur ET
    if (c=='a'|| ma_variable>2000) {ma_variable=0;}  // opérateur OU
     
     while (ma_variable <=1000) {   // les instructons ligne 1,2,3 sont executées 
                                  //  si ma_variable <=1000
         // programme ligne 1 
         // programme ligne 2
         // programme ligne 3
    }
     
     for (count=0; count <3; count++) {    //Boucle de 0 à 2 inclus avec 
                                            // count +1 à chaque passage
         // instruction 1
         // instruction 2
         // instruction 3
     }   // fin de la boucle for 
     pc.printf("\n Temps écoulé %d us\n",chrono.read_us());
     chrono.stop();
     
     for (count=1; count <4; count++) { 
        switch (count) {
            case (1):
            myled1 =1;
            break;
            
            case 2:
            myled2 =1;
            break;
            
            case 3:
            myled3 =1;
            myled2 =0;
            myled1.write(0);
            break;
        }    
     }

     while (1);  // boucle infinie tant que 1 ou Vrai 
     while (1) {}; // boucle infinie
     while (true); // boucle infinie
}
}
}
             