/*   Franck DURAND 2021  - V3

Projet SID sur microcontroleur STM32 avec carte de développement Nucléo STM32F429ZI
Signal d'entrée sur la broche A2 0 à 3.3 Volt maxi f<fe/2   f< 30 KHz

Etape 1: Acquisition des échantillons sur la broche A2 avec recopie sur D13

Etape 2: Mise en œuvre du calcul de la valeur efficace en temps réel avec 
          filtre RII premier ordre. 
            veff = sqrt (0.0001f*in*in + 0.9999f*veff) ;
           /* Calcul de la valeur efficace avec un filtre recursif ordre 1 */
           /* y(n) = sqrt[(1 + a)*x(n)x(n) - a*y(n-1)] 
Etape 3: Mémorisation des valeurs moyennes sur clé USB toutes les secondes
*/

#include "mbed.h"
#include "math.h"
#include "USBHostMSD.h"
#include "string"
#include <stdio.h>

#define fech 48000             // Fréquence d'échantillonnage souhaitée 48 KHz
#define taille 2880            // nombre d'enregistrements par fichier (24 heures= 2880 pour 2 ech/minutes)
                               // (2880*32bits)/1024 = 90 Ko

Serial pc2(USBTX,USBRX);

AnalogIn entree_analogique(PC_3);  // A2 connecteur Arduino Signal d'entrée     
AnalogOut sortie_analogique(PA_5); // D13 Arduino sortie de contrôle analogique 
PwmOut sortie(PE_9);               // D6 Arduino pour les tests uniquement
DigitalOut visu(PG_9) ;            // D0 Arduino  pour les tests de la mesure du temps de traitement
DigitalIn mybutton(USER_BUTTON);   // Bouton utilisateur pour arret du programme
Ticker ADC_DAC ;                   // Aquisition des échantillons sur interpuption ticker

/****************************   Variables globales  *******************************************************/
float input = 0 ;          // valeur de la tension d'entrée acquise en volt
float moy = 0 ; 
float eff2_ACDC = 0 ; 
float eff_AC = 0 ;         // Valeur de la tension efficace d'un échantillon
float eff[taille];
int i;                     // variable indice de la mesure enregistree dans cle usb
string s;                  // chaine de caratères pour stocker la valeur des secondes sous forme string
                                

/***************************************    Acquisition signal analogique    ********************************/
void acquisition()
{
    float x,y ;      

   // visu = 1  ;                        // Permet de mesurer les temps de traitements des differentes instructions entre visu=1 et visu=0
    
    y = entree_analogique.read();        // Acquisition du signal analogique 
    sortie_analogique.write(y) ;         //Sortie d'un échantillon du signal (recopie du signal d'entrée) 
  
    // visu = 0 ;                        // Permet de mesurer les temps de traitements des differentes instructions entre visu=1 et visu=0
    
    input = 3.3f*y;                     // Conversion en volts de l'échantillon du signal filtré
    moy = 0.0001f*input + 0.9999f*moy;  /* Calcul de la valeur efficace avec un filtre récursif d'ordre 1 */  
    eff2_ACDC = 0.0001f*input*input + 0.9999f*eff2_ACDC;  /* Ici carré de la valeur efficace */
    eff_AC = sqrt(eff2_ACDC);
                                        /* Calcul de la valeur de la tension efficace avec un filtre récursif d'ordre 1 */
                                        /* y(n) = racine[(1 + a)*x(n)*x(n) - a*y(n-1)] */
                                        /* a = -0.9999 pour un lissage fort */
}
/***********************************************************************************************************/

int main()
{
   USBHostMSD msd("usb");
   
   set_time(1256729737);
   time_t seconds = time(NULL);  
   pc2.printf("Time as a basic string = %s", ctime(&seconds));
   
   pc2.printf("Connectez la clef USB sur le connecteur prevu a cet effet\n"); 
                                        // Attente de la connexion USB
   while(!msd.connect())                // try to connect a MSD device, 
   {                                    // répétition jusqu'au branchement de la clé USB
   }
   
   pc2.printf("Clef USB connectee ne pas debrancher\n");
   pc2.printf("Ecriture des donnees sur la clef USB dans le fichier data.txt\n");
   FILE *fp = fopen("/usb/data.txt","w"); 
   
    pc2.printf("\n fech = %d Hz\n",fech);
    pc2.printf("Connectez la sortie D6 (signal a filtrer) sur l'entree A2 \n");
    pc2.printf("Visualisez signal filtre sur la broche D13 \n");
    pc2.printf("Mesure du temps de traitement du filtrage sur D0 \n");
    pc2.printf("Traitement en cours : \n");
    
    /********************************* Générateur de signal PWM pour les essais ********************************/
    ADC_DAC.attach_us(&acquisition,1000000/(fech)); // démmarage du Ticker d'aquisition des échantillons sur interpuption 
                    sortie.period_us(51);           // utilisé uniquement pour les tests si pas de générateur GBF
                    sortie.write(0.5f) ;            // rapport cyclique 1/2
    /***********************************************************************************************************/
    
    i=0;                
    while(1) {                               // Boucle inifinie avec execution du programme défini entre les accolades 
         if (fp != NULL)                     // Execution uniquement si la cle usb n est pas debranchee
         {
            i++;                             // Incrémentation de l'index de 1 pour une nouvelle mesure à enregistrer
            eff[i] = eff_AC;                 // Sauvegarde de m'échantillon dans le tableau à l'indice i 
                // pc.printf("valeur efficace ACDC de la tension d entrée  = %10.3f \n",eff2_ACDC);
                // pc.printf("valeur moyenne de la tension d entrée  = %10.3f \n",moy);
           
           s=ctime(&seconds);            
           pc2.printf("RMS Value: %10.3f Time: %s",eff[i],s);       // affichage de la valeur RMS sur la console
           fprintf(fp,"RMS value ; %10.3f ;Time ;%s ",eff[i],s);    //  enregistrement des deux valeurs sur la clé USB
       
      if (mybutton ==1||i>=taille) {                                // Procédure d'interruption du programme et de fermeture du fichier
                                                                    // fin de programme si nombre d'échantillons supérieur ou égale à taille
                                                                    // ou bouton poussoir USER (bleu) appuyé par l'utilisateur
                pc2.printf("Demande arret du programme / sauvegarde en cours : \n");
                fclose(fp);                                         // Fermeture du fichier
                wait(2);                                            
                pc2.printf("Vous pouvez retirer la cle USB \n");    
                while(1);                                           // Boucle sans fin qui arrête définitivement le programme 
                }
             }
        else                                                        // Si l'accès au répertoire ne fonctionne pas.
        pc2.printf("Impossible d'ouvrir le fichier data.txt\n");
        
    wait_ms(30000)                                                  // attente 30 secondes
    }
}
