#include "mbed.h"
 
FlashIAP flash;
 

/* Programme d'alarme
Utilisation de deux interruptions sur chaque entrée A0 (PG_9) et A1 (PG_14)
afin de déclencher des actions de remise à zéro sur les états logiques des 
entrées numériques A0 et A1 qui sont respectivement reliées à des capteurs:
Capteur de présence normalement fermé ou normalement ouvert qui procure un signal 
positif en cas de présence et négatif en cas d'absence ainsi par défaut en cas de 
disfonctionnement du capteur le signal reste à 0 et déclenche aussi l'alarme.
Le bouton permet d'injecter un état positif sur  l'entrée A1 (B) afin de vérifier
la présence de la personne qui doit à intervalles réguliers appuyer sur le bouton 
afin de confirmer son état de bonne santé et de présence

Un compteur est lancé et remis à zéro par les sous programmes déclenchés 
par les interruptions et si le compteur dépasse un certain délai alors l'alarme 
est déclenchée   

 */

#include "mbed.h"

//#define y 900               // délai de 900 secondes ou 15 minutes 
//#define x 5                 //  délai de 5 secondes avant déclanchement de l'alarme     

 // ********** Déclaration pour l'ecriture et lectrue en mémoire Flash *******//


// **************** Les entrées de la carte Nucléo ************************** //

Timer mon_timer;                        // Déclaration d'un timer 
DigitalIn bouton (PG_9);                // broche D0 action utilisateur sur bouton front montant
//DigitalIn secteur (PG_14);              // Présence du 220V
DigitalIn mybutton(USER_BUTTON);        // Bouton bleu pour activer la configuration des deux délais 
                                                // via la port séeie avec TeraTerm 
Serial pc(USBTX,USBRX);                 // Déclaration de la liaison série pour configurer les délais

//  ************** Les sorties de la carte Nucléo ************************************ //

DigitalOut sirene (PF_14);   // Déclanchée après un délai X suite au délai Y (Lampe et buzzer)
DigitalOut buzzer (PF_15);   // Buzzer déclanché en même temps que la lampe
DigitalOut relais (PE_13);   // Relais déchanches lors de l alarme

// ************* Témoin pour les tests ***************************************** //
DigitalOut led(LED1);        // voyant de vérification pour signifier alarme activée

// ************* Déclaration d'un PWM pour le clignotement de la lampe ************** //
PwmOut lampe (PE_11);        // Lampe déclanchée après un délai de Y

InterruptIn int_bouton(PG_9);  // déclaration des inéruptions liées au changement d'état
InterruptIn int_secteur(PG_14);// des broches A et B  (capteur ou bouton

Ticker buzzer_secteur;

Timeout delai;              // Déclaration d'un timeout qui permetera de déclancher 
                            // une action après depassement d'un délai Y   
Timeout flashread;
                            

int y=900;              // délai de 900 secondes ou 15 minutes val par défaut
int x= 5;               //  délai de 5 secondes avant déclanchement de l'alarme    
                            
void lecture_flash ()      // Lecture des donnnées mémorisées en mémoire Flash
    {
    const uint32_t  flash_start = flash.get_flash_start();
    const uint32_t  flash_size = flash.get_flash_size();
    const uint32_t  flash_end = flash_start + flash_size - 1;
    const uint32_t  page_size = flash.get_page_size();
    uint32_t        sector_size = flash.get_sector_size(flash_end);
    uint8_t*        page_buffer = new uint8_t[page_size];
    uint32_t        addr = flash_end - sector_size + 1;
    uint32_t        addr2 = flash_end - sector_size + 2;
    uint8_t         data_write = 5;   // délai de 900 secondes ou 15 minutes par défaut
    uint8_t         data_write2 =5;     // délai de 5 secondes avant déclanchement de l'alarme
    uint8_t         data_read = 0;      // délai de 900 secondes ou 15 minutes par défaut
    uint8_t         data_read2 = 0;     // délai de 5 secondes avant déclanchement de l'alarme
    
    //pc.printf("flash_start = 0x%.8x\r\n", flash_start);
    //pc.printf("flash_size = 0x%.8x\r\n", flash_size);
    //pc.printf("flash_end = 0x%.8x\r\n", flash_end);
    //pc.printf("page_size = 0x%.8x\r\n", page_size);
    //pc.printf("sector_size = 0x%.8x\r\n", sector_size);
    //pc.printf("addr = 0x%.8x\r\n", addr);
    //pc.printf("data_write = %d\r\n", data_write);
    //pc.printf("data_read before writing to flash = %d\r\n", data_read);
    flash.init();
    flash.read(page_buffer, addr, page_size);
    data_read = page_buffer[0];         // lecture de la donnée délai maxi entre deux appuis sur bouton 
    flash.read(page_buffer, addr2, page_size);
    data_read2 = page_buffer[0];        // lecture de la donnée délai avant déclanchement de l'alarme
    delete[] page_buffer;
    flash.deinit();
    //pc.printf("lecture de la donnée délai maxi entre deux appuis sur bouton  = %d\r\n", data_read);
    //pc.printf("lecture de la donnée délai avant déclanchement de l'alarme = %d\r\n", data_read2);
    y=data_read;     // initialisation de Y avec la valeur de la mémoire Flash
    x=data_read2;   // initialisation de x avec la valeur de la mémoire Flash
    }
    
void clignote_on()          // pour la mies en marche de la lampe
    {
     lampe.period (5);     // Période de 5 secondes
     lampe.write(0.2);      // Rapport cyclique de 20%
     }
     
void clignote_off ()        // pour l'arrêt de la lampe
    {
     lampe.period (5);     // Période de 5 secondes
     lampe.write(0);        // Rapport cyclique de 0%
     }

void alerte ()
    {
        led.write(1);       // Allumer la LED 1 pour signifier le déclanchement de 
        clignote_on();
        buzzer.write(1);
        mon_timer.reset();
        while (mon_timer.read() < x) {
            };
        if (mon_timer.read() > x) {
            sirene.write(1);  // déclanchement de la sirène après le délai de 5s
            };
    }
    
void raz_compteur ()
    {
    mon_timer.reset();       // Remise à zéro du timer
    delai.attach(&alerte,y); // réinitialisation du timeout avec le délai y
    led.write(0);
    clignote_off();
    buzzer.write(0);
    } 
void bip ()
    { 
    buzzer.write(1);
    wait(1);
    buzzer.write(0);
    }
    
void secteur_off ()
    { 
    buzzer_secteur.attach(&bip,5);
    
    }
    
void secteur_on ()
    {
    buzzer_secteur.detach();                   
    }    
                       
int main()
    {
    pc.printf("Menu de configuration des delais Y et X \n");
    pc.printf("Programme alarme Mai 2021 - ETD Charles Quillet \n");               
                    //   
        flashread.attach(&lecture_flash,2);   // Lecture des paramètres depuis la mémoire Flash

        pc.printf("Lecture Flash realisee \n");  
        pc.printf("lecture de la donnee delai maxi entre deux appuis sur bouton  = %d\r\n", y);
        pc.printf("lecture de la donnee delai avant declanchement de l'alarme = %d\r\n", x);
        mon_timer.reset();
        delai.attach(&alerte, y);
        int_bouton.rise(&raz_compteur);
        int_secteur.fall(&secteur_off);
        int_secteur.rise(&secteur_on);
        
    while (1) {
        if (mybutton ==1) {       // le bouton bleu de configuration est activé
                // l'accès à la configuration est réalisée par une pression sur le bouton bleu de la carte.
                //  ce programme permet l'entrée d'une nouvelle configuration (délais Y et X)et la mémorisation dans la mémoire Flash non volatile 
                //  l'utilisateur entre les données via le port USB et une interface console de type TeraTerm
                //  ou hyperterminal. Les données sont enregistrées en mémoire Flash dans le uC 
            
                const uint32_t  flash_start = flash.get_flash_start();
                const uint32_t  flash_size = flash.get_flash_size();
                const uint32_t  flash_end = flash_start + flash_size - 1;
                const uint32_t  page_size = flash.get_page_size();
                uint32_t        sector_size = flash.get_sector_size(flash_end);
                uint8_t*        page_buffer = new uint8_t[page_size];
                uint32_t        addr = flash_end - sector_size + 1;
                uint32_t        addr2 = flash_end - sector_size + 2;
                uint8_t         data_write = 5;   // délai de 900 secondes ou 15 minutes par défaut
                uint8_t         data_write2 =5;     // délai de 5 secondes avant déclanchement de l'alarme
                uint8_t         data_read = 0;      // délai de 900 secondes ou 15 minutes par défaut
                uint8_t         data_read2 = 0;     // délai de 5 secondes avant déclanchement de l'alarme
                // ************************ Saisie des nouveaux paramètres *******************************
                pc.printf(" Configuration des délais: Interval de vérification et délai de déclanchement alarme \n");
                pc.printf("\n Entrer le délai interval de vérification de présence = ");
                pc.scanf("%d",&data_write);
                pc.printf("\n Entrer le délai de déclanchement d'alarme après le signal = ");
                pc.scanf("%d",&data_write2);
        
                pc.printf("flash_start = 0x%.8x\r\n", flash_start);
                pc.printf("flash_size = 0x%.8x\r\n", flash_size);
                pc.printf("flash_end = 0x%.8x\r\n", flash_end);
                pc.printf("page_size = 0x%.8x\r\n", page_size);
                pc.printf("sector_size = 0x%.8x\r\n", sector_size);
                pc.printf("addr = 0x%.8x\r\n", addr);
                pc.printf("data_write = %d\r\n", data_write);
                pc.printf("data_write2 = %d\r\n", data_write2);
                pc.printf("data_read before writing to flash = %d\r\n", data_read);
                pc.printf("data_read2 before writing to flash = %d\r\n", data_read2);
                flash.init();
                page_buffer[0] = data_write;
    
                flash.erase(addr, sector_size);
                flash.program(page_buffer, addr, page_size);
                page_buffer[0] = data_write2;
                flash.erase(addr2, sector_size);
                flash.program(page_buffer, addr2, page_size);
                page_buffer[0] = 0;
                page_buffer[1] = 0;
                flash.read(page_buffer, addr, page_size);
                data_read = page_buffer[0];
                flash.read(page_buffer, addr2, page_size);
                data_read2 = page_buffer[0];
                delete[] page_buffer;
                flash.deinit();
                pc.printf("data_read after writing to flash = %d\r\n", data_read);
                pc.printf("data_read after writing to flash = %d\r\n", data_read2);
                y=data_read;     // initialisation de Y avec la valeur de la mémoire Flash
                x=data_read2;   // initialisation de x avec la valeur de la mémoire Flash
            };     
        wait_ms(1000);
    };      // boucle les interuptions et les timeout fonctionnenent
            // toujours en parallèlé

}
    
    


