/* Programme d'alarme
Utilisation de deux interuptions sur chaque entrée A0 (PG_9) et A1 (PG_14)
afin de déclancher des actions de remise à zéro sur les états logiques des 
entrées numériques A0 et A1 qui sont respectivements reliées à des capteurs:
Capteur de présence normalement fermé ou normalement ouvert qui procure un signal 
positif en cas de présence et négatif en cas d'absence ainsi par défaut en cas de
disfonctionnement du capteur le signal reste à 0 et déclanche aussi l'alarme.
Le bouton permet d'injecter un état positif sur  l'entrée A1 (B) afin de vérifier
la présence de la personne qui doit à interval régulier appuyer sur le bouton 
afin de confirmer son état de bonne santé et de présence

Un compteur est lancé et remis à zéro par les sous programmes déclanché 
par les interuptions et si le compteur depasse un certain delai alors l'alarme 
est déclanchée   
 */

#include "mbed.h"

#define y 900    // délai de 900 secondes ou 15 minutes 
#define x 5       //  délai de 5 secondes avant déclanchement de l'alarme     

// **************** Les entrées de la carte Nucléo ************************** //

Timer mon_timer;        // Déclaration d'un timer 
DigitalIn bouton (PG_9);     // broche D0 action utilisateur sur bouton front montant
DigitalIn secteur (PG_14);    // Présence du 220V

//  ************** Les sorties de la carte Nucléo ************************************ //

DigitalOut sirene (PF_14);    // Déclanchée après un délai X suite au délai Y (Lampe et buzzer)
DigitalOut buzzer (PF_15);  // Buzzer déclanché en même temps que la lampe
DigitalOut relais (PE_13); // Relais déchanches lors de l alarme

// ************* Témoin pour les tests ***************************************** //
DigitalOut led(LED1);   // voyant de vérification pour signifier alarme activée

// ************* Déclaration d'un PWM pour le clignotement de la lampe ************** //
PwmOut lampe (PE_11); // Lampe déclanchée après un délai de Y

InterruptIn int_bouton(PG_9);     // déclaration des inéruptions liées au changement d'état
InterruptIn int_secteur(PG_14);    // des broches A et B  (capteur ou bouton

Ticker buzzer_secteur;

Timeout delai;          // Déclaration d'un timeout qui permetera de déclancher 
                        // une action après depassement d'un délai Y   
void clignote_on()    // pour la mies en marche de la lampe
    {
     lampe.periode (5);  // Période de 5 secondes
     lampe.write(0.2);  // Rapport cyclique de 20%
     }
     
void clignote_off ()   // pour l'arrêt de la lampe
    {
     lampe.periode (5);  // Période de 5 secondes
     lampe.write(0);  // Rapport cyclique de 0%
     }

void alerte ()
    {
        led.write(1);  // Allumer la LED 1 pour signifier le déclanchement de 
        clignote_on();
        buzzer.write(1);
        mon_timer.reset();
        while ( mon_timer.read() < x) {
            };
        if (mon_timer.read() > x) {
            sirene.write(1);  // déclanchement de la sirène après le délai de 5s
            };
    }
    
void raz_compteur ()
    {
    mon_timer.reset();    // Remise à zéro du timer
    delai.attach(&alerte,y);   // réinitialisation du timeout avec le délai y
    led.write(0);
    clignote_off();
    buzzer.write(0);
    } 
void bip ()
    { 
    buzzer.write(1);
    wait(1);
    buzzer.write(0);
    }
    
void secteur_off ()
    { 
    buzzer_secteur.attach(&bip,5);
    
    }
    
void secteur_on ()
    {
    buzzer_secteur.detach()                   
    }    
                       
int main()
    {
        mon_timer.reset();
        delai.attach(&alerte, y);
        int_bouton.rise(&raz_compteur);
        secteur.fall(&secteur_off);
        secteur.rise(&secteur_on);
      
    while (1);  // boucle d'arrêt car les interuptions et les timeout fonctionnenent
                // toujours en parallèlé

}
    
    