/***************************************************
  This is an example sketch for our optical Fingerprint sensor

  Designed specifically to work with the Adafruit BMP085 Breakout
  ----> http://www.adafruit.com/products/751

  These displays use TTL Serial to communicate, 2 pins are required to
  interface
  Adafruit invests time and resources providing this open source code,
  please support Adafruit and open-source hardware by purchasing
  products from Adafruit!

  Written by Limor Fried/Ladyada for Adafruit Industries.
  BSD license, all text above must be included in any redistribution
 ****************************************************/


#include <Fingerprint.h>
#include "mbed.h"
DigitalOut myled(LED1);
Serial pc(USBTX, USBRX); // tx, rx

Fingerprint finger(PC_1,PC_0,PB_0,0x0); // TX,TX,RESET,pass

void setup()
{
  pc.baud(9600);
  wait_ms(100);
  pc.printf("\n\nAdafruit finger detect test");

  // set the data rate for the sensor serial port
  finger.begin(57600);
  wait_ms(5);
  if (finger.verifyPassword()) {
    pc.printf("Found fingerprint sensor!");
  } else {
    pc.printf("Did not find fingerprint sensor :(");
    while (1)
    {
         wait_ms(1); 
    }
  }

  pc.printf("Reading sensor parameters");
  finger.getParameters();
  pc.printf("Status: 0x%X\n",finger.status_reg);
  pc.printf("Sys ID: 0x%X\n",finger.system_id);
  pc.printf("Capacity: %d\n",finger.capacity);
  pc.printf("Security level: %d\n",finger.security_level);
  pc.printf("Device address: 0x%X\n",finger.device_addr);
  pc.printf("Packet len: %d\n",finger.packet_len);
  pc.printf("Baud rate: %d\n",finger.baud_rate);

  finger.getTemplateCount();

  if (finger.templateCount == 0) {
    pc.printf("Sensor doesn't contain any fingerprint data. Please run the 'enroll' example.");
  }
  else {
    pc.printf("Waiting for valid finger...");
    pc.printf("Sensor contains : %d templates\n",finger.templateCount);
  }
}

uint8_t getFingerprintID() {
  uint8_t p = finger.getImage();
  switch (p) {
    case FINGERPRINT_OK:
      pc.printf("Image taken");
      break;
    case FINGERPRINT_NOFINGER:
      pc.printf("No finger detected");
      return p;
    case FINGERPRINT_PACKETRECIEVEERR:
      pc.printf("Communication error");
      return p;
    case FINGERPRINT_IMAGEFAIL:
      pc.printf("Imaging error");
      return p;
    default:
      pc.printf("Unknown error");
      return p;
  }

  // OK success!

  p = finger.image2Tz();
  switch (p) {
    case FINGERPRINT_OK:
      pc.printf("Image converted");
      break;
    case FINGERPRINT_IMAGEMESS:
      pc.printf("Image too messy");
      return p;
    case FINGERPRINT_PACKETRECIEVEERR:
      pc.printf("Communication error");
      return p;
    case FINGERPRINT_FEATUREFAIL:
      pc.printf("Could not find fingerprint features");
      return p;
    case FINGERPRINT_INVALIDIMAGE:
      pc.printf("Could not find fingerprint features");
      return p;
    default:
      pc.printf("Unknown error");
      return p;
  }

  // OK converted!
  p = finger.fingerSearch();
  if (p == FINGERPRINT_OK) {
    pc.printf("Found a print match!");
  } else if (p == FINGERPRINT_PACKETRECIEVEERR) {
    pc.printf("Communication error");
    return p;
  } else if (p == FINGERPRINT_NOTFOUND) {
    pc.printf("Did not find a match");
    return p;
  } else {
    pc.printf("Unknown error");
    return p;
  }

  // found a match!
  pc.printf("Found ID #%d\n",finger.fingerID);
  pc.printf(" with confidence of %d\n",finger.confidence);

  return finger.fingerID;
}

// returns -1 if failed, otherwise returns ID #
int getFingerprintIDez() {
  uint8_t p = finger.getImage();
  if (p != FINGERPRINT_OK)  return -1;

  p = finger.image2Tz();
  if (p != FINGERPRINT_OK)  return -1;

  p = finger.fingerFastSearch();
  if (p != FINGERPRINT_OK)  return -1;

  // found a match!
  pc.printf("Found ID #%d\n",finger.fingerID);
  pc.printf(" with confidence of %d\n",finger.confidence);
  return finger.fingerID;
}

int main(void)                    // run over and over again
{
  setup();
  while(1)
  {
  getFingerprintID();
  wait_ms(50);            //don't ned to run this at full speed.
  }
  return 0;
}

