#include "mbed.h"
#include "MMA8451Q.h"

#include "tsi_sensor.h"
#include "Servo.h"


#if   defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
PinName const SDA = PTE25;
PinName const SCL = PTE24;
#elif defined (TARGET_KL05Z)
PinName const SDA = PTB4;
PinName const SCL = PTB3;
#elif defined (TARGET_K20D50M)
PinName const SDA = PTB1;
PinName const SCL = PTB0;
#else
#error TARGET NOT DEFINED
#endif

#define MMA8451_I2C_ADDRESS (0x1d<<1)
/* This defines will be replaced by PinNames soon */
#if defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
#define ELEC0 9
#define ELEC1 10
#elif defined (TARGET_KL05Z)
#define ELEC0 9
#define ELEC1 8
#else
#error TARGET NOT DEFINED
#endif



int main(void)
{
    float TSILec;
    float x, y, z;
    MMA8451Q acc(SDA, SCL, MMA8451_I2C_ADDRESS);
    PwmOut red(LED_RED);
    PwmOut green(LED_GREEN);
    PwmOut blue(LED_BLUE);
    Servo Motor1(PTC9);
    TSIAnalogSlider tsi(ELEC0, ELEC1, 40);

    while (true) {
        //Check Touch Press
        if(tsi.readPercentage()>0.01) {
            TSILec=tsi.readPercentage();
            if(TSILec<0.25) {
                red=1;
                green=1;
                blue=1;
            }
            if(TSILec>0.25 && TSILec<0.5) {
                red=1;
                green=1;
                blue=0;
            }
            if(TSILec>0.5 && TSILec<0.75) {
                red=1;
                green=0;
                blue=1;
            }
            if(TSILec>0.75) {
                red=0;
                green=1;
                blue=1;
            }
            Motor1=TSILec;  //Assign touch read to motor
            wait(0.1);
        }
        //Read Accel
        else {
            x=acc.getAccX();
            y=acc.getAccY();
            z=acc.getAccZ();
            red=x;
            green=y;
            blue=z;
        }
    }
}


