#include <stdlib.h>

#include "mbed.h"
#include "TextLCD.h"

#define NUM_LAP 3
#define VBAT_MIN 7.2

typedef struct time_screen {
   int cents;
   int seconds;
   int minutes;
} measured_time;


DigitalOut heartbeat(LED1);
AnalogIn vbat(PC_3);

InterruptIn user_button(USER_BUTTON); 
InterruptIn proximity(D9); 

Timer t;
TextLCD lcd(D2,D3,D4,D5,D6,D7); 

int lap = 0;
int last_read = 0;
int lap_time = 0;


//Conversione da millisecondi a mm:ss:cc
measured_time human_read(int ms){
    measured_time read;
    div_t qr = div(ms,1000);
    
    read.cents = qr.rem % 100;
    
    qr = div(qr.quot,60);
    read.seconds = qr.rem;
    
    qr = div(qr.quot,60);
    read.minutes = qr.rem;
    
    return read;    
}

void measure_time(){
    int read = t.read_ms();
    
    if(lap == 0){
        t.start();
        lap++;
    }else{
        //Dabouncing per evitare problemi
        if(read - last_read > 1000){
            
            lap_time = read - last_read;
            
            if(lap >= NUM_LAP){
                t.stop();
                lap++;
            }else{
                lap++;
            }
            
            last_read = read;     
        }
    }
    
}

void reset_measure(){
    t.stop();
    t.reset();
    lap = 0;
    last_read = 0;
    lcd.cls();
}





int main() {
    
    proximity.mode(PullDown);
    proximity.rise(&measure_time);    
    user_button.fall(&reset_measure);
    
  
   
    
    while(true) {
        int read = t.read_ms(); 
       
        measured_time time = human_read(read);
        
        lcd.locate(0,0);
        lcd.printf("Totale %02d:%02d:%02d",time.minutes,time.seconds,time.cents);
       
        //Gestione dei parziali
        if(lap > 1){
            time = human_read(lap_time);
            lcd.locate(0,1);
            lcd.printf("Giro %d %02d:%02d:%02d",lap - 1,time.minutes,time.seconds,time.cents);
        }
        
        heartbeat = !heartbeat;
        
        
        if(lap > 0 && lap <= NUM_LAP){
            wait(0.1);
        }else{
            if(lap == 0){
                //Controllo batteria con partitore resistivo
                double battery =  ((3.3L * vbat) * 57) / 10;
                if(battery < VBAT_MIN){
                    lcd.locate(0,1);
                    lcd.printf("LOW BAT %2.1f",battery);
                }else{
                    lcd.locate(0,1);
                    lcd.printf("OK  BAT %2.1f",battery);
                }
            }
            wait(1);
        }
    }
}
