#include "mbed.h"
#include "TinyGPS.h"

//------------------------------------
// Hyperterminal configuration
// 9600 bauds, 8-bit data, no parity
//------------------------------------

Serial pc(SERIAL_TX, SERIAL_RX);
Serial gps(D8,D2);
DigitalOut myled(LED1);

TinyGPS parser;

float flat, flon, falt, fkmph;
unsigned long date,ltime;

int main() {
    gps.baud(9600);
    pc.printf("Prova GPS !\n");
    while(1) {
      /*
      if(gps.readable()) {
        pc.putc(gps.getc());
      }
      */
       if(gps.readable()) {
            if (parser.encode(gps.getc())){
                unsigned long fix_age; // returns +- latitude/longitude in degrees
                parser.f_get_position(&flat, &flon, &fix_age);
                
                if (fix_age == TinyGPS::GPS_INVALID_AGE)
                    pc.printf("No fix detected \r\n");
                else if (fix_age > 5000)
                    pc.printf("Warning: possible stale data! \r\n");
                else
                    pc.printf("Data is current. \r\n");
                
                parser.get_datetime(&date, &ltime, &fix_age);
                fkmph = parser.f_speed_kmph();
                
                
                pc.printf("Date: %d  Time: %d  lat: %f lon: %f speed: %f \r\n",date,ltime,flat,flon,fkmph);
            }
        }
    }
}
 