//gps.cpp
//for use with Adafruit Ultimate GPS
//Reads in and parses GPS data

#include "mbed.h"
#include "MBed_Adafruit_GPS.h"

Serial * gps_Serial;
Serial pc(USBTX, USBRX);
DigitalOut led1(LED1);

int main() {
    
    pc.baud(115200); //sets virtual COM serial communication to high rate; this is to allow more time to be spent on GPS retrieval
    
    pc.printf("\r\n\nProgram start\r\n");
    gps_Serial = new Serial(p13,p14); //serial object for use w/ GPS
    Adafruit_GPS myGPS(gps_Serial); //object of Adafruit's GPS class
    char c; //when read via Adafruit_GPS::read(), the class returns single character stored here
    myGPS.begin(9600);  //sets baud rate for GPS communication; note this may be changed via Adafruit_GPS::sendCommand(char *)
                        //a list of GPS commands is available at http://www.adafruit.com/datasheets/PMTK_A08.pdf
    wait(1);
    myGPS.sendCommand("$PMTK314,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0*29\r\n");     //Command to only send RMC packets
    

    
    while(true){

        c = myGPS.read();   //queries the GPS
        pc.printf("%c",c);//this line will echo the GPS data if not paused


    }
}