#ifndef AttitudeEstimator_h
#define AttitudeEstimator_h

#include "mbed.h"
#include "Matrix.h"
#include "LSM9DS1.h"

// Attitude estimator class
class AttitudeEstimator
{
  public:
    // Class constructor
    AttitudeEstimator();
    // Initialize class
    void init();
    // Estimate Euler angles (rad) and angular velocities (rad/s)
    void estimate();
    //
    void get_output();
    //
    Matrix x;
    //
    Matrix A, H, P, K, Q, R;
    //
    Matrix g, a, m;
    //
    Matrix q;
    //
    Matrix BN;
    //
    Matrix I;
  private:
    // 
    float dt, dt_half;
    //
    void read();
    // IMU sensor object
    LSM9DS1 imu;
    //
};

#endif