#include "trms.h"

#define DEBUG 1
//Debug is disabled by default
#if (defined(DEBUG))

#define DBG(x, ...) std::printf("[trms : DBG]"x"\r\n", ##__VA_ARGS__);
#define WARN(x, ...) std::printf("[trms : WARN]"x"\r\n", ##__VA_ARGS__);
#define ERR(x, ...) std::printf("[trms : ERR]"x"\r\n", ##__VA_ARGS__);
#define INFO(x, ...) std::printf("[trms : INFO]"x"\r\n", ##__VA_ARGS__);

#else

#define DBG(x, ...)
#define WARN(x, ...)
#define ERR(x, ...)
#define INFO(x, ...)
#endif

trms::trms(int adc_Diff_number_chan) : AnalogIn_Diff(adc_Diff_number_chan), vtrms(NSAMPLE,UAC_NON2)
{

    timer_min.stop();
    timer_max.stop();
    timer_min.reset();
    timer_max.reset();
    _time_min=0;
    F_timer_min=false;
    _time_max=0;
    F_timer_max=false;
    _min=UAC_NON2;
    _max=UAC_NON2;
    gain=GAIN;
    offset=0.0;
    _flag_trms=false;
    DBG("Unon =%0.0fV",UAC_NON);
    DBG("RAW Umax2 =%d",UAC_MAX2);
    DBG("RAW Umin2 =%d",UAC_MIN2);
    DBG("Gain =%f",gain);


    DBG("Freq UAC=%dHz",FREQ);
    DBG("Sample =%d",NSAMPLE);
    DBG("Sample =%dus",TSAMPLE);



}



float trms::read_rms()
{
    return (sqrt((float)vtrms.GetAverage())*gain-offset);

}

/**
 * @brief Destructor.
 */
trms::~trms()
{

    flipperadc_Diff.detach();
}

void trms::start()
{
    flipperadc_Diff.attach_us<trms>(this,&trms::flipadc_Diff, TSAMPLE);
}



void trms::flipadc_Diff()
{
    int16_t  val_i16;
    uint32_t  val2_ui32;
  
    val_i16=read_raws16();

    vtrms.Insert(val_i16*val_i16);

    val2_ui32=vtrms.GetAverage();

    //MIN
    if(val2_ui32<UAC_MIN2 && F_timer_min ==false) {

        timer_min.start();
        F_timer_min = true;

    }

    if(F_timer_min ==true) {
        if(val2_ui32>UAC_MIN2STOP  ) {

            timer_min.stop();
            F_timer_min = false;
            _flag_trms=true;   //?????????????????
            _flag_min=true;
        }


        else  if(timer_min.read_ms()>20)  {

            _time_min=timer_min.read_ms();
            _min=MIN(val2_ui32,_min);

        }
            //max
                if(val2_ui32<UAC_MAX2STOP && F_timer_max ==true) {
                timer_max.stop();
                F_timer_max = false;
                _flag_trms=true;
                _flag_max=true;
            }
                if(val2_ui32>UAC_MAX2 && F_timer_max ==false) {

                timer_max.start();
                F_timer_max = true;

            }
            if(timer_max.read_ms()>20 && F_timer_max ==true) {

                _time_max=timer_max.read_ms();
                _max=MAX(val2_ui32,_max);

            }     
    }

}

bool trms::flag (float *rms, uint32_t *time)
{
    bool old_flag =_flag_trms;

    if(_flag_trms==true) {
        _flag_trms=false;
        if(_flag_min==true) {

            *time=_time_min;
            timer_min.reset();
            *rms=(sqrt((float)_min)*gain-offset);
            _min=UAC_NON2;
            _flag_min=false;

        }

        else if(_flag_max==true) {

            *time=_time_max;
            timer_max.reset();
            *rms=(sqrt((float)_max)*gain-offset);
            _max=UAC_NON2;
            _flag_max=false;

        }

    } else {

        *rms=read_rms();
        *time=0;
    }

    return old_flag;

}


void trms::set_gain(float _gain)
{
    gain=_gain;
}

void trms::set_offset(float _offset)
{
    offset=_offset;
}
float trms::get_gain()
{
    return gain;
}

float trms::get_offset()
{
    return offset;
}
