/*
 * Copyright (c) 2014 LAAS-CNRS
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef TRMS_H
#define TRMS_H

#include "mbed.h"
#include "AnalogIn_Diff.h"
#include "math.h"
#include "MovingAverage.h"


#define FREQ 50//en HZ
#define TSAMPLE 125 //en µS
#define R1 1.0E6
#define R2 510.0
#define ADCVREF 3.3
#define GAIN_ACPL_C78 0.125
#define GAIN ((double)((R1+R2)*2.0*GAIN_ACPL_C78*ADCVREF/R2)/65535.0)
#define UAC_NON 230.0
#define UAC_MON_i32 ((int32_t)((double)UAC_NON/(double)GAIN))
#define UAC_MAX ((int32_t)((double)UAC_NON*1.1/(double)GAIN))
#define UAC_MIN ((int32_t)((double)UAC_NON*0.9/(double)GAIN))
#define UAC_NON2 ((int32_t)((double)UAC_NON/(double)GAIN*(double)UAC_NON/(double)GAIN))
#define UAC_MAX2 ((int32_t)((double)UAC_MAX*(double)UAC_MAX))
#define UAC_MIN2 ((int32_t)((double)UAC_MIN*(double)UAC_MIN))
#define UAC_MAX2STOP ((int32_t)((double)UAC_MAX*(double)UAC_MAX)*0.95)
#define UAC_MIN2STOP ((int32_t)((double)UAC_MIN*(double)UAC_MIN)*1.05)
#define NSAMPLE ((int32_t)(1/(double)FREQ *1.0E6/(double)TSAMPLE))
//#define max(a,b) ((a)>=(b)?(a):(b))
//#define min(a,b) ((a)<=(b)?(a):(b))

#define MAX(a,b) ({ typeof(a) aa = (a); typeof(b) bb = (b); aa>=bb? aa: bb; })
#define MIN(a,b) ({ typeof(a) aa = (a); typeof(b) bb = (b); aa<=bb? aa: bb; })

#define VERSION_TRMS "2014_12_10"


class trms : public AnalogIn_Diff
{

public:
    /**
    * Constructor
    *
    * @param a2d_number_chan is ADC_DIFF(#adc, #ch)
    * @return true if successful
    */

    trms(int adc_Diff_number_chan) ;

    /**
    *  destructor
    */
    ~trms();

    void start();
    float read_rms();
    float get_gain();
    void set_gain(float gain);
    float get_offset();
    void set_offset(float offset);
    bool flag(float *rms, uint32_t *time);
    
private:
   volatile bool _flag_trms;
    volatile bool _flag_max;
    volatile bool _flag_min;
   
    volatile int32_t _min;
    volatile int32_t _max;
    volatile float gain;
    volatile float offset;
    volatile bool F_timer_min;
    volatile bool F_timer_max;
    volatile uint32_t _time_min;
    volatile uint32_t _time_max;
 
    Timer timer_min;
    Timer timer_max;
    void flipadc_Diff();
    MovingAverage <uint32_t>vtrms;
    Ticker flipperadc_Diff;
    

};

#endif //TRMS_H
