/* 
 * Copyright (c) 2014 LAAS-CNRS
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#include "mbed.h"
#include "trms.h"

#define VERSION "trms_helloworld_2014_12_08"
#define CIBLE "K64F"
Serial pc(USBTX, USBRX); // tx, rx


int main()
{


pc.baud(115200); 
 trms line1_AC(ADC_DIFF(0,1));       
    pc.printf("%s %s\r\n",VERSION,CIBLE);

    line1_AC.set_gain(GAIN);
    line1_AC.set_offset(0.0);
    line1_AC.start();
    int i=0;
    while (++i<=1000) {
        wait(0.1);
        pc.printf("%f\t%f\r\n",line1_AC.read_average(),line1_AC.read_rms());
    }
}
