#include "gfx1.h"
#include "SPLC501C.h"
#include "font5x7.h"
#include "font10x16.h"

//-------------------------------------------------------------------------------------------------
//
//-------------------------------------------------------------------------------------------------
void GLCD_Initialize(void) {
    gfx1_init();

    gfx1_command(SPLC501C_ADC_NORMAL);
    gfx1_command(SPLC501C_COM63);

    gfx1_command(SPLC501C_BIAS_19);
    gfx1_command(SPLC501C_POWERON);
//nop
    gfx1_command(SPLC501C_VOLUME_MODE);
    gfx1_command(SPLC501C_VOLUME_SET | 20);
    gfx1_command(0xA4);
    gfx1_command(SPLC501C_DISPLAY_ON);
    gfx1_command(SPLC501C_DISPLAY_NORMAL);
    gfx1_command(SPLC501C_PAGE_ADDRESS | 0);
    gfx1_command(SPLC501C_COLUMN_ADDRESS_HI | 0);
    gfx1_command(SPLC501C_COLUMN_ADDRESS_LO | 0);
    gfx1_command(SPLC501C_START_LINE | 0);
    gfx1_x=0;//emulation memoire ecran
    gfx1_y=0;//emulation memoire ecran
}
//-------------------------------------------------------------------------------------------------
//
//-------------------------------------------------------------------------------------------------
void GLCD_GoTo(unsigned char x, unsigned char y) {
    gfx1_command(SPLC501C_COLUMN_ADDRESS_HI | (x >> 4));
    gfx1_command(SPLC501C_COLUMN_ADDRESS_LO | (x & 0x0F));
    gfx1_command(SPLC501C_PAGE_ADDRESS | y);
    gfx1_x=x;//emulation memoire ecran
    gfx1_y=y;//emulation memoire ecran
}
//-------------------------------------------------------------------------------------------------
//
//-------------------------------------------------------------------------------------------------
void GLCD_ClearScreen(void) {
    unsigned char x = 0, y = 0;
    for (y = 0; y < (SCREEN_HEIGHT/PIXELS_PER_PAGE); y++) {
        GLCD_GoTo(0,y);
        for (x = 0; x < SCREEN_WIDTH; x++) {
            gfx1_data(0);
        }
    }
}
//-------------------------------------------------------------------------------------------------
// Function : GLCD_WriteChar5x7
// Artuments : Char ASCII code
// Return value : none
//-------------------------------------------------------------------------------------------------
void GLCD_WriteChar5x7(char charCode) {
    char fontCollumn;

    for (fontCollumn = 0; fontCollumn < FONT_WIDTH5x7; fontCollumn++)
        gfx1_data(font5x7[((charCode- FONT_OFFSET5x7) * FONT_WIDTH5x7) + fontCollumn]);
    gfx1_data(0);
}
//-------------------------------------------------------------------------------------------------
// Function : GLCD_WriteChar10x16
// Artuments : Char ASCII code
// Return value : none
//-------------------------------------------------------------------------------------------------
void GLCD_WriteChar10x16(char charCode) {
    unsigned int fontCollumn;
    unsigned int x,y;

    y=gfx1_y;
    x=gfx1_x;
    for (fontCollumn = 0; fontCollumn < FONT_WIDTH10x16; fontCollumn+=2) {
        GLCD_GoTo(x,y);
        gfx1_data(font10x16[((charCode- FONT_OFFSET10x16)  * FONT_WIDTH10x16) + fontCollumn]);
        GLCD_GoTo(x,y+1);
        gfx1_data(font10x16[((charCode- FONT_OFFSET10x16)  * FONT_WIDTH10x16) + fontCollumn + 1]);
        x++;
    }
    gfx1_data(0);
    GLCD_GoTo(x,y);
}
//-------------------------------------------------------------------------------------------------
// Function : GLCD_WriteString10x16
// Arguments : pointer to null-terminated ASCII string
// Return value : none
//-------------------------------------------------------------------------------------------------
void GLCD_WriteString10x16(char * string) {
    while (*string) {
        GLCD_WriteChar10x16(*string++);
    }
}
//-------------------------------------------------------------------------------------------------
// Function : GLCD_WriteString5x7
// Arguments : pointer to null-terminated ASCII string
// Return value : none
//-------------------------------------------------------------------------------------------------
void GLCD_WriteString5x7(char * string) {
    while (*string) {
        GLCD_WriteChar5x7(*string++);
    }
}
//-------------------------------------------------------------------------------------------------
// Function : GLCD_SetPixel
// Arguments : x-location, y-location, color (0 or 1)
// Return value : None
//-------------------------------------------------------------------------------------------------
void GLCD_SetPixel(int x, int y, int color) {
    unsigned char temp = 0;
    if((x<SCREEN_WIDTH ) & (y<SCREEN_HEIGHT))
    {
        GLCD_GoTo(x, (y/8));
        temp = gfx1_read();
        if (color)
            temp |= (1 << (y % 8));
        else
            temp &= ~(1 << (y % 8));
        GLCD_GoTo(x, (y/8));
        gfx1_data(temp);
    }
}
//-------------------------------------------------------------------------------------------------
//
//-------------------------------------------------------------------------------------------------
void GLCD_Bitmap(char * bitmap,unsigned char left, unsigned char top, unsigned char width, unsigned char height) {
    unsigned char pageIndex, columnIndex;
    for (pageIndex = 0; pageIndex < height / 8; pageIndex++) {
        GLCD_GoTo(left, top + pageIndex);
        for (columnIndex = 0; columnIndex < width; columnIndex++)
            gfx1_data(*(bitmap++));
    }
}