// Wy&#65533;wietlacz graficzny ze sterownikiem S6B0724
// sterowanie w jezyku C od podstaw
// Plik : graphic.c
// Autor : Rados&#65533;aw Kwiecie&#65533;

#include "SPLC501C.h"

void GLCD_Rectangle(unsigned char x, unsigned char y, unsigned char b, unsigned char a , char color) {
    unsigned char j; // zmienna pomocnicza
    // rysowanie linii pionowych (boki)
    for (j = 0; j < a; j++) {
        GLCD_SetPixel(x, y + j, color);
        GLCD_SetPixel(x + b - 1, y + j, color);
    }
    // rysowanie linii poziomych (podstawy)
    for (j = 0; j < b; j++)    {
        GLCD_SetPixel(x + j, y, color);
        GLCD_SetPixel(x + j, y + a - 1, color);
    }
}


void GLCD_Circle(unsigned char cx, unsigned char cy ,unsigned char radius , char color) {
    int x, y, xchange, ychange, radiusError;
    x = radius;
    y = 0;
    xchange = 1 - 2 * radius;
    ychange = 1;
    radiusError = 0;
    while (x >= y) {
        GLCD_SetPixel(cx+x, cy+y, color);
        GLCD_SetPixel(cx-x, cy+y, color);
        GLCD_SetPixel(cx-x, cy-y, color);
        GLCD_SetPixel(cx+x, cy-y, color);
        GLCD_SetPixel(cx+y, cy+x, color);
        GLCD_SetPixel(cx-y, cy+x, color);
        GLCD_SetPixel(cx-y, cy-x, color);
        GLCD_SetPixel(cx+y, cy-x, color);
        y++;
        radiusError += ychange;
        ychange += 2;
        if ( 2*radiusError + xchange > 0 ) {
            x--;
            radiusError += xchange;
            xchange += 2;
        }
    }
}


void GLCD_Line(int X1, int Y1,int X2,int Y2 , char color) {
    int CurrentX, CurrentY, Xinc, Yinc,
    Dx, Dy, TwoDx, TwoDy,
    TwoDxAccumulatedError, TwoDyAccumulatedError;

    Dx = (X2-X1); // obliczenie sk&#65533;adowej poziomej
    Dy = (Y2-Y1); // obliczenie sk&#65533;adowej pionowej

    TwoDx = Dx + Dx; // podwojona sk&#65533;adowa pozioma
    TwoDy = Dy + Dy; // podwojona sk&#65533;adowa pionowa

    CurrentX = X1; // zaczynamy od X1
    CurrentY = Y1; // oraz Y1

    Xinc = 1; // ustalamy krok zwi&#65533;kszania pozycji w poziomie
    Yinc = 1; // ustalamy krok zwi&#65533;kszania pozycji w pionie

    if (Dx < 0) { // jesli sk&#65533;adowa pozioma jest ujemna
        Xinc = -1; // to b&#65533;dziemy si&#65533; "cofa&#65533;" (krok ujemny)
        Dx = -Dx;  // zmieniamy znak sk&#65533;adowej na dodatni
        TwoDx = -TwoDx; // jak r&#65533;wnie&#65533; podwojonej sk&#65533;adowej
    }

    if (Dy < 0) { // je&#65533;li sk&#65533;adowa pionowa jest ujemna
        Yinc = -1; // to b&#65533;dziemy si&#65533; "cofa&#65533;" (krok ujemny)
        Dy = -Dy; // zmieniamy znak sk&#65533;adowej na dodatki
        TwoDy = -TwoDy; // jak r&#65533;wniez podwojonej sk&#65533;adowej
    }

    GLCD_SetPixel(X1,Y1, color); // stawiamy pierwszy krok (zapalamy pierwszy piksel)

    if ((Dx != 0) || (Dy != 0)) { // sprawdzamy czy linia sk&#65533;ada si&#65533; z wi&#65533;cej ni&#65533; jednego punktu ;)
        // sprawdzamy czy sk&#65533;adowa pionowa jest mniejsza lub r&#65533;wna sk&#65533;adowej poziomej
        if (Dy <= Dx) { // je&#65533;li tak, to idziemy "po iksach"
            TwoDxAccumulatedError = 0; // zerujemy zmienn&#65533;
            do { // ruszamy w drog&#65533;
                CurrentX += Xinc; // do aktualnej pozycji dodajemy krok
                TwoDxAccumulatedError += TwoDy; // a tu dodajemy podwojon&#65533; sk&#65533;adow&#65533; pionow&#65533;
                if (TwoDxAccumulatedError > Dx) { // je&#65533;li TwoDxAccumulatedError jest wi&#65533;kszy od Dx
                    CurrentY += Yinc; // zwi&#65533;kszamy aktualn&#65533; pozycj&#65533; w pionie
                    TwoDxAccumulatedError -= TwoDx; // i odejmujemy TwoDx
                }
                GLCD_SetPixel(CurrentX,CurrentY, color);// stawiamy nast&#65533;pny krok (zapalamy piksel)
            } while (CurrentX != X2); // idziemy tak d&#65533;ugo, a&#65533; osi&#65533;gniemy punkt docelowy
        } else { // w przeciwnym razie idziemy "po igrekach"
            TwoDyAccumulatedError = 0;
            do {
                CurrentY += Yinc;
                TwoDyAccumulatedError += TwoDx;
                if (TwoDyAccumulatedError>Dy) {
                    CurrentX += Xinc;
                    TwoDyAccumulatedError -= TwoDy;
                }
                GLCD_SetPixel(CurrentX,CurrentY, color);
            } while (CurrentY != Y2);
        }
    }
}
