/**
* @file gfx1.cpp
* @brief library Lascar Electronics SP 5-GFX1 DISPLAY, LCD GRAPHIC, 128 X 64 DOTS
* @author Frederic BLANC
*/
#include "gfx1.h"
SPI spi1(p5, p6, p7); //definition BUS SPI
unsigned char gfx1[128][7]; //emulation memoire ecran
unsigned int gfx1_x,gfx1_y;//emulation memoire ecran
DigitalOut GFX1_CS1_PIN(p23);
DigitalOut GFX1_RST_PIN(p22);
DigitalOut GFX1_AOP_PIN(p21);

/**
 *     @brief init hard SPI
 *     @date 20/06/2011
 *
 */
void gfx1_init(void) {
    spi1.format(8, 2); //spi 8bits, mode10
    spi1.frequency(1000000); //1mhz
    GFX1_CS1_PIN=0;
    GFX1_RST_PIN=0;
    wait_us(1); //1&#65533;s
    GFX1_RST_PIN=1;
}


/**
 *     @brief Write command
 *    @param  [in] command
 *     @date 20/06/2011
 *
 */
void gfx1_command (unsigned char data ) {
    GFX1_AOP_PIN = 0;
    spi1.write (data);
    
}


/**
 *     @brief Write display data
 *    @param  [in] data
 *     @date 20/06/2011
 *
 */
void gfx1_data (unsigned char data ) {
    GFX1_AOP_PIN = 1;
    spi1.write (data);
    gfx1[gfx1_x][gfx1_y]=data;
    gfx1_x++;  //emulation memoire ecran
    if(gfx1_x>=128)
    {
       gfx1_x=0;
       gfx1_y++; 
    }
    if(gfx1_y>=8)
        gfx1_y=7;
}

/**
 *     @brief Read display data
 *    @return   data
 *     @date 20/06/2011
 *
 */
unsigned char gfx1_read(void)
{
unsigned char tmp;
    tmp=gfx1[gfx1_x][gfx1_y]; //emulation memoire ecran

return tmp;
}