/**
* @file qei_hw_motor
* @brief Keil MBC1700 demoboard and L293, QEI ,TFT, MOTOR, UART
*   C27 and C81 removed
* @author Frederic BLANC (Published 01/03/2012 www.mbed.org)
*/
#include "mbed.h"
#include "qeihw.h"
#include "GLCD_MCB1700.h"
#include "Motor.h"
#define   PPR 624 //Pulse per round of encoder
#define   PWM 0.7 // 0 to 1.0
//#define   TFT 1 //if comment TFT is OFF else if define TFT is ON (µvision limit 32Ko)
//LED
DigitalOut led_DIR(P1_28);
DigitalOut led_POS0(P1_29);
DigitalOut led_POS1(P1_31);
DigitalOut led_POS2(P2_2);
//reseved MOTOR    P2_3, P2_4, P2_5
DigitalOut led_RX(P2_6);


//QEI
QEIHW qei(QEI_DIRINV_NONE, QEI_SIGNALMODE_QUAD, QEI_CAPMODE_4X, QEI_INVINX_NONE );
//TFT
char text[32];
// MOTOR
Motor m(P2_3, P2_4, P2_5); // pwm, fwd, rev L293
int consigne=0;
float pwm=0;
int sens=0;
//serial COM0
Serial pc(P0_2, P0_3);//Tx Rx
void pc_rx(void) {
    char c;
    led_RX=1;
    c=pc.getc();
    switch (c) {
            // consigne
        case '0':
        case '1':
        case '2':
        case '3':
        case '4':
        case '5':
        case '6':
        case '7':
        case '8':
        case '9':
            pc.printf("\r\nconsigne=");
            char buf[256];
            buf[0]=c;
            pc.putc(c);
            for (int i=1; c!='\r'; ++i) {
                c=pc.getc();
                buf[i]=c;
                pc.putc(c);

            }
            pc.putc('\n');
            consigne=atoi(buf);

        case '+':
            if (c=='+') {
                ++consigne;
                pc.putc(c);
            }
        case '-':
            if (c=='-') {
                --consigne;
                pc.putc(c);
            }

            if (consigne<100)
                consigne=100;
            if (consigne>600)
                consigne=600;
            qei.SetPositionComp(QEI_COMPPOS_CH_0,consigne);
            qei.IntCmd(QEI_INTFLAG_POS0_Int, ENABLE);
            if (consigne!=0)    {
                qei.SetPositionComp(QEI_COMPPOS_CH_1,consigne-1);
                qei.IntCmd(QEI_INTFLAG_POS1_Int, ENABLE);
            }
            qei.SetPositionComp(QEI_COMPPOS_CH_2,consigne+1);
            qei.IntCmd(QEI_INTFLAG_POS2_Int, ENABLE);
            int tmp;
            tmp = consigne-qei.GetPosition();
            if (tmp > 0)
                sens=1;
            else if (tmp < 0)
                sens=-1;
            else if (tmp ==0)
                sens=0;

            break;
            //PWM
        case 'P':
        case 'p':
            pc.printf("\r\nPWM=");
            pc.scanf("%f",&pwm);
            pc.printf("%f\r\n",pwm);

            break;
            //STOP
        case ' ':
            pc.printf("\r\nSTOP\r\n");
            sens=0;
            break;

    }
    led_RX=0;
}
//ISR
void isr_POS0(void) {
    led_POS0 = 1;
    sens=0;
    qei.IntClear(QEI_INTFLAG_POS0_Int);

}

void isr_POS1(void) {
    led_POS1 = 1;
    sens=1;
    qei.IntClear(QEI_INTFLAG_POS1_Int);
}

void isr_POS2(void) {
    led_POS2 = 1;
    sens=-1;
    qei.IntClear(QEI_INTFLAG_POS2_Int);
}

int main() {
    //init GLCD
#ifdef TFT
    GLCD_Init();
    GLCD_Clear  (White);
    sprintf(text,"QEI HARDWARE MOTOR");
    GLCD_DisplayString  (0, 0, 1, (unsigned char *)text);
#endif
    //init QEI
    qei.SetDigiFilter(1UL); //4294967295
    qei.SetMaxPosition(0xFFFFFFFF);
    qei.SetVelocityTimerReload_us(100000);
    //isr POS0
    qei.AppendISR(QEI_INTFLAG_POS0_Int, &isr_POS0);
    qei.AppendISR(QEI_INTFLAG_POS1_Int, &isr_POS1);
    qei.AppendISR(QEI_INTFLAG_POS2_Int, &isr_POS2);

    pwm=PWM;
    while (1) {
        led_POS0 = 0;
        led_POS1 = 0;
        led_POS2 = 0;
        led_RX=0;
        //TFT
#ifdef TFT
        sprintf(text,"pos : %d vs %d", qei.GetPosition(),consigne);
        GLCD_DisplayString  (1, 0, 1, (unsigned char *)text);
        sprintf(text,"idx : %d    ", qei.GetIndex());
        GLCD_DisplayString  (2, 0, 1, (unsigned char *)text);
        sprintf(text,"dir : %d    ", qei.Direction() == SET ? -1 : 1);
        GLCD_DisplayString  (3, 0, 1, (unsigned char *)text);
        sprintf(text,"vel : %d    ", qei.GetVelocity ());
        GLCD_DisplayString  (4, 0, 1, (unsigned char *)text);
        sprintf(text,"rpm : %d    ", qei.CalculateRPM (qei.GetVelocityCap (), PPR));
        GLCD_DisplayString  (5, 0, 1, (unsigned char *)text);
        sprintf(text,"PWM : %f    ", pwm);
        GLCD_DisplayString  (5, 0, 1, (unsigned char *)text);
#endif
        led_DIR = qei.Direction() == SET ? 1 : 0;
        m.speed(sens * pwm);
        if (pc.readable())
            pc_rx();
    }
}
