/*
** ###################################################################
**     Compilers:           Keil ARM C/C++ Compiler
**                          Freescale C/C++ for Embedded ARM
**                          GNU C Compiler
**                          IAR ANSI C/C++ Compiler for ARM
**
**     Reference manual:    K22P121M120SF7RM, Rev. 1, March 24, 2014
**     Version:             rev. 2.5, 2014-05-06
**     Build:               b140604
**
**     Abstract:
**         Extension to the CMSIS register access layer header.
**
**     Copyright (c) 2014 Freescale Semiconductor, Inc.
**     All rights reserved.
**
**     Redistribution and use in source and binary forms, with or without modification,
**     are permitted provided that the following conditions are met:
**
**     o Redistributions of source code must retain the above copyright notice, this list
**       of conditions and the following disclaimer.
**
**     o Redistributions in binary form must reproduce the above copyright notice, this
**       list of conditions and the following disclaimer in the documentation and/or
**       other materials provided with the distribution.
**
**     o Neither the name of Freescale Semiconductor, Inc. nor the names of its
**       contributors may be used to endorse or promote products derived from this
**       software without specific prior written permission.
**
**     THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
**     ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
**     WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
**     DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
**     ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
**     (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
**     LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
**     ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
**     (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
**     SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
**     http:                 www.freescale.com
**     mail:                 support@freescale.com
**
**     Revisions:
**     - rev. 1.0 (2013-07-23)
**         Initial version.
**     - rev. 1.1 (2013-09-17)
**         RM rev. 0.4 update.
**     - rev. 2.0 (2013-10-29)
**         Register accessor macros added to the memory map.
**         Symbols for Processor Expert memory map compatibility added to the memory map.
**         Startup file for gcc has been updated according to CMSIS 3.2.
**         System initialization updated.
**     - rev. 2.1 (2013-10-30)
**         Definition of BITBAND macros updated to support peripherals with 32-bit acces disabled.
**     - rev. 2.2 (2013-12-20)
**         Update according to reference manual rev. 0.6,
**     - rev. 2.3 (2014-01-13)
**         Update according to reference manual rev. 0.61,
**     - rev. 2.4 (2014-02-10)
**         The declaration of clock configurations has been moved to separate header file system_MK22F51212.h
**     - rev. 2.5 (2014-05-06)
**         Update according to reference manual rev. 1.0,
**         Update of system and startup files.
**         Module access macro module_BASES replaced by module_BASE_PTRS.
**
** ###################################################################
*/

/*
 * WARNING! DO NOT EDIT THIS FILE DIRECTLY!
 *
 * This file was generated automatically and any changes may be lost.
 */
#ifndef __HW_FTFA_REGISTERS_H__
#define __HW_FTFA_REGISTERS_H__

#include "MK22F51212.h"
#include "fsl_bitaccess.h"

/*
 * MK22F51212 FTFA
 *
 * Flash Memory Interface
 *
 * Registers defined in this header file:
 * - HW_FTFA_FSTAT - Flash Status Register
 * - HW_FTFA_FCNFG - Flash Configuration Register
 * - HW_FTFA_FSEC - Flash Security Register
 * - HW_FTFA_FOPT - Flash Option Register
 * - HW_FTFA_FCCOB3 - Flash Common Command Object Registers
 * - HW_FTFA_FCCOB2 - Flash Common Command Object Registers
 * - HW_FTFA_FCCOB1 - Flash Common Command Object Registers
 * - HW_FTFA_FCCOB0 - Flash Common Command Object Registers
 * - HW_FTFA_FCCOB7 - Flash Common Command Object Registers
 * - HW_FTFA_FCCOB6 - Flash Common Command Object Registers
 * - HW_FTFA_FCCOB5 - Flash Common Command Object Registers
 * - HW_FTFA_FCCOB4 - Flash Common Command Object Registers
 * - HW_FTFA_FCCOBB - Flash Common Command Object Registers
 * - HW_FTFA_FCCOBA - Flash Common Command Object Registers
 * - HW_FTFA_FCCOB9 - Flash Common Command Object Registers
 * - HW_FTFA_FCCOB8 - Flash Common Command Object Registers
 * - HW_FTFA_FPROT3 - Program Flash Protection Registers
 * - HW_FTFA_FPROT2 - Program Flash Protection Registers
 * - HW_FTFA_FPROT1 - Program Flash Protection Registers
 * - HW_FTFA_FPROT0 - Program Flash Protection Registers
 * - HW_FTFA_XACCH3 - Execute-only Access Registers
 * - HW_FTFA_XACCH2 - Execute-only Access Registers
 * - HW_FTFA_XACCH1 - Execute-only Access Registers
 * - HW_FTFA_XACCH0 - Execute-only Access Registers
 * - HW_FTFA_XACCL3 - Execute-only Access Registers
 * - HW_FTFA_XACCL2 - Execute-only Access Registers
 * - HW_FTFA_XACCL1 - Execute-only Access Registers
 * - HW_FTFA_XACCL0 - Execute-only Access Registers
 * - HW_FTFA_SACCH3 - Supervisor-only Access Registers
 * - HW_FTFA_SACCH2 - Supervisor-only Access Registers
 * - HW_FTFA_SACCH1 - Supervisor-only Access Registers
 * - HW_FTFA_SACCH0 - Supervisor-only Access Registers
 * - HW_FTFA_SACCL3 - Supervisor-only Access Registers
 * - HW_FTFA_SACCL2 - Supervisor-only Access Registers
 * - HW_FTFA_SACCL1 - Supervisor-only Access Registers
 * - HW_FTFA_SACCL0 - Supervisor-only Access Registers
 * - HW_FTFA_FACSS - Flash Access Segment Size Register
 * - HW_FTFA_FACSN - Flash Access Segment Number Register
 *
 * - hw_ftfa_t - Struct containing all module registers.
 */

#define HW_FTFA_INSTANCE_COUNT (1U) /*!< Number of instances of the FTFA module. */

/*******************************************************************************
 * HW_FTFA_FSTAT - Flash Status Register
 ******************************************************************************/

/*!
 * @brief HW_FTFA_FSTAT - Flash Status Register (RW)
 *
 * Reset value: 0x00U
 *
 * The FSTAT register reports the operational status of the flash memory module.
 * The CCIF, RDCOLERR, ACCERR, and FPVIOL bits are readable and writable. The
 * MGSTAT0 bit is read only. The unassigned bits read 0 and are not writable. When
 * set, the Access Error (ACCERR) and Flash Protection Violation (FPVIOL) bits in
 * this register prevent the launch of any more commands until the flag is
 * cleared (by writing a one to it).
 */
typedef union _hw_ftfa_fstat
{
    uint8_t U;
    struct _hw_ftfa_fstat_bitfields
    {
        uint8_t MGSTAT0 : 1;           /*!< [0] Memory Controller Command Completion
                                        * Status Flag */
        uint8_t RESERVED0 : 3;         /*!< [3:1]  */
        uint8_t FPVIOL : 1;            /*!< [4] Flash Protection Violation Flag */
        uint8_t ACCERR : 1;            /*!< [5] Flash Access Error Flag */
        uint8_t RDCOLERR : 1;          /*!< [6] Flash Read Collision Error Flag */
        uint8_t CCIF : 1;              /*!< [7] Command Complete Interrupt Flag */
    } B;
} hw_ftfa_fstat_t;

/*!
 * @name Constants and macros for entire FTFA_FSTAT register
 */
/*@{*/
#define HW_FTFA_FSTAT_ADDR(x)    ((x) + 0x0U)

#define HW_FTFA_FSTAT(x)         (*(__IO hw_ftfa_fstat_t *) HW_FTFA_FSTAT_ADDR(x))
#define HW_FTFA_FSTAT_RD(x)      (HW_FTFA_FSTAT(x).U)
#define HW_FTFA_FSTAT_WR(x, v)   (HW_FTFA_FSTAT(x).U = (v))
#define HW_FTFA_FSTAT_SET(x, v)  (HW_FTFA_FSTAT_WR(x, HW_FTFA_FSTAT_RD(x) |  (v)))
#define HW_FTFA_FSTAT_CLR(x, v)  (HW_FTFA_FSTAT_WR(x, HW_FTFA_FSTAT_RD(x) & ~(v)))
#define HW_FTFA_FSTAT_TOG(x, v)  (HW_FTFA_FSTAT_WR(x, HW_FTFA_FSTAT_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual FTFA_FSTAT bitfields
 */

/*!
 * @name Register FTFA_FSTAT, field MGSTAT0[0] (RO)
 *
 * The MGSTAT0 status flag is set if an error is detected during execution of a
 * flash command or during the flash reset sequence. As a status flag, this field
 * cannot (and need not) be cleared by the user like the other error flags in
 * this register. The value of the MGSTAT0 bit for "command-N" is valid only at the
 * end of the "command-N" execution when CCIF=1 and before the next command has
 * been launched. At some point during the execution of "command-N+1," the
 * previous result is discarded and any previous error is cleared.
 */
/*@{*/
#define BP_FTFA_FSTAT_MGSTAT0 (0U)         /*!< Bit position for FTFA_FSTAT_MGSTAT0. */
#define BM_FTFA_FSTAT_MGSTAT0 (0x01U)      /*!< Bit mask for FTFA_FSTAT_MGSTAT0. */
#define BS_FTFA_FSTAT_MGSTAT0 (1U)         /*!< Bit field size in bits for FTFA_FSTAT_MGSTAT0. */

/*! @brief Read current value of the FTFA_FSTAT_MGSTAT0 field. */
#define BR_FTFA_FSTAT_MGSTAT0(x) (BITBAND_ACCESS8(HW_FTFA_FSTAT_ADDR(x), BP_FTFA_FSTAT_MGSTAT0))
/*@}*/

/*!
 * @name Register FTFA_FSTAT, field FPVIOL[4] (W1C)
 *
 * Indicates an attempt was made to program or erase an address in a protected
 * area of program flash memory during a command write sequence . While FPVIOL is
 * set, the CCIF flag cannot be cleared to launch a command. The FPVIOL bit is
 * cleared by writing a 1 to it. Writing a 0 to the FPVIOL bit has no effect.
 *
 * Values:
 * - 0 - No protection violation detected
 * - 1 - Protection violation detected
 */
/*@{*/
#define BP_FTFA_FSTAT_FPVIOL (4U)          /*!< Bit position for FTFA_FSTAT_FPVIOL. */
#define BM_FTFA_FSTAT_FPVIOL (0x10U)       /*!< Bit mask for FTFA_FSTAT_FPVIOL. */
#define BS_FTFA_FSTAT_FPVIOL (1U)          /*!< Bit field size in bits for FTFA_FSTAT_FPVIOL. */

/*! @brief Read current value of the FTFA_FSTAT_FPVIOL field. */
#define BR_FTFA_FSTAT_FPVIOL(x) (BITBAND_ACCESS8(HW_FTFA_FSTAT_ADDR(x), BP_FTFA_FSTAT_FPVIOL))

/*! @brief Format value for bitfield FTFA_FSTAT_FPVIOL. */
#define BF_FTFA_FSTAT_FPVIOL(v) ((uint8_t)((uint8_t)(v) << BP_FTFA_FSTAT_FPVIOL) & BM_FTFA_FSTAT_FPVIOL)

/*! @brief Set the FPVIOL field to a new value. */
#define BW_FTFA_FSTAT_FPVIOL(x, v) (BITBAND_ACCESS8(HW_FTFA_FSTAT_ADDR(x), BP_FTFA_FSTAT_FPVIOL) = (v))
/*@}*/

/*!
 * @name Register FTFA_FSTAT, field ACCERR[5] (W1C)
 *
 * Indicates an illegal access has occurred to a flash memory resource caused by
 * a violation of the command write sequence or issuing an illegal flash
 * command. While ACCERR is set, the CCIF flag cannot be cleared to launch a command.
 * The ACCERR bit is cleared by writing a 1 to it. Writing a 0 to the ACCERR bit
 * has no effect.
 *
 * Values:
 * - 0 - No access error detected
 * - 1 - Access error detected
 */
/*@{*/
#define BP_FTFA_FSTAT_ACCERR (5U)          /*!< Bit position for FTFA_FSTAT_ACCERR. */
#define BM_FTFA_FSTAT_ACCERR (0x20U)       /*!< Bit mask for FTFA_FSTAT_ACCERR. */
#define BS_FTFA_FSTAT_ACCERR (1U)          /*!< Bit field size in bits for FTFA_FSTAT_ACCERR. */

/*! @brief Read current value of the FTFA_FSTAT_ACCERR field. */
#define BR_FTFA_FSTAT_ACCERR(x) (BITBAND_ACCESS8(HW_FTFA_FSTAT_ADDR(x), BP_FTFA_FSTAT_ACCERR))

/*! @brief Format value for bitfield FTFA_FSTAT_ACCERR. */
#define BF_FTFA_FSTAT_ACCERR(v) ((uint8_t)((uint8_t)(v) << BP_FTFA_FSTAT_ACCERR) & BM_FTFA_FSTAT_ACCERR)

/*! @brief Set the ACCERR field to a new value. */
#define BW_FTFA_FSTAT_ACCERR(x, v) (BITBAND_ACCESS8(HW_FTFA_FSTAT_ADDR(x), BP_FTFA_FSTAT_ACCERR) = (v))
/*@}*/

/*!
 * @name Register FTFA_FSTAT, field RDCOLERR[6] (W1C)
 *
 * Indicates that the MCU attempted a read from a flash memory resource that was
 * being manipulated by a flash command (CCIF=0). Any simultaneous access is
 * detected as a collision error by the block arbitration logic. The read data in
 * this case cannot be guaranteed. The RDCOLERR bit is cleared by writing a 1 to
 * it. Writing a 0 to RDCOLERR has no effect.
 *
 * Values:
 * - 0 - No collision error detected
 * - 1 - Collision error detected
 */
/*@{*/
#define BP_FTFA_FSTAT_RDCOLERR (6U)        /*!< Bit position for FTFA_FSTAT_RDCOLERR. */
#define BM_FTFA_FSTAT_RDCOLERR (0x40U)     /*!< Bit mask for FTFA_FSTAT_RDCOLERR. */
#define BS_FTFA_FSTAT_RDCOLERR (1U)        /*!< Bit field size in bits for FTFA_FSTAT_RDCOLERR. */

/*! @brief Read current value of the FTFA_FSTAT_RDCOLERR field. */
#define BR_FTFA_FSTAT_RDCOLERR(x) (BITBAND_ACCESS8(HW_FTFA_FSTAT_ADDR(x), BP_FTFA_FSTAT_RDCOLERR))

/*! @brief Format value for bitfield FTFA_FSTAT_RDCOLERR. */
#define BF_FTFA_FSTAT_RDCOLERR(v) ((uint8_t)((uint8_t)(v) << BP_FTFA_FSTAT_RDCOLERR) & BM_FTFA_FSTAT_RDCOLERR)

/*! @brief Set the RDCOLERR field to a new value. */
#define BW_FTFA_FSTAT_RDCOLERR(x, v) (BITBAND_ACCESS8(HW_FTFA_FSTAT_ADDR(x), BP_FTFA_FSTAT_RDCOLERR) = (v))
/*@}*/

/*!
 * @name Register FTFA_FSTAT, field CCIF[7] (W1C)
 *
 * Indicates that a flash command has completed. The CCIF flag is cleared by
 * writing a 1 to CCIF to launch a command, and CCIF stays low until command
 * completion or command violation. CCIF is reset to 0 but is set to 1 by the memory
 * controller at the end of the reset initialization sequence. Depending on how
 * quickly the read occurs after reset release, the user may or may not see the 0
 * hardware reset value.
 *
 * Values:
 * - 0 - Flash command in progress
 * - 1 - Flash command has completed
 */
/*@{*/
#define BP_FTFA_FSTAT_CCIF   (7U)          /*!< Bit position for FTFA_FSTAT_CCIF. */
#define BM_FTFA_FSTAT_CCIF   (0x80U)       /*!< Bit mask for FTFA_FSTAT_CCIF. */
#define BS_FTFA_FSTAT_CCIF   (1U)          /*!< Bit field size in bits for FTFA_FSTAT_CCIF. */

/*! @brief Read current value of the FTFA_FSTAT_CCIF field. */
#define BR_FTFA_FSTAT_CCIF(x) (BITBAND_ACCESS8(HW_FTFA_FSTAT_ADDR(x), BP_FTFA_FSTAT_CCIF))

/*! @brief Format value for bitfield FTFA_FSTAT_CCIF. */
#define BF_FTFA_FSTAT_CCIF(v) ((uint8_t)((uint8_t)(v) << BP_FTFA_FSTAT_CCIF) & BM_FTFA_FSTAT_CCIF)

/*! @brief Set the CCIF field to a new value. */
#define BW_FTFA_FSTAT_CCIF(x, v) (BITBAND_ACCESS8(HW_FTFA_FSTAT_ADDR(x), BP_FTFA_FSTAT_CCIF) = (v))
/*@}*/

/*******************************************************************************
 * HW_FTFA_FCNFG - Flash Configuration Register
 ******************************************************************************/

/*!
 * @brief HW_FTFA_FCNFG - Flash Configuration Register (RW)
 *
 * Reset value: 0x00U
 *
 * This register provides information on the current functional state of the
 * flash memory module. The erase control bits (ERSAREQ and ERSSUSP) have write
 * restrictions. The unassigned bits read as noted and are not writable.
 */
typedef union _hw_ftfa_fcnfg
{
    uint8_t U;
    struct _hw_ftfa_fcnfg_bitfields
    {
        uint8_t RESERVED0 : 4;         /*!< [3:0]  */
        uint8_t ERSSUSP : 1;           /*!< [4] Erase Suspend */
        uint8_t ERSAREQ : 1;           /*!< [5] Erase All Request */
        uint8_t RDCOLLIE : 1;          /*!< [6] Read Collision Error Interrupt Enable
                                        * */
        uint8_t CCIE : 1;              /*!< [7] Command Complete Interrupt Enable */
    } B;
} hw_ftfa_fcnfg_t;

/*!
 * @name Constants and macros for entire FTFA_FCNFG register
 */
/*@{*/
#define HW_FTFA_FCNFG_ADDR(x)    ((x) + 0x1U)

#define HW_FTFA_FCNFG(x)         (*(__IO hw_ftfa_fcnfg_t *) HW_FTFA_FCNFG_ADDR(x))
#define HW_FTFA_FCNFG_RD(x)      (HW_FTFA_FCNFG(x).U)
#define HW_FTFA_FCNFG_WR(x, v)   (HW_FTFA_FCNFG(x).U = (v))
#define HW_FTFA_FCNFG_SET(x, v)  (HW_FTFA_FCNFG_WR(x, HW_FTFA_FCNFG_RD(x) |  (v)))
#define HW_FTFA_FCNFG_CLR(x, v)  (HW_FTFA_FCNFG_WR(x, HW_FTFA_FCNFG_RD(x) & ~(v)))
#define HW_FTFA_FCNFG_TOG(x, v)  (HW_FTFA_FCNFG_WR(x, HW_FTFA_FCNFG_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual FTFA_FCNFG bitfields
 */

/*!
 * @name Register FTFA_FCNFG, field ERSSUSP[4] (RW)
 *
 * Allows the user to suspend (interrupt) the Erase Flash Sector command while
 * it is executing.
 *
 * Values:
 * - 0 - No suspend requested
 * - 1 - Suspend the current Erase Flash Sector command execution.
 */
/*@{*/
#define BP_FTFA_FCNFG_ERSSUSP (4U)         /*!< Bit position for FTFA_FCNFG_ERSSUSP. */
#define BM_FTFA_FCNFG_ERSSUSP (0x10U)      /*!< Bit mask for FTFA_FCNFG_ERSSUSP. */
#define BS_FTFA_FCNFG_ERSSUSP (1U)         /*!< Bit field size in bits for FTFA_FCNFG_ERSSUSP. */

/*! @brief Read current value of the FTFA_FCNFG_ERSSUSP field. */
#define BR_FTFA_FCNFG_ERSSUSP(x) (BITBAND_ACCESS8(HW_FTFA_FCNFG_ADDR(x), BP_FTFA_FCNFG_ERSSUSP))

/*! @brief Format value for bitfield FTFA_FCNFG_ERSSUSP. */
#define BF_FTFA_FCNFG_ERSSUSP(v) ((uint8_t)((uint8_t)(v) << BP_FTFA_FCNFG_ERSSUSP) & BM_FTFA_FCNFG_ERSSUSP)

/*! @brief Set the ERSSUSP field to a new value. */
#define BW_FTFA_FCNFG_ERSSUSP(x, v) (BITBAND_ACCESS8(HW_FTFA_FCNFG_ADDR(x), BP_FTFA_FCNFG_ERSSUSP) = (v))
/*@}*/

/*!
 * @name Register FTFA_FCNFG, field ERSAREQ[5] (RO)
 *
 * Issues a request to the memory controller to execute the Erase All Blocks
 * command and release security. ERSAREQ is not directly writable but is under
 * indirect user control. Refer to the device's Chip Configuration details on how to
 * request this command. ERSAREQ sets when an erase all request is triggered
 * external to the flash memory module and CCIF is set (no command is currently being
 * executed). ERSAREQ is cleared by the flash memory module when the operation
 * completes.
 *
 * Values:
 * - 0 - No request or request complete
 * - 1 - Request to: run the Erase All Blocks command, verify the erased state,
 *     program the security byte in the Flash Configuration Field to the unsecure
 *     state, and release MCU security by setting the FSEC[SEC] field to the
 *     unsecure state.
 */
/*@{*/
#define BP_FTFA_FCNFG_ERSAREQ (5U)         /*!< Bit position for FTFA_FCNFG_ERSAREQ. */
#define BM_FTFA_FCNFG_ERSAREQ (0x20U)      /*!< Bit mask for FTFA_FCNFG_ERSAREQ. */
#define BS_FTFA_FCNFG_ERSAREQ (1U)         /*!< Bit field size in bits for FTFA_FCNFG_ERSAREQ. */

/*! @brief Read current value of the FTFA_FCNFG_ERSAREQ field. */
#define BR_FTFA_FCNFG_ERSAREQ(x) (BITBAND_ACCESS8(HW_FTFA_FCNFG_ADDR(x), BP_FTFA_FCNFG_ERSAREQ))
/*@}*/

/*!
 * @name Register FTFA_FCNFG, field RDCOLLIE[6] (RW)
 *
 * Controls interrupt generation when a flash memory read collision error occurs.
 *
 * Values:
 * - 0 - Read collision error interrupt disabled
 * - 1 - Read collision error interrupt enabled. An interrupt request is
 *     generated whenever a flash memory read collision error is detected (see the
 *     description of FSTAT[RDCOLERR]).
 */
/*@{*/
#define BP_FTFA_FCNFG_RDCOLLIE (6U)        /*!< Bit position for FTFA_FCNFG_RDCOLLIE. */
#define BM_FTFA_FCNFG_RDCOLLIE (0x40U)     /*!< Bit mask for FTFA_FCNFG_RDCOLLIE. */
#define BS_FTFA_FCNFG_RDCOLLIE (1U)        /*!< Bit field size in bits for FTFA_FCNFG_RDCOLLIE. */

/*! @brief Read current value of the FTFA_FCNFG_RDCOLLIE field. */
#define BR_FTFA_FCNFG_RDCOLLIE(x) (BITBAND_ACCESS8(HW_FTFA_FCNFG_ADDR(x), BP_FTFA_FCNFG_RDCOLLIE))

/*! @brief Format value for bitfield FTFA_FCNFG_RDCOLLIE. */
#define BF_FTFA_FCNFG_RDCOLLIE(v) ((uint8_t)((uint8_t)(v) << BP_FTFA_FCNFG_RDCOLLIE) & BM_FTFA_FCNFG_RDCOLLIE)

/*! @brief Set the RDCOLLIE field to a new value. */
#define BW_FTFA_FCNFG_RDCOLLIE(x, v) (BITBAND_ACCESS8(HW_FTFA_FCNFG_ADDR(x), BP_FTFA_FCNFG_RDCOLLIE) = (v))
/*@}*/

/*!
 * @name Register FTFA_FCNFG, field CCIE[7] (RW)
 *
 * Controls interrupt generation when a flash command completes.
 *
 * Values:
 * - 0 - Command complete interrupt disabled
 * - 1 - Command complete interrupt enabled. An interrupt request is generated
 *     whenever the FSTAT[CCIF] flag is set.
 */
/*@{*/
#define BP_FTFA_FCNFG_CCIE   (7U)          /*!< Bit position for FTFA_FCNFG_CCIE. */
#define BM_FTFA_FCNFG_CCIE   (0x80U)       /*!< Bit mask for FTFA_FCNFG_CCIE. */
#define BS_FTFA_FCNFG_CCIE   (1U)          /*!< Bit field size in bits for FTFA_FCNFG_CCIE. */

/*! @brief Read current value of the FTFA_FCNFG_CCIE field. */
#define BR_FTFA_FCNFG_CCIE(x) (BITBAND_ACCESS8(HW_FTFA_FCNFG_ADDR(x), BP_FTFA_FCNFG_CCIE))

/*! @brief Format value for bitfield FTFA_FCNFG_CCIE. */
#define BF_FTFA_FCNFG_CCIE(v) ((uint8_t)((uint8_t)(v) << BP_FTFA_FCNFG_CCIE) & BM_FTFA_FCNFG_CCIE)

/*! @brief Set the CCIE field to a new value. */
#define BW_FTFA_FCNFG_CCIE(x, v) (BITBAND_ACCESS8(HW_FTFA_FCNFG_ADDR(x), BP_FTFA_FCNFG_CCIE) = (v))
/*@}*/

/*******************************************************************************
 * HW_FTFA_FSEC - Flash Security Register
 ******************************************************************************/

/*!
 * @brief HW_FTFA_FSEC - Flash Security Register (RO)
 *
 * Reset value: 0x00U
 *
 * This read-only register holds all bits associated with the security of the
 * MCU and flash memory module. During the reset sequence, the register is loaded
 * with the contents of the flash security byte in the Flash Configuration Field
 * located in program flash memory. The flash basis for the values is signified by
 * X in the reset value.
 */
typedef union _hw_ftfa_fsec
{
    uint8_t U;
    struct _hw_ftfa_fsec_bitfields
    {
        uint8_t SEC : 2;               /*!< [1:0] Flash Security */
        uint8_t FSLACC : 2;            /*!< [3:2] Freescale Failure Analysis Access Code
                                        * */
        uint8_t MEEN : 2;              /*!< [5:4] Mass Erase Enable Bits */
        uint8_t KEYEN : 2;             /*!< [7:6] Backdoor Key Security Enable */
    } B;
} hw_ftfa_fsec_t;

/*!
 * @name Constants and macros for entire FTFA_FSEC register
 */
/*@{*/
#define HW_FTFA_FSEC_ADDR(x)     ((x) + 0x2U)

#define HW_FTFA_FSEC(x)          (*(__I hw_ftfa_fsec_t *) HW_FTFA_FSEC_ADDR(x))
#define HW_FTFA_FSEC_RD(x)       (HW_FTFA_FSEC(x).U)
/*@}*/

/*
 * Constants & macros for individual FTFA_FSEC bitfields
 */

/*!
 * @name Register FTFA_FSEC, field SEC[1:0] (RO)
 *
 * Defines the security state of the MCU. In the secure state, the MCU limits
 * access to flash memory module resources. The limitations are defined per device
 * and are detailed in the Chip Configuration details. If the flash memory module
 * is unsecured using backdoor key access, SEC is forced to 10b.
 *
 * Values:
 * - 00 - MCU security status is secure.
 * - 01 - MCU security status is secure.
 * - 10 - MCU security status is unsecure. (The standard shipping condition of
 *     the flash memory module is unsecure.)
 * - 11 - MCU security status is secure.
 */
/*@{*/
#define BP_FTFA_FSEC_SEC     (0U)          /*!< Bit position for FTFA_FSEC_SEC. */
#define BM_FTFA_FSEC_SEC     (0x03U)       /*!< Bit mask for FTFA_FSEC_SEC. */
#define BS_FTFA_FSEC_SEC     (2U)          /*!< Bit field size in bits for FTFA_FSEC_SEC. */

/*! @brief Read current value of the FTFA_FSEC_SEC field. */
#define BR_FTFA_FSEC_SEC(x)  (HW_FTFA_FSEC(x).B.SEC)
/*@}*/

/*!
 * @name Register FTFA_FSEC, field FSLACC[3:2] (RO)
 *
 * Enables or disables access to the flash memory contents during returned part
 * failure analysis at Freescale. When SEC is secure and FSLACC is denied, access
 * to the program flash contents is denied and any failure analysis performed by
 * Freescale factory test must begin with a full erase to unsecure the part.
 * When access is granted (SEC is unsecure, or SEC is secure and FSLACC is granted),
 * Freescale factory testing has visibility of the current flash contents. The
 * state of the FSLACC bits is only relevant when SEC is set to secure. When SEC
 * is set to unsecure, the FSLACC setting does not matter.
 *
 * Values:
 * - 00 - Freescale factory access granted
 * - 01 - Freescale factory access denied
 * - 10 - Freescale factory access denied
 * - 11 - Freescale factory access granted
 */
/*@{*/
#define BP_FTFA_FSEC_FSLACC  (2U)          /*!< Bit position for FTFA_FSEC_FSLACC. */
#define BM_FTFA_FSEC_FSLACC  (0x0CU)       /*!< Bit mask for FTFA_FSEC_FSLACC. */
#define BS_FTFA_FSEC_FSLACC  (2U)          /*!< Bit field size in bits for FTFA_FSEC_FSLACC. */

/*! @brief Read current value of the FTFA_FSEC_FSLACC field. */
#define BR_FTFA_FSEC_FSLACC(x) (HW_FTFA_FSEC(x).B.FSLACC)
/*@}*/

/*!
 * @name Register FTFA_FSEC, field MEEN[5:4] (RO)
 *
 * Enables and disables mass erase capability of the flash memory module. The
 * state of this field is relevant only when SEC is set to secure outside of NVM
 * Normal Mode. When SEC is set to unsecure, the MEEN setting does not matter.
 *
 * Values:
 * - 00 - Mass erase is enabled
 * - 01 - Mass erase is enabled
 * - 10 - Mass erase is disabled
 * - 11 - Mass erase is enabled
 */
/*@{*/
#define BP_FTFA_FSEC_MEEN    (4U)          /*!< Bit position for FTFA_FSEC_MEEN. */
#define BM_FTFA_FSEC_MEEN    (0x30U)       /*!< Bit mask for FTFA_FSEC_MEEN. */
#define BS_FTFA_FSEC_MEEN    (2U)          /*!< Bit field size in bits for FTFA_FSEC_MEEN. */

/*! @brief Read current value of the FTFA_FSEC_MEEN field. */
#define BR_FTFA_FSEC_MEEN(x) (HW_FTFA_FSEC(x).B.MEEN)
/*@}*/

/*!
 * @name Register FTFA_FSEC, field KEYEN[7:6] (RO)
 *
 * Enables or disables backdoor key access to the flash memory module.
 *
 * Values:
 * - 00 - Backdoor key access disabled
 * - 01 - Backdoor key access disabled (preferred KEYEN state to disable
 *     backdoor key access)
 * - 10 - Backdoor key access enabled
 * - 11 - Backdoor key access disabled
 */
/*@{*/
#define BP_FTFA_FSEC_KEYEN   (6U)          /*!< Bit position for FTFA_FSEC_KEYEN. */
#define BM_FTFA_FSEC_KEYEN   (0xC0U)       /*!< Bit mask for FTFA_FSEC_KEYEN. */
#define BS_FTFA_FSEC_KEYEN   (2U)          /*!< Bit field size in bits for FTFA_FSEC_KEYEN. */

/*! @brief Read current value of the FTFA_FSEC_KEYEN field. */
#define BR_FTFA_FSEC_KEYEN(x) (HW_FTFA_FSEC(x).B.KEYEN)
/*@}*/

/*******************************************************************************
 * HW_FTFA_FOPT - Flash Option Register
 ******************************************************************************/

/*!
 * @brief HW_FTFA_FOPT - Flash Option Register (RO)
 *
 * Reset value: 0x00U
 *
 * The flash option register allows the MCU to customize its operations by
 * examining the state of these read-only bits, which are loaded from NVM at reset.
 * The function of the bits is defined in the device's Chip Configuration details.
 * All bits in the register are read-only . During the reset sequence, the
 * register is loaded from the flash nonvolatile option byte in the Flash Configuration
 * Field located in program flash memory. The flash basis for the values is
 * signified by X in the reset value. However, the register is written to 0xFF if the
 * contents of the flash nonvolatile option byte are 0x00.
 */
typedef union _hw_ftfa_fopt
{
    uint8_t U;
    struct _hw_ftfa_fopt_bitfields
    {
        uint8_t OPT : 8;               /*!< [7:0] Nonvolatile Option */
    } B;
} hw_ftfa_fopt_t;

/*!
 * @name Constants and macros for entire FTFA_FOPT register
 */
/*@{*/
#define HW_FTFA_FOPT_ADDR(x)     ((x) + 0x3U)

#define HW_FTFA_FOPT(x)          (*(__I hw_ftfa_fopt_t *) HW_FTFA_FOPT_ADDR(x))
#define HW_FTFA_FOPT_RD(x)       (HW_FTFA_FOPT(x).U)
/*@}*/

/*
 * Constants & macros for individual FTFA_FOPT bitfields
 */

/*!
 * @name Register FTFA_FOPT, field OPT[7:0] (RO)
 *
 * These bits are loaded from flash to this register at reset. Refer to the
 * device's Chip Configuration details for the definition and use of these bits.
 */
/*@{*/
#define BP_FTFA_FOPT_OPT     (0U)          /*!< Bit position for FTFA_FOPT_OPT. */
#define BM_FTFA_FOPT_OPT     (0xFFU)       /*!< Bit mask for FTFA_FOPT_OPT. */
#define BS_FTFA_FOPT_OPT     (8U)          /*!< Bit field size in bits for FTFA_FOPT_OPT. */

/*! @brief Read current value of the FTFA_FOPT_OPT field. */
#define BR_FTFA_FOPT_OPT(x)  (HW_FTFA_FOPT(x).U)
/*@}*/

/*******************************************************************************
 * HW_FTFA_FCCOB3 - Flash Common Command Object Registers
 ******************************************************************************/

/*!
 * @brief HW_FTFA_FCCOB3 - Flash Common Command Object Registers (RW)
 *
 * Reset value: 0x00U
 *
 * The FCCOB register group provides 12 bytes for command codes and parameters.
 * The individual bytes within the set append a 0-B hex identifier to the FCCOB
 * register name: FCCOB0, FCCOB1, ..., FCCOBB.
 */
typedef union _hw_ftfa_fccob3
{
    uint8_t U;
    struct _hw_ftfa_fccob3_bitfields
    {
        uint8_t CCOBn : 8;             /*!< [7:0]  */
    } B;
} hw_ftfa_fccob3_t;

/*!
 * @name Constants and macros for entire FTFA_FCCOB3 register
 */
/*@{*/
#define HW_FTFA_FCCOB3_ADDR(x)   ((x) + 0x4U)

#define HW_FTFA_FCCOB3(x)        (*(__IO hw_ftfa_fccob3_t *) HW_FTFA_FCCOB3_ADDR(x))
#define HW_FTFA_FCCOB3_RD(x)     (HW_FTFA_FCCOB3(x).U)
#define HW_FTFA_FCCOB3_WR(x, v)  (HW_FTFA_FCCOB3(x).U = (v))
#define HW_FTFA_FCCOB3_SET(x, v) (HW_FTFA_FCCOB3_WR(x, HW_FTFA_FCCOB3_RD(x) |  (v)))
#define HW_FTFA_FCCOB3_CLR(x, v) (HW_FTFA_FCCOB3_WR(x, HW_FTFA_FCCOB3_RD(x) & ~(v)))
#define HW_FTFA_FCCOB3_TOG(x, v) (HW_FTFA_FCCOB3_WR(x, HW_FTFA_FCCOB3_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual FTFA_FCCOB3 bitfields
 */

/*!
 * @name Register FTFA_FCCOB3, field CCOBn[7:0] (RW)
 *
 * The FCCOB register provides a command code and relevant parameters to the
 * memory controller. The individual registers that compose the FCCOB data set can
 * be written in any order, but you must provide all needed values, which vary
 * from command to command. First, set up all required FCCOB fields and then
 * initiate the command's execution by writing a 1 to the FSTAT[CCIF] bit. This clears
 * the CCIF bit, which locks all FCCOB parameter fields and they cannot be changed
 * by the user until the command completes (CCIF returns to 1). No command
 * buffering or queueing is provided; the next command can be loaded only after the
 * current command completes. Some commands return information to the FCCOB
 * registers. Any values returned to FCCOB are available for reading after the
 * FSTAT[CCIF] flag returns to 1 by the memory controller. The following table shows a
 * generic flash command format. The first FCCOB register, FCCOB0, always contains
 * the command code. This 8-bit value defines the command to be executed. The
 * command code is followed by the parameters required for this specific flash
 * command, typically an address and/or data values. The command parameter table is
 * written in terms of FCCOB Number (which is equivalent to the byte number). This
 * number is a reference to the FCCOB register name and is not the register
 * address. FCCOB Number Typical Command Parameter Contents [7:0] 0 FCMD (a code that
 * defines the flash command) 1 Flash address [23:16] 2 Flash address [15:8] 3
 * Flash address [7:0] 4 Data Byte 0 5 Data Byte 1 6 Data Byte 2 7 Data Byte 3 8
 * Data Byte 4 9 Data Byte 5 A Data Byte 6 B Data Byte 7 FCCOB Endianness : The
 * FCCOB register group uses a big endian addressing convention. For all command
 * parameter fields larger than 1 byte, the most significant data resides in the
 * lowest FCCOB register number.
 */
/*@{*/
#define BP_FTFA_FCCOB3_CCOBn (0U)          /*!< Bit position for FTFA_FCCOB3_CCOBn. */
#define BM_FTFA_FCCOB3_CCOBn (0xFFU)       /*!< Bit mask for FTFA_FCCOB3_CCOBn. */
#define BS_FTFA_FCCOB3_CCOBn (8U)          /*!< Bit field size in bits for FTFA_FCCOB3_CCOBn. */

/*! @brief Read current value of the FTFA_FCCOB3_CCOBn field. */
#define BR_FTFA_FCCOB3_CCOBn(x) (HW_FTFA_FCCOB3(x).U)

/*! @brief Format value for bitfield FTFA_FCCOB3_CCOBn. */
#define BF_FTFA_FCCOB3_CCOBn(v) ((uint8_t)((uint8_t)(v) << BP_FTFA_FCCOB3_CCOBn) & BM_FTFA_FCCOB3_CCOBn)

/*! @brief Set the CCOBn field to a new value. */
#define BW_FTFA_FCCOB3_CCOBn(x, v) (HW_FTFA_FCCOB3_WR(x, v))
/*@}*/

/*******************************************************************************
 * HW_FTFA_FCCOB2 - Flash Common Command Object Registers
 ******************************************************************************/

/*!
 * @brief HW_FTFA_FCCOB2 - Flash Common Command Object Registers (RW)
 *
 * Reset value: 0x00U
 *
 * The FCCOB register group provides 12 bytes for command codes and parameters.
 * The individual bytes within the set append a 0-B hex identifier to the FCCOB
 * register name: FCCOB0, FCCOB1, ..., FCCOBB.
 */
typedef union _hw_ftfa_fccob2
{
    uint8_t U;
    struct _hw_ftfa_fccob2_bitfields
    {
        uint8_t CCOBn : 8;             /*!< [7:0]  */
    } B;
} hw_ftfa_fccob2_t;

/*!
 * @name Constants and macros for entire FTFA_FCCOB2 register
 */
/*@{*/
#define HW_FTFA_FCCOB2_ADDR(x)   ((x) + 0x5U)

#define HW_FTFA_FCCOB2(x)        (*(__IO hw_ftfa_fccob2_t *) HW_FTFA_FCCOB2_ADDR(x))
#define HW_FTFA_FCCOB2_RD(x)     (HW_FTFA_FCCOB2(x).U)
#define HW_FTFA_FCCOB2_WR(x, v)  (HW_FTFA_FCCOB2(x).U = (v))
#define HW_FTFA_FCCOB2_SET(x, v) (HW_FTFA_FCCOB2_WR(x, HW_FTFA_FCCOB2_RD(x) |  (v)))
#define HW_FTFA_FCCOB2_CLR(x, v) (HW_FTFA_FCCOB2_WR(x, HW_FTFA_FCCOB2_RD(x) & ~(v)))
#define HW_FTFA_FCCOB2_TOG(x, v) (HW_FTFA_FCCOB2_WR(x, HW_FTFA_FCCOB2_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual FTFA_FCCOB2 bitfields
 */

/*!
 * @name Register FTFA_FCCOB2, field CCOBn[7:0] (RW)
 *
 * The FCCOB register provides a command code and relevant parameters to the
 * memory controller. The individual registers that compose the FCCOB data set can
 * be written in any order, but you must provide all needed values, which vary
 * from command to command. First, set up all required FCCOB fields and then
 * initiate the command's execution by writing a 1 to the FSTAT[CCIF] bit. This clears
 * the CCIF bit, which locks all FCCOB parameter fields and they cannot be changed
 * by the user until the command completes (CCIF returns to 1). No command
 * buffering or queueing is provided; the next command can be loaded only after the
 * current command completes. Some commands return information to the FCCOB
 * registers. Any values returned to FCCOB are available for reading after the
 * FSTAT[CCIF] flag returns to 1 by the memory controller. The following table shows a
 * generic flash command format. The first FCCOB register, FCCOB0, always contains
 * the command code. This 8-bit value defines the command to be executed. The
 * command code is followed by the parameters required for this specific flash
 * command, typically an address and/or data values. The command parameter table is
 * written in terms of FCCOB Number (which is equivalent to the byte number). This
 * number is a reference to the FCCOB register name and is not the register
 * address. FCCOB Number Typical Command Parameter Contents [7:0] 0 FCMD (a code that
 * defines the flash command) 1 Flash address [23:16] 2 Flash address [15:8] 3
 * Flash address [7:0] 4 Data Byte 0 5 Data Byte 1 6 Data Byte 2 7 Data Byte 3 8
 * Data Byte 4 9 Data Byte 5 A Data Byte 6 B Data Byte 7 FCCOB Endianness : The
 * FCCOB register group uses a big endian addressing convention. For all command
 * parameter fields larger than 1 byte, the most significant data resides in the
 * lowest FCCOB register number.
 */
/*@{*/
#define BP_FTFA_FCCOB2_CCOBn (0U)          /*!< Bit position for FTFA_FCCOB2_CCOBn. */
#define BM_FTFA_FCCOB2_CCOBn (0xFFU)       /*!< Bit mask for FTFA_FCCOB2_CCOBn. */
#define BS_FTFA_FCCOB2_CCOBn (8U)          /*!< Bit field size in bits for FTFA_FCCOB2_CCOBn. */

/*! @brief Read current value of the FTFA_FCCOB2_CCOBn field. */
#define BR_FTFA_FCCOB2_CCOBn(x) (HW_FTFA_FCCOB2(x).U)

/*! @brief Format value for bitfield FTFA_FCCOB2_CCOBn. */
#define BF_FTFA_FCCOB2_CCOBn(v) ((uint8_t)((uint8_t)(v) << BP_FTFA_FCCOB2_CCOBn) & BM_FTFA_FCCOB2_CCOBn)

/*! @brief Set the CCOBn field to a new value. */
#define BW_FTFA_FCCOB2_CCOBn(x, v) (HW_FTFA_FCCOB2_WR(x, v))
/*@}*/

/*******************************************************************************
 * HW_FTFA_FCCOB1 - Flash Common Command Object Registers
 ******************************************************************************/

/*!
 * @brief HW_FTFA_FCCOB1 - Flash Common Command Object Registers (RW)
 *
 * Reset value: 0x00U
 *
 * The FCCOB register group provides 12 bytes for command codes and parameters.
 * The individual bytes within the set append a 0-B hex identifier to the FCCOB
 * register name: FCCOB0, FCCOB1, ..., FCCOBB.
 */
typedef union _hw_ftfa_fccob1
{
    uint8_t U;
    struct _hw_ftfa_fccob1_bitfields
    {
        uint8_t CCOBn : 8;             /*!< [7:0]  */
    } B;
} hw_ftfa_fccob1_t;

/*!
 * @name Constants and macros for entire FTFA_FCCOB1 register
 */
/*@{*/
#define HW_FTFA_FCCOB1_ADDR(x)   ((x) + 0x6U)

#define HW_FTFA_FCCOB1(x)        (*(__IO hw_ftfa_fccob1_t *) HW_FTFA_FCCOB1_ADDR(x))
#define HW_FTFA_FCCOB1_RD(x)     (HW_FTFA_FCCOB1(x).U)
#define HW_FTFA_FCCOB1_WR(x, v)  (HW_FTFA_FCCOB1(x).U = (v))
#define HW_FTFA_FCCOB1_SET(x, v) (HW_FTFA_FCCOB1_WR(x, HW_FTFA_FCCOB1_RD(x) |  (v)))
#define HW_FTFA_FCCOB1_CLR(x, v) (HW_FTFA_FCCOB1_WR(x, HW_FTFA_FCCOB1_RD(x) & ~(v)))
#define HW_FTFA_FCCOB1_TOG(x, v) (HW_FTFA_FCCOB1_WR(x, HW_FTFA_FCCOB1_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual FTFA_FCCOB1 bitfields
 */

/*!
 * @name Register FTFA_FCCOB1, field CCOBn[7:0] (RW)
 *
 * The FCCOB register provides a command code and relevant parameters to the
 * memory controller. The individual registers that compose the FCCOB data set can
 * be written in any order, but you must provide all needed values, which vary
 * from command to command. First, set up all required FCCOB fields and then
 * initiate the command's execution by writing a 1 to the FSTAT[CCIF] bit. This clears
 * the CCIF bit, which locks all FCCOB parameter fields and they cannot be changed
 * by the user until the command completes (CCIF returns to 1). No command
 * buffering or queueing is provided; the next command can be loaded only after the
 * current command completes. Some commands return information to the FCCOB
 * registers. Any values returned to FCCOB are available for reading after the
 * FSTAT[CCIF] flag returns to 1 by the memory controller. The following table shows a
 * generic flash command format. The first FCCOB register, FCCOB0, always contains
 * the command code. This 8-bit value defines the command to be executed. The
 * command code is followed by the parameters required for this specific flash
 * command, typically an address and/or data values. The command parameter table is
 * written in terms of FCCOB Number (which is equivalent to the byte number). This
 * number is a reference to the FCCOB register name and is not the register
 * address. FCCOB Number Typical Command Parameter Contents [7:0] 0 FCMD (a code that
 * defines the flash command) 1 Flash address [23:16] 2 Flash address [15:8] 3
 * Flash address [7:0] 4 Data Byte 0 5 Data Byte 1 6 Data Byte 2 7 Data Byte 3 8
 * Data Byte 4 9 Data Byte 5 A Data Byte 6 B Data Byte 7 FCCOB Endianness : The
 * FCCOB register group uses a big endian addressing convention. For all command
 * parameter fields larger than 1 byte, the most significant data resides in the
 * lowest FCCOB register number.
 */
/*@{*/
#define BP_FTFA_FCCOB1_CCOBn (0U)          /*!< Bit position for FTFA_FCCOB1_CCOBn. */
#define BM_FTFA_FCCOB1_CCOBn (0xFFU)       /*!< Bit mask for FTFA_FCCOB1_CCOBn. */
#define BS_FTFA_FCCOB1_CCOBn (8U)          /*!< Bit field size in bits for FTFA_FCCOB1_CCOBn. */

/*! @brief Read current value of the FTFA_FCCOB1_CCOBn field. */
#define BR_FTFA_FCCOB1_CCOBn(x) (HW_FTFA_FCCOB1(x).U)

/*! @brief Format value for bitfield FTFA_FCCOB1_CCOBn. */
#define BF_FTFA_FCCOB1_CCOBn(v) ((uint8_t)((uint8_t)(v) << BP_FTFA_FCCOB1_CCOBn) & BM_FTFA_FCCOB1_CCOBn)

/*! @brief Set the CCOBn field to a new value. */
#define BW_FTFA_FCCOB1_CCOBn(x, v) (HW_FTFA_FCCOB1_WR(x, v))
/*@}*/

/*******************************************************************************
 * HW_FTFA_FCCOB0 - Flash Common Command Object Registers
 ******************************************************************************/

/*!
 * @brief HW_FTFA_FCCOB0 - Flash Common Command Object Registers (RW)
 *
 * Reset value: 0x00U
 *
 * The FCCOB register group provides 12 bytes for command codes and parameters.
 * The individual bytes within the set append a 0-B hex identifier to the FCCOB
 * register name: FCCOB0, FCCOB1, ..., FCCOBB.
 */
typedef union _hw_ftfa_fccob0
{
    uint8_t U;
    struct _hw_ftfa_fccob0_bitfields
    {
        uint8_t CCOBn : 8;             /*!< [7:0]  */
    } B;
} hw_ftfa_fccob0_t;

/*!
 * @name Constants and macros for entire FTFA_FCCOB0 register
 */
/*@{*/
#define HW_FTFA_FCCOB0_ADDR(x)   ((x) + 0x7U)

#define HW_FTFA_FCCOB0(x)        (*(__IO hw_ftfa_fccob0_t *) HW_FTFA_FCCOB0_ADDR(x))
#define HW_FTFA_FCCOB0_RD(x)     (HW_FTFA_FCCOB0(x).U)
#define HW_FTFA_FCCOB0_WR(x, v)  (HW_FTFA_FCCOB0(x).U = (v))
#define HW_FTFA_FCCOB0_SET(x, v) (HW_FTFA_FCCOB0_WR(x, HW_FTFA_FCCOB0_RD(x) |  (v)))
#define HW_FTFA_FCCOB0_CLR(x, v) (HW_FTFA_FCCOB0_WR(x, HW_FTFA_FCCOB0_RD(x) & ~(v)))
#define HW_FTFA_FCCOB0_TOG(x, v) (HW_FTFA_FCCOB0_WR(x, HW_FTFA_FCCOB0_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual FTFA_FCCOB0 bitfields
 */

/*!
 * @name Register FTFA_FCCOB0, field CCOBn[7:0] (RW)
 *
 * The FCCOB register provides a command code and relevant parameters to the
 * memory controller. The individual registers that compose the FCCOB data set can
 * be written in any order, but you must provide all needed values, which vary
 * from command to command. First, set up all required FCCOB fields and then
 * initiate the command's execution by writing a 1 to the FSTAT[CCIF] bit. This clears
 * the CCIF bit, which locks all FCCOB parameter fields and they cannot be changed
 * by the user until the command completes (CCIF returns to 1). No command
 * buffering or queueing is provided; the next command can be loaded only after the
 * current command completes. Some commands return information to the FCCOB
 * registers. Any values returned to FCCOB are available for reading after the
 * FSTAT[CCIF] flag returns to 1 by the memory controller. The following table shows a
 * generic flash command format. The first FCCOB register, FCCOB0, always contains
 * the command code. This 8-bit value defines the command to be executed. The
 * command code is followed by the parameters required for this specific flash
 * command, typically an address and/or data values. The command parameter table is
 * written in terms of FCCOB Number (which is equivalent to the byte number). This
 * number is a reference to the FCCOB register name and is not the register
 * address. FCCOB Number Typical Command Parameter Contents [7:0] 0 FCMD (a code that
 * defines the flash command) 1 Flash address [23:16] 2 Flash address [15:8] 3
 * Flash address [7:0] 4 Data Byte 0 5 Data Byte 1 6 Data Byte 2 7 Data Byte 3 8
 * Data Byte 4 9 Data Byte 5 A Data Byte 6 B Data Byte 7 FCCOB Endianness : The
 * FCCOB register group uses a big endian addressing convention. For all command
 * parameter fields larger than 1 byte, the most significant data resides in the
 * lowest FCCOB register number.
 */
/*@{*/
#define BP_FTFA_FCCOB0_CCOBn (0U)          /*!< Bit position for FTFA_FCCOB0_CCOBn. */
#define BM_FTFA_FCCOB0_CCOBn (0xFFU)       /*!< Bit mask for FTFA_FCCOB0_CCOBn. */
#define BS_FTFA_FCCOB0_CCOBn (8U)          /*!< Bit field size in bits for FTFA_FCCOB0_CCOBn. */

/*! @brief Read current value of the FTFA_FCCOB0_CCOBn field. */
#define BR_FTFA_FCCOB0_CCOBn(x) (HW_FTFA_FCCOB0(x).U)

/*! @brief Format value for bitfield FTFA_FCCOB0_CCOBn. */
#define BF_FTFA_FCCOB0_CCOBn(v) ((uint8_t)((uint8_t)(v) << BP_FTFA_FCCOB0_CCOBn) & BM_FTFA_FCCOB0_CCOBn)

/*! @brief Set the CCOBn field to a new value. */
#define BW_FTFA_FCCOB0_CCOBn(x, v) (HW_FTFA_FCCOB0_WR(x, v))
/*@}*/

/*******************************************************************************
 * HW_FTFA_FCCOB7 - Flash Common Command Object Registers
 ******************************************************************************/

/*!
 * @brief HW_FTFA_FCCOB7 - Flash Common Command Object Registers (RW)
 *
 * Reset value: 0x00U
 *
 * The FCCOB register group provides 12 bytes for command codes and parameters.
 * The individual bytes within the set append a 0-B hex identifier to the FCCOB
 * register name: FCCOB0, FCCOB1, ..., FCCOBB.
 */
typedef union _hw_ftfa_fccob7
{
    uint8_t U;
    struct _hw_ftfa_fccob7_bitfields
    {
        uint8_t CCOBn : 8;             /*!< [7:0]  */
    } B;
} hw_ftfa_fccob7_t;

/*!
 * @name Constants and macros for entire FTFA_FCCOB7 register
 */
/*@{*/
#define HW_FTFA_FCCOB7_ADDR(x)   ((x) + 0x8U)

#define HW_FTFA_FCCOB7(x)        (*(__IO hw_ftfa_fccob7_t *) HW_FTFA_FCCOB7_ADDR(x))
#define HW_FTFA_FCCOB7_RD(x)     (HW_FTFA_FCCOB7(x).U)
#define HW_FTFA_FCCOB7_WR(x, v)  (HW_FTFA_FCCOB7(x).U = (v))
#define HW_FTFA_FCCOB7_SET(x, v) (HW_FTFA_FCCOB7_WR(x, HW_FTFA_FCCOB7_RD(x) |  (v)))
#define HW_FTFA_FCCOB7_CLR(x, v) (HW_FTFA_FCCOB7_WR(x, HW_FTFA_FCCOB7_RD(x) & ~(v)))
#define HW_FTFA_FCCOB7_TOG(x, v) (HW_FTFA_FCCOB7_WR(x, HW_FTFA_FCCOB7_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual FTFA_FCCOB7 bitfields
 */

/*!
 * @name Register FTFA_FCCOB7, field CCOBn[7:0] (RW)
 *
 * The FCCOB register provides a command code and relevant parameters to the
 * memory controller. The individual registers that compose the FCCOB data set can
 * be written in any order, but you must provide all needed values, which vary
 * from command to command. First, set up all required FCCOB fields and then
 * initiate the command's execution by writing a 1 to the FSTAT[CCIF] bit. This clears
 * the CCIF bit, which locks all FCCOB parameter fields and they cannot be changed
 * by the user until the command completes (CCIF returns to 1). No command
 * buffering or queueing is provided; the next command can be loaded only after the
 * current command completes. Some commands return information to the FCCOB
 * registers. Any values returned to FCCOB are available for reading after the
 * FSTAT[CCIF] flag returns to 1 by the memory controller. The following table shows a
 * generic flash command format. The first FCCOB register, FCCOB0, always contains
 * the command code. This 8-bit value defines the command to be executed. The
 * command code is followed by the parameters required for this specific flash
 * command, typically an address and/or data values. The command parameter table is
 * written in terms of FCCOB Number (which is equivalent to the byte number). This
 * number is a reference to the FCCOB register name and is not the register
 * address. FCCOB Number Typical Command Parameter Contents [7:0] 0 FCMD (a code that
 * defines the flash command) 1 Flash address [23:16] 2 Flash address [15:8] 3
 * Flash address [7:0] 4 Data Byte 0 5 Data Byte 1 6 Data Byte 2 7 Data Byte 3 8
 * Data Byte 4 9 Data Byte 5 A Data Byte 6 B Data Byte 7 FCCOB Endianness : The
 * FCCOB register group uses a big endian addressing convention. For all command
 * parameter fields larger than 1 byte, the most significant data resides in the
 * lowest FCCOB register number.
 */
/*@{*/
#define BP_FTFA_FCCOB7_CCOBn (0U)          /*!< Bit position for FTFA_FCCOB7_CCOBn. */
#define BM_FTFA_FCCOB7_CCOBn (0xFFU)       /*!< Bit mask for FTFA_FCCOB7_CCOBn. */
#define BS_FTFA_FCCOB7_CCOBn (8U)          /*!< Bit field size in bits for FTFA_FCCOB7_CCOBn. */

/*! @brief Read current value of the FTFA_FCCOB7_CCOBn field. */
#define BR_FTFA_FCCOB7_CCOBn(x) (HW_FTFA_FCCOB7(x).U)

/*! @brief Format value for bitfield FTFA_FCCOB7_CCOBn. */
#define BF_FTFA_FCCOB7_CCOBn(v) ((uint8_t)((uint8_t)(v) << BP_FTFA_FCCOB7_CCOBn) & BM_FTFA_FCCOB7_CCOBn)

/*! @brief Set the CCOBn field to a new value. */
#define BW_FTFA_FCCOB7_CCOBn(x, v) (HW_FTFA_FCCOB7_WR(x, v))
/*@}*/

/*******************************************************************************
 * HW_FTFA_FCCOB6 - Flash Common Command Object Registers
 ******************************************************************************/

/*!
 * @brief HW_FTFA_FCCOB6 - Flash Common Command Object Registers (RW)
 *
 * Reset value: 0x00U
 *
 * The FCCOB register group provides 12 bytes for command codes and parameters.
 * The individual bytes within the set append a 0-B hex identifier to the FCCOB
 * register name: FCCOB0, FCCOB1, ..., FCCOBB.
 */
typedef union _hw_ftfa_fccob6
{
    uint8_t U;
    struct _hw_ftfa_fccob6_bitfields
    {
        uint8_t CCOBn : 8;             /*!< [7:0]  */
    } B;
} hw_ftfa_fccob6_t;

/*!
 * @name Constants and macros for entire FTFA_FCCOB6 register
 */
/*@{*/
#define HW_FTFA_FCCOB6_ADDR(x)   ((x) + 0x9U)

#define HW_FTFA_FCCOB6(x)        (*(__IO hw_ftfa_fccob6_t *) HW_FTFA_FCCOB6_ADDR(x))
#define HW_FTFA_FCCOB6_RD(x)     (HW_FTFA_FCCOB6(x).U)
#define HW_FTFA_FCCOB6_WR(x, v)  (HW_FTFA_FCCOB6(x).U = (v))
#define HW_FTFA_FCCOB6_SET(x, v) (HW_FTFA_FCCOB6_WR(x, HW_FTFA_FCCOB6_RD(x) |  (v)))
#define HW_FTFA_FCCOB6_CLR(x, v) (HW_FTFA_FCCOB6_WR(x, HW_FTFA_FCCOB6_RD(x) & ~(v)))
#define HW_FTFA_FCCOB6_TOG(x, v) (HW_FTFA_FCCOB6_WR(x, HW_FTFA_FCCOB6_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual FTFA_FCCOB6 bitfields
 */

/*!
 * @name Register FTFA_FCCOB6, field CCOBn[7:0] (RW)
 *
 * The FCCOB register provides a command code and relevant parameters to the
 * memory controller. The individual registers that compose the FCCOB data set can
 * be written in any order, but you must provide all needed values, which vary
 * from command to command. First, set up all required FCCOB fields and then
 * initiate the command's execution by writing a 1 to the FSTAT[CCIF] bit. This clears
 * the CCIF bit, which locks all FCCOB parameter fields and they cannot be changed
 * by the user until the command completes (CCIF returns to 1). No command
 * buffering or queueing is provided; the next command can be loaded only after the
 * current command completes. Some commands return information to the FCCOB
 * registers. Any values returned to FCCOB are available for reading after the
 * FSTAT[CCIF] flag returns to 1 by the memory controller. The following table shows a
 * generic flash command format. The first FCCOB register, FCCOB0, always contains
 * the command code. This 8-bit value defines the command to be executed. The
 * command code is followed by the parameters required for this specific flash
 * command, typically an address and/or data values. The command parameter table is
 * written in terms of FCCOB Number (which is equivalent to the byte number). This
 * number is a reference to the FCCOB register name and is not the register
 * address. FCCOB Number Typical Command Parameter Contents [7:0] 0 FCMD (a code that
 * defines the flash command) 1 Flash address [23:16] 2 Flash address [15:8] 3
 * Flash address [7:0] 4 Data Byte 0 5 Data Byte 1 6 Data Byte 2 7 Data Byte 3 8
 * Data Byte 4 9 Data Byte 5 A Data Byte 6 B Data Byte 7 FCCOB Endianness : The
 * FCCOB register group uses a big endian addressing convention. For all command
 * parameter fields larger than 1 byte, the most significant data resides in the
 * lowest FCCOB register number.
 */
/*@{*/
#define BP_FTFA_FCCOB6_CCOBn (0U)          /*!< Bit position for FTFA_FCCOB6_CCOBn. */
#define BM_FTFA_FCCOB6_CCOBn (0xFFU)       /*!< Bit mask for FTFA_FCCOB6_CCOBn. */
#define BS_FTFA_FCCOB6_CCOBn (8U)          /*!< Bit field size in bits for FTFA_FCCOB6_CCOBn. */

/*! @brief Read current value of the FTFA_FCCOB6_CCOBn field. */
#define BR_FTFA_FCCOB6_CCOBn(x) (HW_FTFA_FCCOB6(x).U)

/*! @brief Format value for bitfield FTFA_FCCOB6_CCOBn. */
#define BF_FTFA_FCCOB6_CCOBn(v) ((uint8_t)((uint8_t)(v) << BP_FTFA_FCCOB6_CCOBn) & BM_FTFA_FCCOB6_CCOBn)

/*! @brief Set the CCOBn field to a new value. */
#define BW_FTFA_FCCOB6_CCOBn(x, v) (HW_FTFA_FCCOB6_WR(x, v))
/*@}*/

/*******************************************************************************
 * HW_FTFA_FCCOB5 - Flash Common Command Object Registers
 ******************************************************************************/

/*!
 * @brief HW_FTFA_FCCOB5 - Flash Common Command Object Registers (RW)
 *
 * Reset value: 0x00U
 *
 * The FCCOB register group provides 12 bytes for command codes and parameters.
 * The individual bytes within the set append a 0-B hex identifier to the FCCOB
 * register name: FCCOB0, FCCOB1, ..., FCCOBB.
 */
typedef union _hw_ftfa_fccob5
{
    uint8_t U;
    struct _hw_ftfa_fccob5_bitfields
    {
        uint8_t CCOBn : 8;             /*!< [7:0]  */
    } B;
} hw_ftfa_fccob5_t;

/*!
 * @name Constants and macros for entire FTFA_FCCOB5 register
 */
/*@{*/
#define HW_FTFA_FCCOB5_ADDR(x)   ((x) + 0xAU)

#define HW_FTFA_FCCOB5(x)        (*(__IO hw_ftfa_fccob5_t *) HW_FTFA_FCCOB5_ADDR(x))
#define HW_FTFA_FCCOB5_RD(x)     (HW_FTFA_FCCOB5(x).U)
#define HW_FTFA_FCCOB5_WR(x, v)  (HW_FTFA_FCCOB5(x).U = (v))
#define HW_FTFA_FCCOB5_SET(x, v) (HW_FTFA_FCCOB5_WR(x, HW_FTFA_FCCOB5_RD(x) |  (v)))
#define HW_FTFA_FCCOB5_CLR(x, v) (HW_FTFA_FCCOB5_WR(x, HW_FTFA_FCCOB5_RD(x) & ~(v)))
#define HW_FTFA_FCCOB5_TOG(x, v) (HW_FTFA_FCCOB5_WR(x, HW_FTFA_FCCOB5_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual FTFA_FCCOB5 bitfields
 */

/*!
 * @name Register FTFA_FCCOB5, field CCOBn[7:0] (RW)
 *
 * The FCCOB register provides a command code and relevant parameters to the
 * memory controller. The individual registers that compose the FCCOB data set can
 * be written in any order, but you must provide all needed values, which vary
 * from command to command. First, set up all required FCCOB fields and then
 * initiate the command's execution by writing a 1 to the FSTAT[CCIF] bit. This clears
 * the CCIF bit, which locks all FCCOB parameter fields and they cannot be changed
 * by the user until the command completes (CCIF returns to 1). No command
 * buffering or queueing is provided; the next command can be loaded only after the
 * current command completes. Some commands return information to the FCCOB
 * registers. Any values returned to FCCOB are available for reading after the
 * FSTAT[CCIF] flag returns to 1 by the memory controller. The following table shows a
 * generic flash command format. The first FCCOB register, FCCOB0, always contains
 * the command code. This 8-bit value defines the command to be executed. The
 * command code is followed by the parameters required for this specific flash
 * command, typically an address and/or data values. The command parameter table is
 * written in terms of FCCOB Number (which is equivalent to the byte number). This
 * number is a reference to the FCCOB register name and is not the register
 * address. FCCOB Number Typical Command Parameter Contents [7:0] 0 FCMD (a code that
 * defines the flash command) 1 Flash address [23:16] 2 Flash address [15:8] 3
 * Flash address [7:0] 4 Data Byte 0 5 Data Byte 1 6 Data Byte 2 7 Data Byte 3 8
 * Data Byte 4 9 Data Byte 5 A Data Byte 6 B Data Byte 7 FCCOB Endianness : The
 * FCCOB register group uses a big endian addressing convention. For all command
 * parameter fields larger than 1 byte, the most significant data resides in the
 * lowest FCCOB register number.
 */
/*@{*/
#define BP_FTFA_FCCOB5_CCOBn (0U)          /*!< Bit position for FTFA_FCCOB5_CCOBn. */
#define BM_FTFA_FCCOB5_CCOBn (0xFFU)       /*!< Bit mask for FTFA_FCCOB5_CCOBn. */
#define BS_FTFA_FCCOB5_CCOBn (8U)          /*!< Bit field size in bits for FTFA_FCCOB5_CCOBn. */

/*! @brief Read current value of the FTFA_FCCOB5_CCOBn field. */
#define BR_FTFA_FCCOB5_CCOBn(x) (HW_FTFA_FCCOB5(x).U)

/*! @brief Format value for bitfield FTFA_FCCOB5_CCOBn. */
#define BF_FTFA_FCCOB5_CCOBn(v) ((uint8_t)((uint8_t)(v) << BP_FTFA_FCCOB5_CCOBn) & BM_FTFA_FCCOB5_CCOBn)

/*! @brief Set the CCOBn field to a new value. */
#define BW_FTFA_FCCOB5_CCOBn(x, v) (HW_FTFA_FCCOB5_WR(x, v))
/*@}*/

/*******************************************************************************
 * HW_FTFA_FCCOB4 - Flash Common Command Object Registers
 ******************************************************************************/

/*!
 * @brief HW_FTFA_FCCOB4 - Flash Common Command Object Registers (RW)
 *
 * Reset value: 0x00U
 *
 * The FCCOB register group provides 12 bytes for command codes and parameters.
 * The individual bytes within the set append a 0-B hex identifier to the FCCOB
 * register name: FCCOB0, FCCOB1, ..., FCCOBB.
 */
typedef union _hw_ftfa_fccob4
{
    uint8_t U;
    struct _hw_ftfa_fccob4_bitfields
    {
        uint8_t CCOBn : 8;             /*!< [7:0]  */
    } B;
} hw_ftfa_fccob4_t;

/*!
 * @name Constants and macros for entire FTFA_FCCOB4 register
 */
/*@{*/
#define HW_FTFA_FCCOB4_ADDR(x)   ((x) + 0xBU)

#define HW_FTFA_FCCOB4(x)        (*(__IO hw_ftfa_fccob4_t *) HW_FTFA_FCCOB4_ADDR(x))
#define HW_FTFA_FCCOB4_RD(x)     (HW_FTFA_FCCOB4(x).U)
#define HW_FTFA_FCCOB4_WR(x, v)  (HW_FTFA_FCCOB4(x).U = (v))
#define HW_FTFA_FCCOB4_SET(x, v) (HW_FTFA_FCCOB4_WR(x, HW_FTFA_FCCOB4_RD(x) |  (v)))
#define HW_FTFA_FCCOB4_CLR(x, v) (HW_FTFA_FCCOB4_WR(x, HW_FTFA_FCCOB4_RD(x) & ~(v)))
#define HW_FTFA_FCCOB4_TOG(x, v) (HW_FTFA_FCCOB4_WR(x, HW_FTFA_FCCOB4_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual FTFA_FCCOB4 bitfields
 */

/*!
 * @name Register FTFA_FCCOB4, field CCOBn[7:0] (RW)
 *
 * The FCCOB register provides a command code and relevant parameters to the
 * memory controller. The individual registers that compose the FCCOB data set can
 * be written in any order, but you must provide all needed values, which vary
 * from command to command. First, set up all required FCCOB fields and then
 * initiate the command's execution by writing a 1 to the FSTAT[CCIF] bit. This clears
 * the CCIF bit, which locks all FCCOB parameter fields and they cannot be changed
 * by the user until the command completes (CCIF returns to 1). No command
 * buffering or queueing is provided; the next command can be loaded only after the
 * current command completes. Some commands return information to the FCCOB
 * registers. Any values returned to FCCOB are available for reading after the
 * FSTAT[CCIF] flag returns to 1 by the memory controller. The following table shows a
 * generic flash command format. The first FCCOB register, FCCOB0, always contains
 * the command code. This 8-bit value defines the command to be executed. The
 * command code is followed by the parameters required for this specific flash
 * command, typically an address and/or data values. The command parameter table is
 * written in terms of FCCOB Number (which is equivalent to the byte number). This
 * number is a reference to the FCCOB register name and is not the register
 * address. FCCOB Number Typical Command Parameter Contents [7:0] 0 FCMD (a code that
 * defines the flash command) 1 Flash address [23:16] 2 Flash address [15:8] 3
 * Flash address [7:0] 4 Data Byte 0 5 Data Byte 1 6 Data Byte 2 7 Data Byte 3 8
 * Data Byte 4 9 Data Byte 5 A Data Byte 6 B Data Byte 7 FCCOB Endianness : The
 * FCCOB register group uses a big endian addressing convention. For all command
 * parameter fields larger than 1 byte, the most significant data resides in the
 * lowest FCCOB register number.
 */
/*@{*/
#define BP_FTFA_FCCOB4_CCOBn (0U)          /*!< Bit position for FTFA_FCCOB4_CCOBn. */
#define BM_FTFA_FCCOB4_CCOBn (0xFFU)       /*!< Bit mask for FTFA_FCCOB4_CCOBn. */
#define BS_FTFA_FCCOB4_CCOBn (8U)          /*!< Bit field size in bits for FTFA_FCCOB4_CCOBn. */

/*! @brief Read current value of the FTFA_FCCOB4_CCOBn field. */
#define BR_FTFA_FCCOB4_CCOBn(x) (HW_FTFA_FCCOB4(x).U)

/*! @brief Format value for bitfield FTFA_FCCOB4_CCOBn. */
#define BF_FTFA_FCCOB4_CCOBn(v) ((uint8_t)((uint8_t)(v) << BP_FTFA_FCCOB4_CCOBn) & BM_FTFA_FCCOB4_CCOBn)

/*! @brief Set the CCOBn field to a new value. */
#define BW_FTFA_FCCOB4_CCOBn(x, v) (HW_FTFA_FCCOB4_WR(x, v))
/*@}*/

/*******************************************************************************
 * HW_FTFA_FCCOBB - Flash Common Command Object Registers
 ******************************************************************************/

/*!
 * @brief HW_FTFA_FCCOBB - Flash Common Command Object Registers (RW)
 *
 * Reset value: 0x00U
 *
 * The FCCOB register group provides 12 bytes for command codes and parameters.
 * The individual bytes within the set append a 0-B hex identifier to the FCCOB
 * register name: FCCOB0, FCCOB1, ..., FCCOBB.
 */
typedef union _hw_ftfa_fccobb
{
    uint8_t U;
    struct _hw_ftfa_fccobb_bitfields
    {
        uint8_t CCOBn : 8;             /*!< [7:0]  */
    } B;
} hw_ftfa_fccobb_t;

/*!
 * @name Constants and macros for entire FTFA_FCCOBB register
 */
/*@{*/
#define HW_FTFA_FCCOBB_ADDR(x)   ((x) + 0xCU)

#define HW_FTFA_FCCOBB(x)        (*(__IO hw_ftfa_fccobb_t *) HW_FTFA_FCCOBB_ADDR(x))
#define HW_FTFA_FCCOBB_RD(x)     (HW_FTFA_FCCOBB(x).U)
#define HW_FTFA_FCCOBB_WR(x, v)  (HW_FTFA_FCCOBB(x).U = (v))
#define HW_FTFA_FCCOBB_SET(x, v) (HW_FTFA_FCCOBB_WR(x, HW_FTFA_FCCOBB_RD(x) |  (v)))
#define HW_FTFA_FCCOBB_CLR(x, v) (HW_FTFA_FCCOBB_WR(x, HW_FTFA_FCCOBB_RD(x) & ~(v)))
#define HW_FTFA_FCCOBB_TOG(x, v) (HW_FTFA_FCCOBB_WR(x, HW_FTFA_FCCOBB_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual FTFA_FCCOBB bitfields
 */

/*!
 * @name Register FTFA_FCCOBB, field CCOBn[7:0] (RW)
 *
 * The FCCOB register provides a command code and relevant parameters to the
 * memory controller. The individual registers that compose the FCCOB data set can
 * be written in any order, but you must provide all needed values, which vary
 * from command to command. First, set up all required FCCOB fields and then
 * initiate the command's execution by writing a 1 to the FSTAT[CCIF] bit. This clears
 * the CCIF bit, which locks all FCCOB parameter fields and they cannot be changed
 * by the user until the command completes (CCIF returns to 1). No command
 * buffering or queueing is provided; the next command can be loaded only after the
 * current command completes. Some commands return information to the FCCOB
 * registers. Any values returned to FCCOB are available for reading after the
 * FSTAT[CCIF] flag returns to 1 by the memory controller. The following table shows a
 * generic flash command format. The first FCCOB register, FCCOB0, always contains
 * the command code. This 8-bit value defines the command to be executed. The
 * command code is followed by the parameters required for this specific flash
 * command, typically an address and/or data values. The command parameter table is
 * written in terms of FCCOB Number (which is equivalent to the byte number). This
 * number is a reference to the FCCOB register name and is not the register
 * address. FCCOB Number Typical Command Parameter Contents [7:0] 0 FCMD (a code that
 * defines the flash command) 1 Flash address [23:16] 2 Flash address [15:8] 3
 * Flash address [7:0] 4 Data Byte 0 5 Data Byte 1 6 Data Byte 2 7 Data Byte 3 8
 * Data Byte 4 9 Data Byte 5 A Data Byte 6 B Data Byte 7 FCCOB Endianness : The
 * FCCOB register group uses a big endian addressing convention. For all command
 * parameter fields larger than 1 byte, the most significant data resides in the
 * lowest FCCOB register number.
 */
/*@{*/
#define BP_FTFA_FCCOBB_CCOBn (0U)          /*!< Bit position for FTFA_FCCOBB_CCOBn. */
#define BM_FTFA_FCCOBB_CCOBn (0xFFU)       /*!< Bit mask for FTFA_FCCOBB_CCOBn. */
#define BS_FTFA_FCCOBB_CCOBn (8U)          /*!< Bit field size in bits for FTFA_FCCOBB_CCOBn. */

/*! @brief Read current value of the FTFA_FCCOBB_CCOBn field. */
#define BR_FTFA_FCCOBB_CCOBn(x) (HW_FTFA_FCCOBB(x).U)

/*! @brief Format value for bitfield FTFA_FCCOBB_CCOBn. */
#define BF_FTFA_FCCOBB_CCOBn(v) ((uint8_t)((uint8_t)(v) << BP_FTFA_FCCOBB_CCOBn) & BM_FTFA_FCCOBB_CCOBn)

/*! @brief Set the CCOBn field to a new value. */
#define BW_FTFA_FCCOBB_CCOBn(x, v) (HW_FTFA_FCCOBB_WR(x, v))
/*@}*/

/*******************************************************************************
 * HW_FTFA_FCCOBA - Flash Common Command Object Registers
 ******************************************************************************/

/*!
 * @brief HW_FTFA_FCCOBA - Flash Common Command Object Registers (RW)
 *
 * Reset value: 0x00U
 *
 * The FCCOB register group provides 12 bytes for command codes and parameters.
 * The individual bytes within the set append a 0-B hex identifier to the FCCOB
 * register name: FCCOB0, FCCOB1, ..., FCCOBB.
 */
typedef union _hw_ftfa_fccoba
{
    uint8_t U;
    struct _hw_ftfa_fccoba_bitfields
    {
        uint8_t CCOBn : 8;             /*!< [7:0]  */
    } B;
} hw_ftfa_fccoba_t;

/*!
 * @name Constants and macros for entire FTFA_FCCOBA register
 */
/*@{*/
#define HW_FTFA_FCCOBA_ADDR(x)   ((x) + 0xDU)

#define HW_FTFA_FCCOBA(x)        (*(__IO hw_ftfa_fccoba_t *) HW_FTFA_FCCOBA_ADDR(x))
#define HW_FTFA_FCCOBA_RD(x)     (HW_FTFA_FCCOBA(x).U)
#define HW_FTFA_FCCOBA_WR(x, v)  (HW_FTFA_FCCOBA(x).U = (v))
#define HW_FTFA_FCCOBA_SET(x, v) (HW_FTFA_FCCOBA_WR(x, HW_FTFA_FCCOBA_RD(x) |  (v)))
#define HW_FTFA_FCCOBA_CLR(x, v) (HW_FTFA_FCCOBA_WR(x, HW_FTFA_FCCOBA_RD(x) & ~(v)))
#define HW_FTFA_FCCOBA_TOG(x, v) (HW_FTFA_FCCOBA_WR(x, HW_FTFA_FCCOBA_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual FTFA_FCCOBA bitfields
 */

/*!
 * @name Register FTFA_FCCOBA, field CCOBn[7:0] (RW)
 *
 * The FCCOB register provides a command code and relevant parameters to the
 * memory controller. The individual registers that compose the FCCOB data set can
 * be written in any order, but you must provide all needed values, which vary
 * from command to command. First, set up all required FCCOB fields and then
 * initiate the command's execution by writing a 1 to the FSTAT[CCIF] bit. This clears
 * the CCIF bit, which locks all FCCOB parameter fields and they cannot be changed
 * by the user until the command completes (CCIF returns to 1). No command
 * buffering or queueing is provided; the next command can be loaded only after the
 * current command completes. Some commands return information to the FCCOB
 * registers. Any values returned to FCCOB are available for reading after the
 * FSTAT[CCIF] flag returns to 1 by the memory controller. The following table shows a
 * generic flash command format. The first FCCOB register, FCCOB0, always contains
 * the command code. This 8-bit value defines the command to be executed. The
 * command code is followed by the parameters required for this specific flash
 * command, typically an address and/or data values. The command parameter table is
 * written in terms of FCCOB Number (which is equivalent to the byte number). This
 * number is a reference to the FCCOB register name and is not the register
 * address. FCCOB Number Typical Command Parameter Contents [7:0] 0 FCMD (a code that
 * defines the flash command) 1 Flash address [23:16] 2 Flash address [15:8] 3
 * Flash address [7:0] 4 Data Byte 0 5 Data Byte 1 6 Data Byte 2 7 Data Byte 3 8
 * Data Byte 4 9 Data Byte 5 A Data Byte 6 B Data Byte 7 FCCOB Endianness : The
 * FCCOB register group uses a big endian addressing convention. For all command
 * parameter fields larger than 1 byte, the most significant data resides in the
 * lowest FCCOB register number.
 */
/*@{*/
#define BP_FTFA_FCCOBA_CCOBn (0U)          /*!< Bit position for FTFA_FCCOBA_CCOBn. */
#define BM_FTFA_FCCOBA_CCOBn (0xFFU)       /*!< Bit mask for FTFA_FCCOBA_CCOBn. */
#define BS_FTFA_FCCOBA_CCOBn (8U)          /*!< Bit field size in bits for FTFA_FCCOBA_CCOBn. */

/*! @brief Read current value of the FTFA_FCCOBA_CCOBn field. */
#define BR_FTFA_FCCOBA_CCOBn(x) (HW_FTFA_FCCOBA(x).U)

/*! @brief Format value for bitfield FTFA_FCCOBA_CCOBn. */
#define BF_FTFA_FCCOBA_CCOBn(v) ((uint8_t)((uint8_t)(v) << BP_FTFA_FCCOBA_CCOBn) & BM_FTFA_FCCOBA_CCOBn)

/*! @brief Set the CCOBn field to a new value. */
#define BW_FTFA_FCCOBA_CCOBn(x, v) (HW_FTFA_FCCOBA_WR(x, v))
/*@}*/

/*******************************************************************************
 * HW_FTFA_FCCOB9 - Flash Common Command Object Registers
 ******************************************************************************/

/*!
 * @brief HW_FTFA_FCCOB9 - Flash Common Command Object Registers (RW)
 *
 * Reset value: 0x00U
 *
 * The FCCOB register group provides 12 bytes for command codes and parameters.
 * The individual bytes within the set append a 0-B hex identifier to the FCCOB
 * register name: FCCOB0, FCCOB1, ..., FCCOBB.
 */
typedef union _hw_ftfa_fccob9
{
    uint8_t U;
    struct _hw_ftfa_fccob9_bitfields
    {
        uint8_t CCOBn : 8;             /*!< [7:0]  */
    } B;
} hw_ftfa_fccob9_t;

/*!
 * @name Constants and macros for entire FTFA_FCCOB9 register
 */
/*@{*/
#define HW_FTFA_FCCOB9_ADDR(x)   ((x) + 0xEU)

#define HW_FTFA_FCCOB9(x)        (*(__IO hw_ftfa_fccob9_t *) HW_FTFA_FCCOB9_ADDR(x))
#define HW_FTFA_FCCOB9_RD(x)     (HW_FTFA_FCCOB9(x).U)
#define HW_FTFA_FCCOB9_WR(x, v)  (HW_FTFA_FCCOB9(x).U = (v))
#define HW_FTFA_FCCOB9_SET(x, v) (HW_FTFA_FCCOB9_WR(x, HW_FTFA_FCCOB9_RD(x) |  (v)))
#define HW_FTFA_FCCOB9_CLR(x, v) (HW_FTFA_FCCOB9_WR(x, HW_FTFA_FCCOB9_RD(x) & ~(v)))
#define HW_FTFA_FCCOB9_TOG(x, v) (HW_FTFA_FCCOB9_WR(x, HW_FTFA_FCCOB9_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual FTFA_FCCOB9 bitfields
 */

/*!
 * @name Register FTFA_FCCOB9, field CCOBn[7:0] (RW)
 *
 * The FCCOB register provides a command code and relevant parameters to the
 * memory controller. The individual registers that compose the FCCOB data set can
 * be written in any order, but you must provide all needed values, which vary
 * from command to command. First, set up all required FCCOB fields and then
 * initiate the command's execution by writing a 1 to the FSTAT[CCIF] bit. This clears
 * the CCIF bit, which locks all FCCOB parameter fields and they cannot be changed
 * by the user until the command completes (CCIF returns to 1). No command
 * buffering or queueing is provided; the next command can be loaded only after the
 * current command completes. Some commands return information to the FCCOB
 * registers. Any values returned to FCCOB are available for reading after the
 * FSTAT[CCIF] flag returns to 1 by the memory controller. The following table shows a
 * generic flash command format. The first FCCOB register, FCCOB0, always contains
 * the command code. This 8-bit value defines the command to be executed. The
 * command code is followed by the parameters required for this specific flash
 * command, typically an address and/or data values. The command parameter table is
 * written in terms of FCCOB Number (which is equivalent to the byte number). This
 * number is a reference to the FCCOB register name and is not the register
 * address. FCCOB Number Typical Command Parameter Contents [7:0] 0 FCMD (a code that
 * defines the flash command) 1 Flash address [23:16] 2 Flash address [15:8] 3
 * Flash address [7:0] 4 Data Byte 0 5 Data Byte 1 6 Data Byte 2 7 Data Byte 3 8
 * Data Byte 4 9 Data Byte 5 A Data Byte 6 B Data Byte 7 FCCOB Endianness : The
 * FCCOB register group uses a big endian addressing convention. For all command
 * parameter fields larger than 1 byte, the most significant data resides in the
 * lowest FCCOB register number.
 */
/*@{*/
#define BP_FTFA_FCCOB9_CCOBn (0U)          /*!< Bit position for FTFA_FCCOB9_CCOBn. */
#define BM_FTFA_FCCOB9_CCOBn (0xFFU)       /*!< Bit mask for FTFA_FCCOB9_CCOBn. */
#define BS_FTFA_FCCOB9_CCOBn (8U)          /*!< Bit field size in bits for FTFA_FCCOB9_CCOBn. */

/*! @brief Read current value of the FTFA_FCCOB9_CCOBn field. */
#define BR_FTFA_FCCOB9_CCOBn(x) (HW_FTFA_FCCOB9(x).U)

/*! @brief Format value for bitfield FTFA_FCCOB9_CCOBn. */
#define BF_FTFA_FCCOB9_CCOBn(v) ((uint8_t)((uint8_t)(v) << BP_FTFA_FCCOB9_CCOBn) & BM_FTFA_FCCOB9_CCOBn)

/*! @brief Set the CCOBn field to a new value. */
#define BW_FTFA_FCCOB9_CCOBn(x, v) (HW_FTFA_FCCOB9_WR(x, v))
/*@}*/

/*******************************************************************************
 * HW_FTFA_FCCOB8 - Flash Common Command Object Registers
 ******************************************************************************/

/*!
 * @brief HW_FTFA_FCCOB8 - Flash Common Command Object Registers (RW)
 *
 * Reset value: 0x00U
 *
 * The FCCOB register group provides 12 bytes for command codes and parameters.
 * The individual bytes within the set append a 0-B hex identifier to the FCCOB
 * register name: FCCOB0, FCCOB1, ..., FCCOBB.
 */
typedef union _hw_ftfa_fccob8
{
    uint8_t U;
    struct _hw_ftfa_fccob8_bitfields
    {
        uint8_t CCOBn : 8;             /*!< [7:0]  */
    } B;
} hw_ftfa_fccob8_t;

/*!
 * @name Constants and macros for entire FTFA_FCCOB8 register
 */
/*@{*/
#define HW_FTFA_FCCOB8_ADDR(x)   ((x) + 0xFU)

#define HW_FTFA_FCCOB8(x)        (*(__IO hw_ftfa_fccob8_t *) HW_FTFA_FCCOB8_ADDR(x))
#define HW_FTFA_FCCOB8_RD(x)     (HW_FTFA_FCCOB8(x).U)
#define HW_FTFA_FCCOB8_WR(x, v)  (HW_FTFA_FCCOB8(x).U = (v))
#define HW_FTFA_FCCOB8_SET(x, v) (HW_FTFA_FCCOB8_WR(x, HW_FTFA_FCCOB8_RD(x) |  (v)))
#define HW_FTFA_FCCOB8_CLR(x, v) (HW_FTFA_FCCOB8_WR(x, HW_FTFA_FCCOB8_RD(x) & ~(v)))
#define HW_FTFA_FCCOB8_TOG(x, v) (HW_FTFA_FCCOB8_WR(x, HW_FTFA_FCCOB8_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual FTFA_FCCOB8 bitfields
 */

/*!
 * @name Register FTFA_FCCOB8, field CCOBn[7:0] (RW)
 *
 * The FCCOB register provides a command code and relevant parameters to the
 * memory controller. The individual registers that compose the FCCOB data set can
 * be written in any order, but you must provide all needed values, which vary
 * from command to command. First, set up all required FCCOB fields and then
 * initiate the command's execution by writing a 1 to the FSTAT[CCIF] bit. This clears
 * the CCIF bit, which locks all FCCOB parameter fields and they cannot be changed
 * by the user until the command completes (CCIF returns to 1). No command
 * buffering or queueing is provided; the next command can be loaded only after the
 * current command completes. Some commands return information to the FCCOB
 * registers. Any values returned to FCCOB are available for reading after the
 * FSTAT[CCIF] flag returns to 1 by the memory controller. The following table shows a
 * generic flash command format. The first FCCOB register, FCCOB0, always contains
 * the command code. This 8-bit value defines the command to be executed. The
 * command code is followed by the parameters required for this specific flash
 * command, typically an address and/or data values. The command parameter table is
 * written in terms of FCCOB Number (which is equivalent to the byte number). This
 * number is a reference to the FCCOB register name and is not the register
 * address. FCCOB Number Typical Command Parameter Contents [7:0] 0 FCMD (a code that
 * defines the flash command) 1 Flash address [23:16] 2 Flash address [15:8] 3
 * Flash address [7:0] 4 Data Byte 0 5 Data Byte 1 6 Data Byte 2 7 Data Byte 3 8
 * Data Byte 4 9 Data Byte 5 A Data Byte 6 B Data Byte 7 FCCOB Endianness : The
 * FCCOB register group uses a big endian addressing convention. For all command
 * parameter fields larger than 1 byte, the most significant data resides in the
 * lowest FCCOB register number.
 */
/*@{*/
#define BP_FTFA_FCCOB8_CCOBn (0U)          /*!< Bit position for FTFA_FCCOB8_CCOBn. */
#define BM_FTFA_FCCOB8_CCOBn (0xFFU)       /*!< Bit mask for FTFA_FCCOB8_CCOBn. */
#define BS_FTFA_FCCOB8_CCOBn (8U)          /*!< Bit field size in bits for FTFA_FCCOB8_CCOBn. */

/*! @brief Read current value of the FTFA_FCCOB8_CCOBn field. */
#define BR_FTFA_FCCOB8_CCOBn(x) (HW_FTFA_FCCOB8(x).U)

/*! @brief Format value for bitfield FTFA_FCCOB8_CCOBn. */
#define BF_FTFA_FCCOB8_CCOBn(v) ((uint8_t)((uint8_t)(v) << BP_FTFA_FCCOB8_CCOBn) & BM_FTFA_FCCOB8_CCOBn)

/*! @brief Set the CCOBn field to a new value. */
#define BW_FTFA_FCCOB8_CCOBn(x, v) (HW_FTFA_FCCOB8_WR(x, v))
/*@}*/

/*******************************************************************************
 * HW_FTFA_FPROT3 - Program Flash Protection Registers
 ******************************************************************************/

/*!
 * @brief HW_FTFA_FPROT3 - Program Flash Protection Registers (RW)
 *
 * Reset value: 0x00U
 *
 * The FPROT registers define which logical program flash regions are protected
 * from program and erase operations. Protected flash regions cannot have their
 * content changed; that is, these regions cannot be programmed and cannot be
 * erased by any flash command. Unprotected regions can be changed by program and
 * erase operations. The four FPROT registers allow up to 32 protectable regions.
 * Each bit protects a 1/32 region of the program flash memory except for memory
 * configurations with less than 32 KB of program flash where each assigned bit
 * protects 1 KB . For configurations with 24 KB of program flash memory or less,
 * FPROT0 is not used. For configurations with 16 KB of program flash memory or
 * less, FPROT1 is not used. For configurations with 8 KB of program flash memory,
 * FPROT2 is not used. The bitfields are defined in each register as follows:
 * Program flash protection register Program flash protection bits FPROT0 PROT[31:24]
 * FPROT1 PROT[23:16] FPROT2 PROT[15:8] FPROT3 PROT[7:0] During the reset
 * sequence, the FPROT registers are loaded with the contents of the program flash
 * protection bytes in the Flash Configuration Field as indicated in the following
 * table. Program flash protection register Flash Configuration Field offset
 * address FPROT0 0x000B FPROT1 0x000A FPROT2 0x0009 FPROT3 0x0008 To change the
 * program flash protection that is loaded during the reset sequence, unprotect the
 * sector of program flash memory that contains the Flash Configuration Field. Then,
 * reprogram the program flash protection byte.
 */
typedef union _hw_ftfa_fprot3
{
    uint8_t U;
    struct _hw_ftfa_fprot3_bitfields
    {
        uint8_t PROT : 8;              /*!< [7:0] Program Flash Region Protect */
    } B;
} hw_ftfa_fprot3_t;

/*!
 * @name Constants and macros for entire FTFA_FPROT3 register
 */
/*@{*/
#define HW_FTFA_FPROT3_ADDR(x)   ((x) + 0x10U)

#define HW_FTFA_FPROT3(x)        (*(__IO hw_ftfa_fprot3_t *) HW_FTFA_FPROT3_ADDR(x))
#define HW_FTFA_FPROT3_RD(x)     (HW_FTFA_FPROT3(x).U)
#define HW_FTFA_FPROT3_WR(x, v)  (HW_FTFA_FPROT3(x).U = (v))
#define HW_FTFA_FPROT3_SET(x, v) (HW_FTFA_FPROT3_WR(x, HW_FTFA_FPROT3_RD(x) |  (v)))
#define HW_FTFA_FPROT3_CLR(x, v) (HW_FTFA_FPROT3_WR(x, HW_FTFA_FPROT3_RD(x) & ~(v)))
#define HW_FTFA_FPROT3_TOG(x, v) (HW_FTFA_FPROT3_WR(x, HW_FTFA_FPROT3_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual FTFA_FPROT3 bitfields
 */

/*!
 * @name Register FTFA_FPROT3, field PROT[7:0] (RW)
 *
 * Each program flash region can be protected from program and erase operations
 * by setting the associated PROT bit. In NVM Normal mode: The protection can
 * only be increased, meaning that currently unprotected memory can be protected,
 * but currently protected memory cannot be unprotected. Since unprotected regions
 * are marked with a 1 and protected regions use a 0, only writes changing 1s to
 * 0s are accepted. This 1-to-0 transition check is performed on a bit-by-bit
 * basis. Those FPROT bits with 1-to-0 transitions are accepted while all bits with
 * 0-to-1 transitions are ignored. In NVM Special mode: All bits of FPROT are
 * writable without restriction. Unprotected areas can be protected and protected
 * areas can be unprotected. The user must never write to any FPROT register while
 * a command is running (CCIF=0). Trying to alter data in any protected area in
 * the program flash memory results in a protection violation error and sets the
 * FSTAT[FPVIOL] bit. A full block erase of a program flash block is not possible
 * if it contains any protected region. Each bit in the 32-bit protection
 * register represents 1/32 of the total program flash except for configurations where
 * program flash memory is less than 32 KB. For configurations with less than 32
 * KB of program flash memory, each assigned bit represents 1 KB.
 *
 * Values:
 * - 0 - Program flash region is protected.
 * - 1 - Program flash region is not protected
 */
/*@{*/
#define BP_FTFA_FPROT3_PROT  (0U)          /*!< Bit position for FTFA_FPROT3_PROT. */
#define BM_FTFA_FPROT3_PROT  (0xFFU)       /*!< Bit mask for FTFA_FPROT3_PROT. */
#define BS_FTFA_FPROT3_PROT  (8U)          /*!< Bit field size in bits for FTFA_FPROT3_PROT. */

/*! @brief Read current value of the FTFA_FPROT3_PROT field. */
#define BR_FTFA_FPROT3_PROT(x) (HW_FTFA_FPROT3(x).U)

/*! @brief Format value for bitfield FTFA_FPROT3_PROT. */
#define BF_FTFA_FPROT3_PROT(v) ((uint8_t)((uint8_t)(v) << BP_FTFA_FPROT3_PROT) & BM_FTFA_FPROT3_PROT)

/*! @brief Set the PROT field to a new value. */
#define BW_FTFA_FPROT3_PROT(x, v) (HW_FTFA_FPROT3_WR(x, v))
/*@}*/

/*******************************************************************************
 * HW_FTFA_FPROT2 - Program Flash Protection Registers
 ******************************************************************************/

/*!
 * @brief HW_FTFA_FPROT2 - Program Flash Protection Registers (RW)
 *
 * Reset value: 0x00U
 *
 * The FPROT registers define which logical program flash regions are protected
 * from program and erase operations. Protected flash regions cannot have their
 * content changed; that is, these regions cannot be programmed and cannot be
 * erased by any flash command. Unprotected regions can be changed by program and
 * erase operations. The four FPROT registers allow up to 32 protectable regions.
 * Each bit protects a 1/32 region of the program flash memory except for memory
 * configurations with less than 32 KB of program flash where each assigned bit
 * protects 1 KB . For configurations with 24 KB of program flash memory or less,
 * FPROT0 is not used. For configurations with 16 KB of program flash memory or
 * less, FPROT1 is not used. For configurations with 8 KB of program flash memory,
 * FPROT2 is not used. The bitfields are defined in each register as follows:
 * Program flash protection register Program flash protection bits FPROT0 PROT[31:24]
 * FPROT1 PROT[23:16] FPROT2 PROT[15:8] FPROT3 PROT[7:0] During the reset
 * sequence, the FPROT registers are loaded with the contents of the program flash
 * protection bytes in the Flash Configuration Field as indicated in the following
 * table. Program flash protection register Flash Configuration Field offset
 * address FPROT0 0x000B FPROT1 0x000A FPROT2 0x0009 FPROT3 0x0008 To change the
 * program flash protection that is loaded during the reset sequence, unprotect the
 * sector of program flash memory that contains the Flash Configuration Field. Then,
 * reprogram the program flash protection byte.
 */
typedef union _hw_ftfa_fprot2
{
    uint8_t U;
    struct _hw_ftfa_fprot2_bitfields
    {
        uint8_t PROT : 8;              /*!< [7:0] Program Flash Region Protect */
    } B;
} hw_ftfa_fprot2_t;

/*!
 * @name Constants and macros for entire FTFA_FPROT2 register
 */
/*@{*/
#define HW_FTFA_FPROT2_ADDR(x)   ((x) + 0x11U)

#define HW_FTFA_FPROT2(x)        (*(__IO hw_ftfa_fprot2_t *) HW_FTFA_FPROT2_ADDR(x))
#define HW_FTFA_FPROT2_RD(x)     (HW_FTFA_FPROT2(x).U)
#define HW_FTFA_FPROT2_WR(x, v)  (HW_FTFA_FPROT2(x).U = (v))
#define HW_FTFA_FPROT2_SET(x, v) (HW_FTFA_FPROT2_WR(x, HW_FTFA_FPROT2_RD(x) |  (v)))
#define HW_FTFA_FPROT2_CLR(x, v) (HW_FTFA_FPROT2_WR(x, HW_FTFA_FPROT2_RD(x) & ~(v)))
#define HW_FTFA_FPROT2_TOG(x, v) (HW_FTFA_FPROT2_WR(x, HW_FTFA_FPROT2_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual FTFA_FPROT2 bitfields
 */

/*!
 * @name Register FTFA_FPROT2, field PROT[7:0] (RW)
 *
 * Each program flash region can be protected from program and erase operations
 * by setting the associated PROT bit. In NVM Normal mode: The protection can
 * only be increased, meaning that currently unprotected memory can be protected,
 * but currently protected memory cannot be unprotected. Since unprotected regions
 * are marked with a 1 and protected regions use a 0, only writes changing 1s to
 * 0s are accepted. This 1-to-0 transition check is performed on a bit-by-bit
 * basis. Those FPROT bits with 1-to-0 transitions are accepted while all bits with
 * 0-to-1 transitions are ignored. In NVM Special mode: All bits of FPROT are
 * writable without restriction. Unprotected areas can be protected and protected
 * areas can be unprotected. The user must never write to any FPROT register while
 * a command is running (CCIF=0). Trying to alter data in any protected area in
 * the program flash memory results in a protection violation error and sets the
 * FSTAT[FPVIOL] bit. A full block erase of a program flash block is not possible
 * if it contains any protected region. Each bit in the 32-bit protection
 * register represents 1/32 of the total program flash except for configurations where
 * program flash memory is less than 32 KB. For configurations with less than 32
 * KB of program flash memory, each assigned bit represents 1 KB.
 *
 * Values:
 * - 0 - Program flash region is protected.
 * - 1 - Program flash region is not protected
 */
/*@{*/
#define BP_FTFA_FPROT2_PROT  (0U)          /*!< Bit position for FTFA_FPROT2_PROT. */
#define BM_FTFA_FPROT2_PROT  (0xFFU)       /*!< Bit mask for FTFA_FPROT2_PROT. */
#define BS_FTFA_FPROT2_PROT  (8U)          /*!< Bit field size in bits for FTFA_FPROT2_PROT. */

/*! @brief Read current value of the FTFA_FPROT2_PROT field. */
#define BR_FTFA_FPROT2_PROT(x) (HW_FTFA_FPROT2(x).U)

/*! @brief Format value for bitfield FTFA_FPROT2_PROT. */
#define BF_FTFA_FPROT2_PROT(v) ((uint8_t)((uint8_t)(v) << BP_FTFA_FPROT2_PROT) & BM_FTFA_FPROT2_PROT)

/*! @brief Set the PROT field to a new value. */
#define BW_FTFA_FPROT2_PROT(x, v) (HW_FTFA_FPROT2_WR(x, v))
/*@}*/

/*******************************************************************************
 * HW_FTFA_FPROT1 - Program Flash Protection Registers
 ******************************************************************************/

/*!
 * @brief HW_FTFA_FPROT1 - Program Flash Protection Registers (RW)
 *
 * Reset value: 0x00U
 *
 * The FPROT registers define which logical program flash regions are protected
 * from program and erase operations. Protected flash regions cannot have their
 * content changed; that is, these regions cannot be programmed and cannot be
 * erased by any flash command. Unprotected regions can be changed by program and
 * erase operations. The four FPROT registers allow up to 32 protectable regions.
 * Each bit protects a 1/32 region of the program flash memory except for memory
 * configurations with less than 32 KB of program flash where each assigned bit
 * protects 1 KB . For configurations with 24 KB of program flash memory or less,
 * FPROT0 is not used. For configurations with 16 KB of program flash memory or
 * less, FPROT1 is not used. For configurations with 8 KB of program flash memory,
 * FPROT2 is not used. The bitfields are defined in each register as follows:
 * Program flash protection register Program flash protection bits FPROT0 PROT[31:24]
 * FPROT1 PROT[23:16] FPROT2 PROT[15:8] FPROT3 PROT[7:0] During the reset
 * sequence, the FPROT registers are loaded with the contents of the program flash
 * protection bytes in the Flash Configuration Field as indicated in the following
 * table. Program flash protection register Flash Configuration Field offset
 * address FPROT0 0x000B FPROT1 0x000A FPROT2 0x0009 FPROT3 0x0008 To change the
 * program flash protection that is loaded during the reset sequence, unprotect the
 * sector of program flash memory that contains the Flash Configuration Field. Then,
 * reprogram the program flash protection byte.
 */
typedef union _hw_ftfa_fprot1
{
    uint8_t U;
    struct _hw_ftfa_fprot1_bitfields
    {
        uint8_t PROT : 8;              /*!< [7:0] Program Flash Region Protect */
    } B;
} hw_ftfa_fprot1_t;

/*!
 * @name Constants and macros for entire FTFA_FPROT1 register
 */
/*@{*/
#define HW_FTFA_FPROT1_ADDR(x)   ((x) + 0x12U)

#define HW_FTFA_FPROT1(x)        (*(__IO hw_ftfa_fprot1_t *) HW_FTFA_FPROT1_ADDR(x))
#define HW_FTFA_FPROT1_RD(x)     (HW_FTFA_FPROT1(x).U)
#define HW_FTFA_FPROT1_WR(x, v)  (HW_FTFA_FPROT1(x).U = (v))
#define HW_FTFA_FPROT1_SET(x, v) (HW_FTFA_FPROT1_WR(x, HW_FTFA_FPROT1_RD(x) |  (v)))
#define HW_FTFA_FPROT1_CLR(x, v) (HW_FTFA_FPROT1_WR(x, HW_FTFA_FPROT1_RD(x) & ~(v)))
#define HW_FTFA_FPROT1_TOG(x, v) (HW_FTFA_FPROT1_WR(x, HW_FTFA_FPROT1_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual FTFA_FPROT1 bitfields
 */

/*!
 * @name Register FTFA_FPROT1, field PROT[7:0] (RW)
 *
 * Each program flash region can be protected from program and erase operations
 * by setting the associated PROT bit. In NVM Normal mode: The protection can
 * only be increased, meaning that currently unprotected memory can be protected,
 * but currently protected memory cannot be unprotected. Since unprotected regions
 * are marked with a 1 and protected regions use a 0, only writes changing 1s to
 * 0s are accepted. This 1-to-0 transition check is performed on a bit-by-bit
 * basis. Those FPROT bits with 1-to-0 transitions are accepted while all bits with
 * 0-to-1 transitions are ignored. In NVM Special mode: All bits of FPROT are
 * writable without restriction. Unprotected areas can be protected and protected
 * areas can be unprotected. The user must never write to any FPROT register while
 * a command is running (CCIF=0). Trying to alter data in any protected area in
 * the program flash memory results in a protection violation error and sets the
 * FSTAT[FPVIOL] bit. A full block erase of a program flash block is not possible
 * if it contains any protected region. Each bit in the 32-bit protection
 * register represents 1/32 of the total program flash except for configurations where
 * program flash memory is less than 32 KB. For configurations with less than 32
 * KB of program flash memory, each assigned bit represents 1 KB.
 *
 * Values:
 * - 0 - Program flash region is protected.
 * - 1 - Program flash region is not protected
 */
/*@{*/
#define BP_FTFA_FPROT1_PROT  (0U)          /*!< Bit position for FTFA_FPROT1_PROT. */
#define BM_FTFA_FPROT1_PROT  (0xFFU)       /*!< Bit mask for FTFA_FPROT1_PROT. */
#define BS_FTFA_FPROT1_PROT  (8U)          /*!< Bit field size in bits for FTFA_FPROT1_PROT. */

/*! @brief Read current value of the FTFA_FPROT1_PROT field. */
#define BR_FTFA_FPROT1_PROT(x) (HW_FTFA_FPROT1(x).U)

/*! @brief Format value for bitfield FTFA_FPROT1_PROT. */
#define BF_FTFA_FPROT1_PROT(v) ((uint8_t)((uint8_t)(v) << BP_FTFA_FPROT1_PROT) & BM_FTFA_FPROT1_PROT)

/*! @brief Set the PROT field to a new value. */
#define BW_FTFA_FPROT1_PROT(x, v) (HW_FTFA_FPROT1_WR(x, v))
/*@}*/

/*******************************************************************************
 * HW_FTFA_FPROT0 - Program Flash Protection Registers
 ******************************************************************************/

/*!
 * @brief HW_FTFA_FPROT0 - Program Flash Protection Registers (RW)
 *
 * Reset value: 0x00U
 *
 * The FPROT registers define which logical program flash regions are protected
 * from program and erase operations. Protected flash regions cannot have their
 * content changed; that is, these regions cannot be programmed and cannot be
 * erased by any flash command. Unprotected regions can be changed by program and
 * erase operations. The four FPROT registers allow up to 32 protectable regions.
 * Each bit protects a 1/32 region of the program flash memory except for memory
 * configurations with less than 32 KB of program flash where each assigned bit
 * protects 1 KB . For configurations with 24 KB of program flash memory or less,
 * FPROT0 is not used. For configurations with 16 KB of program flash memory or
 * less, FPROT1 is not used. For configurations with 8 KB of program flash memory,
 * FPROT2 is not used. The bitfields are defined in each register as follows:
 * Program flash protection register Program flash protection bits FPROT0 PROT[31:24]
 * FPROT1 PROT[23:16] FPROT2 PROT[15:8] FPROT3 PROT[7:0] During the reset
 * sequence, the FPROT registers are loaded with the contents of the program flash
 * protection bytes in the Flash Configuration Field as indicated in the following
 * table. Program flash protection register Flash Configuration Field offset
 * address FPROT0 0x000B FPROT1 0x000A FPROT2 0x0009 FPROT3 0x0008 To change the
 * program flash protection that is loaded during the reset sequence, unprotect the
 * sector of program flash memory that contains the Flash Configuration Field. Then,
 * reprogram the program flash protection byte.
 */
typedef union _hw_ftfa_fprot0
{
    uint8_t U;
    struct _hw_ftfa_fprot0_bitfields
    {
        uint8_t PROT : 8;              /*!< [7:0] Program Flash Region Protect */
    } B;
} hw_ftfa_fprot0_t;

/*!
 * @name Constants and macros for entire FTFA_FPROT0 register
 */
/*@{*/
#define HW_FTFA_FPROT0_ADDR(x)   ((x) + 0x13U)

#define HW_FTFA_FPROT0(x)        (*(__IO hw_ftfa_fprot0_t *) HW_FTFA_FPROT0_ADDR(x))
#define HW_FTFA_FPROT0_RD(x)     (HW_FTFA_FPROT0(x).U)
#define HW_FTFA_FPROT0_WR(x, v)  (HW_FTFA_FPROT0(x).U = (v))
#define HW_FTFA_FPROT0_SET(x, v) (HW_FTFA_FPROT0_WR(x, HW_FTFA_FPROT0_RD(x) |  (v)))
#define HW_FTFA_FPROT0_CLR(x, v) (HW_FTFA_FPROT0_WR(x, HW_FTFA_FPROT0_RD(x) & ~(v)))
#define HW_FTFA_FPROT0_TOG(x, v) (HW_FTFA_FPROT0_WR(x, HW_FTFA_FPROT0_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual FTFA_FPROT0 bitfields
 */

/*!
 * @name Register FTFA_FPROT0, field PROT[7:0] (RW)
 *
 * Each program flash region can be protected from program and erase operations
 * by setting the associated PROT bit. In NVM Normal mode: The protection can
 * only be increased, meaning that currently unprotected memory can be protected,
 * but currently protected memory cannot be unprotected. Since unprotected regions
 * are marked with a 1 and protected regions use a 0, only writes changing 1s to
 * 0s are accepted. This 1-to-0 transition check is performed on a bit-by-bit
 * basis. Those FPROT bits with 1-to-0 transitions are accepted while all bits with
 * 0-to-1 transitions are ignored. In NVM Special mode: All bits of FPROT are
 * writable without restriction. Unprotected areas can be protected and protected
 * areas can be unprotected. The user must never write to any FPROT register while
 * a command is running (CCIF=0). Trying to alter data in any protected area in
 * the program flash memory results in a protection violation error and sets the
 * FSTAT[FPVIOL] bit. A full block erase of a program flash block is not possible
 * if it contains any protected region. Each bit in the 32-bit protection
 * register represents 1/32 of the total program flash except for configurations where
 * program flash memory is less than 32 KB. For configurations with less than 32
 * KB of program flash memory, each assigned bit represents 1 KB.
 *
 * Values:
 * - 0 - Program flash region is protected.
 * - 1 - Program flash region is not protected
 */
/*@{*/
#define BP_FTFA_FPROT0_PROT  (0U)          /*!< Bit position for FTFA_FPROT0_PROT. */
#define BM_FTFA_FPROT0_PROT  (0xFFU)       /*!< Bit mask for FTFA_FPROT0_PROT. */
#define BS_FTFA_FPROT0_PROT  (8U)          /*!< Bit field size in bits for FTFA_FPROT0_PROT. */

/*! @brief Read current value of the FTFA_FPROT0_PROT field. */
#define BR_FTFA_FPROT0_PROT(x) (HW_FTFA_FPROT0(x).U)

/*! @brief Format value for bitfield FTFA_FPROT0_PROT. */
#define BF_FTFA_FPROT0_PROT(v) ((uint8_t)((uint8_t)(v) << BP_FTFA_FPROT0_PROT) & BM_FTFA_FPROT0_PROT)

/*! @brief Set the PROT field to a new value. */
#define BW_FTFA_FPROT0_PROT(x, v) (HW_FTFA_FPROT0_WR(x, v))
/*@}*/

/*******************************************************************************
 * HW_FTFA_XACCH3 - Execute-only Access Registers
 ******************************************************************************/

/*!
 * @brief HW_FTFA_XACCH3 - Execute-only Access Registers (RO)
 *
 * Reset value: 0x00U
 *
 * The XACC registers define which logical program flash segments are restricted
 * to data read or execute only or both data and instruction fetches. The eight
 * XACC registers allow up to 64 restricted segments of equal memory size.
 * Execute-only access register Program flash execute-only access bits XACCH0 XA[63:56]
 * XACCH1 XA[55:48] XACCH2 XA[47:40] XACCH3 XA[39:32] XACCL0 XA[31:24] XACCL1
 * XA[23:16] XACCL2 XA[15:8] XACCL3 XA[7:0] During the reset sequence, the XACC
 * registers are loaded with the logical AND of Program Flash IFR addresses A and B
 * as indicated in the following table. Execute-only access register Program
 * Flash IFR address A Program Flash IFR address B XACCH0 0xA3 0xAB XACCH1 0xA2 0xAA
 * XACCH2 0xA1 0xA9 XACCH3 0xA0 0xA8 XACCL0 0xA7 0xAF XACCL1 0xA6 0xAE XACCL2
 * 0xA5 0xAD XACCL3 0xA4 0xAC Use the Program Once command to program the
 * execute-only access control fields that are loaded during the reset sequence.
 */
typedef union _hw_ftfa_xacch3
{
    uint8_t U;
    struct _hw_ftfa_xacch3_bitfields
    {
        uint8_t XA : 8;                /*!< [7:0] Execute-only access control */
    } B;
} hw_ftfa_xacch3_t;

/*!
 * @name Constants and macros for entire FTFA_XACCH3 register
 */
/*@{*/
#define HW_FTFA_XACCH3_ADDR(x)   ((x) + 0x18U)

#define HW_FTFA_XACCH3(x)        (*(__I hw_ftfa_xacch3_t *) HW_FTFA_XACCH3_ADDR(x))
#define HW_FTFA_XACCH3_RD(x)     (HW_FTFA_XACCH3(x).U)
/*@}*/

/*
 * Constants & macros for individual FTFA_XACCH3 bitfields
 */

/*!
 * @name Register FTFA_XACCH3, field XA[7:0] (RO)
 *
 * Values:
 * - 0 - Associated segment is accessible in execute mode only (as an
 *     instruction fetch)
 * - 1 - Associated segment is accessible as data or in execute mode
 */
/*@{*/
#define BP_FTFA_XACCH3_XA    (0U)          /*!< Bit position for FTFA_XACCH3_XA. */
#define BM_FTFA_XACCH3_XA    (0xFFU)       /*!< Bit mask for FTFA_XACCH3_XA. */
#define BS_FTFA_XACCH3_XA    (8U)          /*!< Bit field size in bits for FTFA_XACCH3_XA. */

/*! @brief Read current value of the FTFA_XACCH3_XA field. */
#define BR_FTFA_XACCH3_XA(x) (HW_FTFA_XACCH3(x).U)
/*@}*/

/*******************************************************************************
 * HW_FTFA_XACCH2 - Execute-only Access Registers
 ******************************************************************************/

/*!
 * @brief HW_FTFA_XACCH2 - Execute-only Access Registers (RO)
 *
 * Reset value: 0x00U
 *
 * The XACC registers define which logical program flash segments are restricted
 * to data read or execute only or both data and instruction fetches. The eight
 * XACC registers allow up to 64 restricted segments of equal memory size.
 * Execute-only access register Program flash execute-only access bits XACCH0 XA[63:56]
 * XACCH1 XA[55:48] XACCH2 XA[47:40] XACCH3 XA[39:32] XACCL0 XA[31:24] XACCL1
 * XA[23:16] XACCL2 XA[15:8] XACCL3 XA[7:0] During the reset sequence, the XACC
 * registers are loaded with the logical AND of Program Flash IFR addresses A and B
 * as indicated in the following table. Execute-only access register Program
 * Flash IFR address A Program Flash IFR address B XACCH0 0xA3 0xAB XACCH1 0xA2 0xAA
 * XACCH2 0xA1 0xA9 XACCH3 0xA0 0xA8 XACCL0 0xA7 0xAF XACCL1 0xA6 0xAE XACCL2
 * 0xA5 0xAD XACCL3 0xA4 0xAC Use the Program Once command to program the
 * execute-only access control fields that are loaded during the reset sequence.
 */
typedef union _hw_ftfa_xacch2
{
    uint8_t U;
    struct _hw_ftfa_xacch2_bitfields
    {
        uint8_t XA : 8;                /*!< [7:0] Execute-only access control */
    } B;
} hw_ftfa_xacch2_t;

/*!
 * @name Constants and macros for entire FTFA_XACCH2 register
 */
/*@{*/
#define HW_FTFA_XACCH2_ADDR(x)   ((x) + 0x19U)

#define HW_FTFA_XACCH2(x)        (*(__I hw_ftfa_xacch2_t *) HW_FTFA_XACCH2_ADDR(x))
#define HW_FTFA_XACCH2_RD(x)     (HW_FTFA_XACCH2(x).U)
/*@}*/

/*
 * Constants & macros for individual FTFA_XACCH2 bitfields
 */

/*!
 * @name Register FTFA_XACCH2, field XA[7:0] (RO)
 *
 * Values:
 * - 0 - Associated segment is accessible in execute mode only (as an
 *     instruction fetch)
 * - 1 - Associated segment is accessible as data or in execute mode
 */
/*@{*/
#define BP_FTFA_XACCH2_XA    (0U)          /*!< Bit position for FTFA_XACCH2_XA. */
#define BM_FTFA_XACCH2_XA    (0xFFU)       /*!< Bit mask for FTFA_XACCH2_XA. */
#define BS_FTFA_XACCH2_XA    (8U)          /*!< Bit field size in bits for FTFA_XACCH2_XA. */

/*! @brief Read current value of the FTFA_XACCH2_XA field. */
#define BR_FTFA_XACCH2_XA(x) (HW_FTFA_XACCH2(x).U)
/*@}*/

/*******************************************************************************
 * HW_FTFA_XACCH1 - Execute-only Access Registers
 ******************************************************************************/

/*!
 * @brief HW_FTFA_XACCH1 - Execute-only Access Registers (RO)
 *
 * Reset value: 0x00U
 *
 * The XACC registers define which logical program flash segments are restricted
 * to data read or execute only or both data and instruction fetches. The eight
 * XACC registers allow up to 64 restricted segments of equal memory size.
 * Execute-only access register Program flash execute-only access bits XACCH0 XA[63:56]
 * XACCH1 XA[55:48] XACCH2 XA[47:40] XACCH3 XA[39:32] XACCL0 XA[31:24] XACCL1
 * XA[23:16] XACCL2 XA[15:8] XACCL3 XA[7:0] During the reset sequence, the XACC
 * registers are loaded with the logical AND of Program Flash IFR addresses A and B
 * as indicated in the following table. Execute-only access register Program
 * Flash IFR address A Program Flash IFR address B XACCH0 0xA3 0xAB XACCH1 0xA2 0xAA
 * XACCH2 0xA1 0xA9 XACCH3 0xA0 0xA8 XACCL0 0xA7 0xAF XACCL1 0xA6 0xAE XACCL2
 * 0xA5 0xAD XACCL3 0xA4 0xAC Use the Program Once command to program the
 * execute-only access control fields that are loaded during the reset sequence.
 */
typedef union _hw_ftfa_xacch1
{
    uint8_t U;
    struct _hw_ftfa_xacch1_bitfields
    {
        uint8_t XA : 8;                /*!< [7:0] Execute-only access control */
    } B;
} hw_ftfa_xacch1_t;

/*!
 * @name Constants and macros for entire FTFA_XACCH1 register
 */
/*@{*/
#define HW_FTFA_XACCH1_ADDR(x)   ((x) + 0x1AU)

#define HW_FTFA_XACCH1(x)        (*(__I hw_ftfa_xacch1_t *) HW_FTFA_XACCH1_ADDR(x))
#define HW_FTFA_XACCH1_RD(x)     (HW_FTFA_XACCH1(x).U)
/*@}*/

/*
 * Constants & macros for individual FTFA_XACCH1 bitfields
 */

/*!
 * @name Register FTFA_XACCH1, field XA[7:0] (RO)
 *
 * Values:
 * - 0 - Associated segment is accessible in execute mode only (as an
 *     instruction fetch)
 * - 1 - Associated segment is accessible as data or in execute mode
 */
/*@{*/
#define BP_FTFA_XACCH1_XA    (0U)          /*!< Bit position for FTFA_XACCH1_XA. */
#define BM_FTFA_XACCH1_XA    (0xFFU)       /*!< Bit mask for FTFA_XACCH1_XA. */
#define BS_FTFA_XACCH1_XA    (8U)          /*!< Bit field size in bits for FTFA_XACCH1_XA. */

/*! @brief Read current value of the FTFA_XACCH1_XA field. */
#define BR_FTFA_XACCH1_XA(x) (HW_FTFA_XACCH1(x).U)
/*@}*/

/*******************************************************************************
 * HW_FTFA_XACCH0 - Execute-only Access Registers
 ******************************************************************************/

/*!
 * @brief HW_FTFA_XACCH0 - Execute-only Access Registers (RO)
 *
 * Reset value: 0x00U
 *
 * The XACC registers define which logical program flash segments are restricted
 * to data read or execute only or both data and instruction fetches. The eight
 * XACC registers allow up to 64 restricted segments of equal memory size.
 * Execute-only access register Program flash execute-only access bits XACCH0 XA[63:56]
 * XACCH1 XA[55:48] XACCH2 XA[47:40] XACCH3 XA[39:32] XACCL0 XA[31:24] XACCL1
 * XA[23:16] XACCL2 XA[15:8] XACCL3 XA[7:0] During the reset sequence, the XACC
 * registers are loaded with the logical AND of Program Flash IFR addresses A and B
 * as indicated in the following table. Execute-only access register Program
 * Flash IFR address A Program Flash IFR address B XACCH0 0xA3 0xAB XACCH1 0xA2 0xAA
 * XACCH2 0xA1 0xA9 XACCH3 0xA0 0xA8 XACCL0 0xA7 0xAF XACCL1 0xA6 0xAE XACCL2
 * 0xA5 0xAD XACCL3 0xA4 0xAC Use the Program Once command to program the
 * execute-only access control fields that are loaded during the reset sequence.
 */
typedef union _hw_ftfa_xacch0
{
    uint8_t U;
    struct _hw_ftfa_xacch0_bitfields
    {
        uint8_t XA : 8;                /*!< [7:0] Execute-only access control */
    } B;
} hw_ftfa_xacch0_t;

/*!
 * @name Constants and macros for entire FTFA_XACCH0 register
 */
/*@{*/
#define HW_FTFA_XACCH0_ADDR(x)   ((x) + 0x1BU)

#define HW_FTFA_XACCH0(x)        (*(__I hw_ftfa_xacch0_t *) HW_FTFA_XACCH0_ADDR(x))
#define HW_FTFA_XACCH0_RD(x)     (HW_FTFA_XACCH0(x).U)
/*@}*/

/*
 * Constants & macros for individual FTFA_XACCH0 bitfields
 */

/*!
 * @name Register FTFA_XACCH0, field XA[7:0] (RO)
 *
 * Values:
 * - 0 - Associated segment is accessible in execute mode only (as an
 *     instruction fetch)
 * - 1 - Associated segment is accessible as data or in execute mode
 */
/*@{*/
#define BP_FTFA_XACCH0_XA    (0U)          /*!< Bit position for FTFA_XACCH0_XA. */
#define BM_FTFA_XACCH0_XA    (0xFFU)       /*!< Bit mask for FTFA_XACCH0_XA. */
#define BS_FTFA_XACCH0_XA    (8U)          /*!< Bit field size in bits for FTFA_XACCH0_XA. */

/*! @brief Read current value of the FTFA_XACCH0_XA field. */
#define BR_FTFA_XACCH0_XA(x) (HW_FTFA_XACCH0(x).U)
/*@}*/

/*******************************************************************************
 * HW_FTFA_XACCL3 - Execute-only Access Registers
 ******************************************************************************/

/*!
 * @brief HW_FTFA_XACCL3 - Execute-only Access Registers (RO)
 *
 * Reset value: 0x00U
 *
 * The XACC registers define which logical program flash segments are restricted
 * to data read or execute only or both data and instruction fetches. The eight
 * XACC registers allow up to 64 restricted segments of equal memory size.
 * Execute-only access register Program flash execute-only access bits XACCH0 XA[63:56]
 * XACCH1 XA[55:48] XACCH2 XA[47:40] XACCH3 XA[39:32] XACCL0 XA[31:24] XACCL1
 * XA[23:16] XACCL2 XA[15:8] XACCL3 XA[7:0] During the reset sequence, the XACC
 * registers are loaded with the logical AND of Program Flash IFR addresses A and B
 * as indicated in the following table. Execute-only access register Program
 * Flash IFR address A Program Flash IFR address B XACCH0 0xA3 0xAB XACCH1 0xA2 0xAA
 * XACCH2 0xA1 0xA9 XACCH3 0xA0 0xA8 XACCL0 0xA7 0xAF XACCL1 0xA6 0xAE XACCL2
 * 0xA5 0xAD XACCL3 0xA4 0xAC Use the Program Once command to program the
 * execute-only access control fields that are loaded during the reset sequence.
 */
typedef union _hw_ftfa_xaccl3
{
    uint8_t U;
    struct _hw_ftfa_xaccl3_bitfields
    {
        uint8_t XA : 8;                /*!< [7:0] Execute-only access control */
    } B;
} hw_ftfa_xaccl3_t;

/*!
 * @name Constants and macros for entire FTFA_XACCL3 register
 */
/*@{*/
#define HW_FTFA_XACCL3_ADDR(x)   ((x) + 0x1CU)

#define HW_FTFA_XACCL3(x)        (*(__I hw_ftfa_xaccl3_t *) HW_FTFA_XACCL3_ADDR(x))
#define HW_FTFA_XACCL3_RD(x)     (HW_FTFA_XACCL3(x).U)
/*@}*/

/*
 * Constants & macros for individual FTFA_XACCL3 bitfields
 */

/*!
 * @name Register FTFA_XACCL3, field XA[7:0] (RO)
 *
 * Values:
 * - 0 - Associated segment is accessible in execute mode only (as an
 *     instruction fetch)
 * - 1 - Associated segment is accessible as data or in execute mode
 */
/*@{*/
#define BP_FTFA_XACCL3_XA    (0U)          /*!< Bit position for FTFA_XACCL3_XA. */
#define BM_FTFA_XACCL3_XA    (0xFFU)       /*!< Bit mask for FTFA_XACCL3_XA. */
#define BS_FTFA_XACCL3_XA    (8U)          /*!< Bit field size in bits for FTFA_XACCL3_XA. */

/*! @brief Read current value of the FTFA_XACCL3_XA field. */
#define BR_FTFA_XACCL3_XA(x) (HW_FTFA_XACCL3(x).U)
/*@}*/

/*******************************************************************************
 * HW_FTFA_XACCL2 - Execute-only Access Registers
 ******************************************************************************/

/*!
 * @brief HW_FTFA_XACCL2 - Execute-only Access Registers (RO)
 *
 * Reset value: 0x00U
 *
 * The XACC registers define which logical program flash segments are restricted
 * to data read or execute only or both data and instruction fetches. The eight
 * XACC registers allow up to 64 restricted segments of equal memory size.
 * Execute-only access register Program flash execute-only access bits XACCH0 XA[63:56]
 * XACCH1 XA[55:48] XACCH2 XA[47:40] XACCH3 XA[39:32] XACCL0 XA[31:24] XACCL1
 * XA[23:16] XACCL2 XA[15:8] XACCL3 XA[7:0] During the reset sequence, the XACC
 * registers are loaded with the logical AND of Program Flash IFR addresses A and B
 * as indicated in the following table. Execute-only access register Program
 * Flash IFR address A Program Flash IFR address B XACCH0 0xA3 0xAB XACCH1 0xA2 0xAA
 * XACCH2 0xA1 0xA9 XACCH3 0xA0 0xA8 XACCL0 0xA7 0xAF XACCL1 0xA6 0xAE XACCL2
 * 0xA5 0xAD XACCL3 0xA4 0xAC Use the Program Once command to program the
 * execute-only access control fields that are loaded during the reset sequence.
 */
typedef union _hw_ftfa_xaccl2
{
    uint8_t U;
    struct _hw_ftfa_xaccl2_bitfields
    {
        uint8_t XA : 8;                /*!< [7:0] Execute-only access control */
    } B;
} hw_ftfa_xaccl2_t;

/*!
 * @name Constants and macros for entire FTFA_XACCL2 register
 */
/*@{*/
#define HW_FTFA_XACCL2_ADDR(x)   ((x) + 0x1DU)

#define HW_FTFA_XACCL2(x)        (*(__I hw_ftfa_xaccl2_t *) HW_FTFA_XACCL2_ADDR(x))
#define HW_FTFA_XACCL2_RD(x)     (HW_FTFA_XACCL2(x).U)
/*@}*/

/*
 * Constants & macros for individual FTFA_XACCL2 bitfields
 */

/*!
 * @name Register FTFA_XACCL2, field XA[7:0] (RO)
 *
 * Values:
 * - 0 - Associated segment is accessible in execute mode only (as an
 *     instruction fetch)
 * - 1 - Associated segment is accessible as data or in execute mode
 */
/*@{*/
#define BP_FTFA_XACCL2_XA    (0U)          /*!< Bit position for FTFA_XACCL2_XA. */
#define BM_FTFA_XACCL2_XA    (0xFFU)       /*!< Bit mask for FTFA_XACCL2_XA. */
#define BS_FTFA_XACCL2_XA    (8U)          /*!< Bit field size in bits for FTFA_XACCL2_XA. */

/*! @brief Read current value of the FTFA_XACCL2_XA field. */
#define BR_FTFA_XACCL2_XA(x) (HW_FTFA_XACCL2(x).U)
/*@}*/

/*******************************************************************************
 * HW_FTFA_XACCL1 - Execute-only Access Registers
 ******************************************************************************/

/*!
 * @brief HW_FTFA_XACCL1 - Execute-only Access Registers (RO)
 *
 * Reset value: 0x00U
 *
 * The XACC registers define which logical program flash segments are restricted
 * to data read or execute only or both data and instruction fetches. The eight
 * XACC registers allow up to 64 restricted segments of equal memory size.
 * Execute-only access register Program flash execute-only access bits XACCH0 XA[63:56]
 * XACCH1 XA[55:48] XACCH2 XA[47:40] XACCH3 XA[39:32] XACCL0 XA[31:24] XACCL1
 * XA[23:16] XACCL2 XA[15:8] XACCL3 XA[7:0] During the reset sequence, the XACC
 * registers are loaded with the logical AND of Program Flash IFR addresses A and B
 * as indicated in the following table. Execute-only access register Program
 * Flash IFR address A Program Flash IFR address B XACCH0 0xA3 0xAB XACCH1 0xA2 0xAA
 * XACCH2 0xA1 0xA9 XACCH3 0xA0 0xA8 XACCL0 0xA7 0xAF XACCL1 0xA6 0xAE XACCL2
 * 0xA5 0xAD XACCL3 0xA4 0xAC Use the Program Once command to program the
 * execute-only access control fields that are loaded during the reset sequence.
 */
typedef union _hw_ftfa_xaccl1
{
    uint8_t U;
    struct _hw_ftfa_xaccl1_bitfields
    {
        uint8_t XA : 8;                /*!< [7:0] Execute-only access control */
    } B;
} hw_ftfa_xaccl1_t;

/*!
 * @name Constants and macros for entire FTFA_XACCL1 register
 */
/*@{*/
#define HW_FTFA_XACCL1_ADDR(x)   ((x) + 0x1EU)

#define HW_FTFA_XACCL1(x)        (*(__I hw_ftfa_xaccl1_t *) HW_FTFA_XACCL1_ADDR(x))
#define HW_FTFA_XACCL1_RD(x)     (HW_FTFA_XACCL1(x).U)
/*@}*/

/*
 * Constants & macros for individual FTFA_XACCL1 bitfields
 */

/*!
 * @name Register FTFA_XACCL1, field XA[7:0] (RO)
 *
 * Values:
 * - 0 - Associated segment is accessible in execute mode only (as an
 *     instruction fetch)
 * - 1 - Associated segment is accessible as data or in execute mode
 */
/*@{*/
#define BP_FTFA_XACCL1_XA    (0U)          /*!< Bit position for FTFA_XACCL1_XA. */
#define BM_FTFA_XACCL1_XA    (0xFFU)       /*!< Bit mask for FTFA_XACCL1_XA. */
#define BS_FTFA_XACCL1_XA    (8U)          /*!< Bit field size in bits for FTFA_XACCL1_XA. */

/*! @brief Read current value of the FTFA_XACCL1_XA field. */
#define BR_FTFA_XACCL1_XA(x) (HW_FTFA_XACCL1(x).U)
/*@}*/

/*******************************************************************************
 * HW_FTFA_XACCL0 - Execute-only Access Registers
 ******************************************************************************/

/*!
 * @brief HW_FTFA_XACCL0 - Execute-only Access Registers (RO)
 *
 * Reset value: 0x00U
 *
 * The XACC registers define which logical program flash segments are restricted
 * to data read or execute only or both data and instruction fetches. The eight
 * XACC registers allow up to 64 restricted segments of equal memory size.
 * Execute-only access register Program flash execute-only access bits XACCH0 XA[63:56]
 * XACCH1 XA[55:48] XACCH2 XA[47:40] XACCH3 XA[39:32] XACCL0 XA[31:24] XACCL1
 * XA[23:16] XACCL2 XA[15:8] XACCL3 XA[7:0] During the reset sequence, the XACC
 * registers are loaded with the logical AND of Program Flash IFR addresses A and B
 * as indicated in the following table. Execute-only access register Program
 * Flash IFR address A Program Flash IFR address B XACCH0 0xA3 0xAB XACCH1 0xA2 0xAA
 * XACCH2 0xA1 0xA9 XACCH3 0xA0 0xA8 XACCL0 0xA7 0xAF XACCL1 0xA6 0xAE XACCL2
 * 0xA5 0xAD XACCL3 0xA4 0xAC Use the Program Once command to program the
 * execute-only access control fields that are loaded during the reset sequence.
 */
typedef union _hw_ftfa_xaccl0
{
    uint8_t U;
    struct _hw_ftfa_xaccl0_bitfields
    {
        uint8_t XA : 8;                /*!< [7:0] Execute-only access control */
    } B;
} hw_ftfa_xaccl0_t;

/*!
 * @name Constants and macros for entire FTFA_XACCL0 register
 */
/*@{*/
#define HW_FTFA_XACCL0_ADDR(x)   ((x) + 0x1FU)

#define HW_FTFA_XACCL0(x)        (*(__I hw_ftfa_xaccl0_t *) HW_FTFA_XACCL0_ADDR(x))
#define HW_FTFA_XACCL0_RD(x)     (HW_FTFA_XACCL0(x).U)
/*@}*/

/*
 * Constants & macros for individual FTFA_XACCL0 bitfields
 */

/*!
 * @name Register FTFA_XACCL0, field XA[7:0] (RO)
 *
 * Values:
 * - 0 - Associated segment is accessible in execute mode only (as an
 *     instruction fetch)
 * - 1 - Associated segment is accessible as data or in execute mode
 */
/*@{*/
#define BP_FTFA_XACCL0_XA    (0U)          /*!< Bit position for FTFA_XACCL0_XA. */
#define BM_FTFA_XACCL0_XA    (0xFFU)       /*!< Bit mask for FTFA_XACCL0_XA. */
#define BS_FTFA_XACCL0_XA    (8U)          /*!< Bit field size in bits for FTFA_XACCL0_XA. */

/*! @brief Read current value of the FTFA_XACCL0_XA field. */
#define BR_FTFA_XACCL0_XA(x) (HW_FTFA_XACCL0(x).U)
/*@}*/

/*******************************************************************************
 * HW_FTFA_SACCH3 - Supervisor-only Access Registers
 ******************************************************************************/

/*!
 * @brief HW_FTFA_SACCH3 - Supervisor-only Access Registers (RO)
 *
 * Reset value: 0x00U
 *
 * The SACC registers define which logical program flash segments are restricted
 * to supervisor only or user and supervisor access. The eight SACC registers
 * allow up to 64 restricted segments of equal memory size. Supervisor-only access
 * register Program flash supervisor-only access bits SACCH0 SA[63:56] SACCH1
 * SA[55:48] SACCH2 SA[47:40] SACCH3 SA[39:32] SACCL0 SA[31:24] SACCL1 SA[23:16]
 * SACCL2 SA[15:8] SACCL3 SA[7:0] During the reset sequence, the SACC registers are
 * loaded with the logical AND of Program Flash IFR addresses A and B as
 * indicated in the following table. Supervisor-only access register Program Flash IFR
 * address A Program Flash IFR address B SACCH0 0xB3 0xBB SACCH1 0xB2 0xBA SACCH2
 * 0xB1 0xB9 SACCH3 0xB0 0xB8 SACCL0 0xB7 0xBF SACCL1 0xB6 0xBE SACCL2 0xB5 0xBD
 * SACCL3 0xB4 0xBC Use the Program Once command to program the supervisor-only
 * access control fields that are loaded during the reset sequence.
 */
typedef union _hw_ftfa_sacch3
{
    uint8_t U;
    struct _hw_ftfa_sacch3_bitfields
    {
        uint8_t SA : 8;                /*!< [7:0] Supervisor-only access control */
    } B;
} hw_ftfa_sacch3_t;

/*!
 * @name Constants and macros for entire FTFA_SACCH3 register
 */
/*@{*/
#define HW_FTFA_SACCH3_ADDR(x)   ((x) + 0x20U)

#define HW_FTFA_SACCH3(x)        (*(__I hw_ftfa_sacch3_t *) HW_FTFA_SACCH3_ADDR(x))
#define HW_FTFA_SACCH3_RD(x)     (HW_FTFA_SACCH3(x).U)
/*@}*/

/*
 * Constants & macros for individual FTFA_SACCH3 bitfields
 */

/*!
 * @name Register FTFA_SACCH3, field SA[7:0] (RO)
 *
 * Values:
 * - 0 - Associated segment is accessible in supervisor mode only
 * - 1 - Associated segment is accessible in user or supervisor mode
 */
/*@{*/
#define BP_FTFA_SACCH3_SA    (0U)          /*!< Bit position for FTFA_SACCH3_SA. */
#define BM_FTFA_SACCH3_SA    (0xFFU)       /*!< Bit mask for FTFA_SACCH3_SA. */
#define BS_FTFA_SACCH3_SA    (8U)          /*!< Bit field size in bits for FTFA_SACCH3_SA. */

/*! @brief Read current value of the FTFA_SACCH3_SA field. */
#define BR_FTFA_SACCH3_SA(x) (HW_FTFA_SACCH3(x).U)
/*@}*/

/*******************************************************************************
 * HW_FTFA_SACCH2 - Supervisor-only Access Registers
 ******************************************************************************/

/*!
 * @brief HW_FTFA_SACCH2 - Supervisor-only Access Registers (RO)
 *
 * Reset value: 0x00U
 *
 * The SACC registers define which logical program flash segments are restricted
 * to supervisor only or user and supervisor access. The eight SACC registers
 * allow up to 64 restricted segments of equal memory size. Supervisor-only access
 * register Program flash supervisor-only access bits SACCH0 SA[63:56] SACCH1
 * SA[55:48] SACCH2 SA[47:40] SACCH3 SA[39:32] SACCL0 SA[31:24] SACCL1 SA[23:16]
 * SACCL2 SA[15:8] SACCL3 SA[7:0] During the reset sequence, the SACC registers are
 * loaded with the logical AND of Program Flash IFR addresses A and B as
 * indicated in the following table. Supervisor-only access register Program Flash IFR
 * address A Program Flash IFR address B SACCH0 0xB3 0xBB SACCH1 0xB2 0xBA SACCH2
 * 0xB1 0xB9 SACCH3 0xB0 0xB8 SACCL0 0xB7 0xBF SACCL1 0xB6 0xBE SACCL2 0xB5 0xBD
 * SACCL3 0xB4 0xBC Use the Program Once command to program the supervisor-only
 * access control fields that are loaded during the reset sequence.
 */
typedef union _hw_ftfa_sacch2
{
    uint8_t U;
    struct _hw_ftfa_sacch2_bitfields
    {
        uint8_t SA : 8;                /*!< [7:0] Supervisor-only access control */
    } B;
} hw_ftfa_sacch2_t;

/*!
 * @name Constants and macros for entire FTFA_SACCH2 register
 */
/*@{*/
#define HW_FTFA_SACCH2_ADDR(x)   ((x) + 0x21U)

#define HW_FTFA_SACCH2(x)        (*(__I hw_ftfa_sacch2_t *) HW_FTFA_SACCH2_ADDR(x))
#define HW_FTFA_SACCH2_RD(x)     (HW_FTFA_SACCH2(x).U)
/*@}*/

/*
 * Constants & macros for individual FTFA_SACCH2 bitfields
 */

/*!
 * @name Register FTFA_SACCH2, field SA[7:0] (RO)
 *
 * Values:
 * - 0 - Associated segment is accessible in supervisor mode only
 * - 1 - Associated segment is accessible in user or supervisor mode
 */
/*@{*/
#define BP_FTFA_SACCH2_SA    (0U)          /*!< Bit position for FTFA_SACCH2_SA. */
#define BM_FTFA_SACCH2_SA    (0xFFU)       /*!< Bit mask for FTFA_SACCH2_SA. */
#define BS_FTFA_SACCH2_SA    (8U)          /*!< Bit field size in bits for FTFA_SACCH2_SA. */

/*! @brief Read current value of the FTFA_SACCH2_SA field. */
#define BR_FTFA_SACCH2_SA(x) (HW_FTFA_SACCH2(x).U)
/*@}*/

/*******************************************************************************
 * HW_FTFA_SACCH1 - Supervisor-only Access Registers
 ******************************************************************************/

/*!
 * @brief HW_FTFA_SACCH1 - Supervisor-only Access Registers (RO)
 *
 * Reset value: 0x00U
 *
 * The SACC registers define which logical program flash segments are restricted
 * to supervisor only or user and supervisor access. The eight SACC registers
 * allow up to 64 restricted segments of equal memory size. Supervisor-only access
 * register Program flash supervisor-only access bits SACCH0 SA[63:56] SACCH1
 * SA[55:48] SACCH2 SA[47:40] SACCH3 SA[39:32] SACCL0 SA[31:24] SACCL1 SA[23:16]
 * SACCL2 SA[15:8] SACCL3 SA[7:0] During the reset sequence, the SACC registers are
 * loaded with the logical AND of Program Flash IFR addresses A and B as
 * indicated in the following table. Supervisor-only access register Program Flash IFR
 * address A Program Flash IFR address B SACCH0 0xB3 0xBB SACCH1 0xB2 0xBA SACCH2
 * 0xB1 0xB9 SACCH3 0xB0 0xB8 SACCL0 0xB7 0xBF SACCL1 0xB6 0xBE SACCL2 0xB5 0xBD
 * SACCL3 0xB4 0xBC Use the Program Once command to program the supervisor-only
 * access control fields that are loaded during the reset sequence.
 */
typedef union _hw_ftfa_sacch1
{
    uint8_t U;
    struct _hw_ftfa_sacch1_bitfields
    {
        uint8_t SA : 8;                /*!< [7:0] Supervisor-only access control */
    } B;
} hw_ftfa_sacch1_t;

/*!
 * @name Constants and macros for entire FTFA_SACCH1 register
 */
/*@{*/
#define HW_FTFA_SACCH1_ADDR(x)   ((x) + 0x22U)

#define HW_FTFA_SACCH1(x)        (*(__I hw_ftfa_sacch1_t *) HW_FTFA_SACCH1_ADDR(x))
#define HW_FTFA_SACCH1_RD(x)     (HW_FTFA_SACCH1(x).U)
/*@}*/

/*
 * Constants & macros for individual FTFA_SACCH1 bitfields
 */

/*!
 * @name Register FTFA_SACCH1, field SA[7:0] (RO)
 *
 * Values:
 * - 0 - Associated segment is accessible in supervisor mode only
 * - 1 - Associated segment is accessible in user or supervisor mode
 */
/*@{*/
#define BP_FTFA_SACCH1_SA    (0U)          /*!< Bit position for FTFA_SACCH1_SA. */
#define BM_FTFA_SACCH1_SA    (0xFFU)       /*!< Bit mask for FTFA_SACCH1_SA. */
#define BS_FTFA_SACCH1_SA    (8U)          /*!< Bit field size in bits for FTFA_SACCH1_SA. */

/*! @brief Read current value of the FTFA_SACCH1_SA field. */
#define BR_FTFA_SACCH1_SA(x) (HW_FTFA_SACCH1(x).U)
/*@}*/

/*******************************************************************************
 * HW_FTFA_SACCH0 - Supervisor-only Access Registers
 ******************************************************************************/

/*!
 * @brief HW_FTFA_SACCH0 - Supervisor-only Access Registers (RO)
 *
 * Reset value: 0x00U
 *
 * The SACC registers define which logical program flash segments are restricted
 * to supervisor only or user and supervisor access. The eight SACC registers
 * allow up to 64 restricted segments of equal memory size. Supervisor-only access
 * register Program flash supervisor-only access bits SACCH0 SA[63:56] SACCH1
 * SA[55:48] SACCH2 SA[47:40] SACCH3 SA[39:32] SACCL0 SA[31:24] SACCL1 SA[23:16]
 * SACCL2 SA[15:8] SACCL3 SA[7:0] During the reset sequence, the SACC registers are
 * loaded with the logical AND of Program Flash IFR addresses A and B as
 * indicated in the following table. Supervisor-only access register Program Flash IFR
 * address A Program Flash IFR address B SACCH0 0xB3 0xBB SACCH1 0xB2 0xBA SACCH2
 * 0xB1 0xB9 SACCH3 0xB0 0xB8 SACCL0 0xB7 0xBF SACCL1 0xB6 0xBE SACCL2 0xB5 0xBD
 * SACCL3 0xB4 0xBC Use the Program Once command to program the supervisor-only
 * access control fields that are loaded during the reset sequence.
 */
typedef union _hw_ftfa_sacch0
{
    uint8_t U;
    struct _hw_ftfa_sacch0_bitfields
    {
        uint8_t SA : 8;                /*!< [7:0] Supervisor-only access control */
    } B;
} hw_ftfa_sacch0_t;

/*!
 * @name Constants and macros for entire FTFA_SACCH0 register
 */
/*@{*/
#define HW_FTFA_SACCH0_ADDR(x)   ((x) + 0x23U)

#define HW_FTFA_SACCH0(x)        (*(__I hw_ftfa_sacch0_t *) HW_FTFA_SACCH0_ADDR(x))
#define HW_FTFA_SACCH0_RD(x)     (HW_FTFA_SACCH0(x).U)
/*@}*/

/*
 * Constants & macros for individual FTFA_SACCH0 bitfields
 */

/*!
 * @name Register FTFA_SACCH0, field SA[7:0] (RO)
 *
 * Values:
 * - 0 - Associated segment is accessible in supervisor mode only
 * - 1 - Associated segment is accessible in user or supervisor mode
 */
/*@{*/
#define BP_FTFA_SACCH0_SA    (0U)          /*!< Bit position for FTFA_SACCH0_SA. */
#define BM_FTFA_SACCH0_SA    (0xFFU)       /*!< Bit mask for FTFA_SACCH0_SA. */
#define BS_FTFA_SACCH0_SA    (8U)          /*!< Bit field size in bits for FTFA_SACCH0_SA. */

/*! @brief Read current value of the FTFA_SACCH0_SA field. */
#define BR_FTFA_SACCH0_SA(x) (HW_FTFA_SACCH0(x).U)
/*@}*/

/*******************************************************************************
 * HW_FTFA_SACCL3 - Supervisor-only Access Registers
 ******************************************************************************/

/*!
 * @brief HW_FTFA_SACCL3 - Supervisor-only Access Registers (RO)
 *
 * Reset value: 0x00U
 *
 * The SACC registers define which logical program flash segments are restricted
 * to supervisor only or user and supervisor access. The eight SACC registers
 * allow up to 64 restricted segments of equal memory size. Supervisor-only access
 * register Program flash supervisor-only access bits SACCH0 SA[63:56] SACCH1
 * SA[55:48] SACCH2 SA[47:40] SACCH3 SA[39:32] SACCL0 SA[31:24] SACCL1 SA[23:16]
 * SACCL2 SA[15:8] SACCL3 SA[7:0] During the reset sequence, the SACC registers are
 * loaded with the logical AND of Program Flash IFR addresses A and B as
 * indicated in the following table. Supervisor-only access register Program Flash IFR
 * address A Program Flash IFR address B SACCH0 0xB3 0xBB SACCH1 0xB2 0xBA SACCH2
 * 0xB1 0xB9 SACCH3 0xB0 0xB8 SACCL0 0xB7 0xBF SACCL1 0xB6 0xBE SACCL2 0xB5 0xBD
 * SACCL3 0xB4 0xBC Use the Program Once command to program the supervisor-only
 * access control fields that are loaded during the reset sequence.
 */
typedef union _hw_ftfa_saccl3
{
    uint8_t U;
    struct _hw_ftfa_saccl3_bitfields
    {
        uint8_t SA : 8;                /*!< [7:0] Supervisor-only access control */
    } B;
} hw_ftfa_saccl3_t;

/*!
 * @name Constants and macros for entire FTFA_SACCL3 register
 */
/*@{*/
#define HW_FTFA_SACCL3_ADDR(x)   ((x) + 0x24U)

#define HW_FTFA_SACCL3(x)        (*(__I hw_ftfa_saccl3_t *) HW_FTFA_SACCL3_ADDR(x))
#define HW_FTFA_SACCL3_RD(x)     (HW_FTFA_SACCL3(x).U)
/*@}*/

/*
 * Constants & macros for individual FTFA_SACCL3 bitfields
 */

/*!
 * @name Register FTFA_SACCL3, field SA[7:0] (RO)
 *
 * Values:
 * - 0 - Associated segment is accessible in supervisor mode only
 * - 1 - Associated segment is accessible in user or supervisor mode
 */
/*@{*/
#define BP_FTFA_SACCL3_SA    (0U)          /*!< Bit position for FTFA_SACCL3_SA. */
#define BM_FTFA_SACCL3_SA    (0xFFU)       /*!< Bit mask for FTFA_SACCL3_SA. */
#define BS_FTFA_SACCL3_SA    (8U)          /*!< Bit field size in bits for FTFA_SACCL3_SA. */

/*! @brief Read current value of the FTFA_SACCL3_SA field. */
#define BR_FTFA_SACCL3_SA(x) (HW_FTFA_SACCL3(x).U)
/*@}*/

/*******************************************************************************
 * HW_FTFA_SACCL2 - Supervisor-only Access Registers
 ******************************************************************************/

/*!
 * @brief HW_FTFA_SACCL2 - Supervisor-only Access Registers (RO)
 *
 * Reset value: 0x00U
 *
 * The SACC registers define which logical program flash segments are restricted
 * to supervisor only or user and supervisor access. The eight SACC registers
 * allow up to 64 restricted segments of equal memory size. Supervisor-only access
 * register Program flash supervisor-only access bits SACCH0 SA[63:56] SACCH1
 * SA[55:48] SACCH2 SA[47:40] SACCH3 SA[39:32] SACCL0 SA[31:24] SACCL1 SA[23:16]
 * SACCL2 SA[15:8] SACCL3 SA[7:0] During the reset sequence, the SACC registers are
 * loaded with the logical AND of Program Flash IFR addresses A and B as
 * indicated in the following table. Supervisor-only access register Program Flash IFR
 * address A Program Flash IFR address B SACCH0 0xB3 0xBB SACCH1 0xB2 0xBA SACCH2
 * 0xB1 0xB9 SACCH3 0xB0 0xB8 SACCL0 0xB7 0xBF SACCL1 0xB6 0xBE SACCL2 0xB5 0xBD
 * SACCL3 0xB4 0xBC Use the Program Once command to program the supervisor-only
 * access control fields that are loaded during the reset sequence.
 */
typedef union _hw_ftfa_saccl2
{
    uint8_t U;
    struct _hw_ftfa_saccl2_bitfields
    {
        uint8_t SA : 8;                /*!< [7:0] Supervisor-only access control */
    } B;
} hw_ftfa_saccl2_t;

/*!
 * @name Constants and macros for entire FTFA_SACCL2 register
 */
/*@{*/
#define HW_FTFA_SACCL2_ADDR(x)   ((x) + 0x25U)

#define HW_FTFA_SACCL2(x)        (*(__I hw_ftfa_saccl2_t *) HW_FTFA_SACCL2_ADDR(x))
#define HW_FTFA_SACCL2_RD(x)     (HW_FTFA_SACCL2(x).U)
/*@}*/

/*
 * Constants & macros for individual FTFA_SACCL2 bitfields
 */

/*!
 * @name Register FTFA_SACCL2, field SA[7:0] (RO)
 *
 * Values:
 * - 0 - Associated segment is accessible in supervisor mode only
 * - 1 - Associated segment is accessible in user or supervisor mode
 */
/*@{*/
#define BP_FTFA_SACCL2_SA    (0U)          /*!< Bit position for FTFA_SACCL2_SA. */
#define BM_FTFA_SACCL2_SA    (0xFFU)       /*!< Bit mask for FTFA_SACCL2_SA. */
#define BS_FTFA_SACCL2_SA    (8U)          /*!< Bit field size in bits for FTFA_SACCL2_SA. */

/*! @brief Read current value of the FTFA_SACCL2_SA field. */
#define BR_FTFA_SACCL2_SA(x) (HW_FTFA_SACCL2(x).U)
/*@}*/

/*******************************************************************************
 * HW_FTFA_SACCL1 - Supervisor-only Access Registers
 ******************************************************************************/

/*!
 * @brief HW_FTFA_SACCL1 - Supervisor-only Access Registers (RO)
 *
 * Reset value: 0x00U
 *
 * The SACC registers define which logical program flash segments are restricted
 * to supervisor only or user and supervisor access. The eight SACC registers
 * allow up to 64 restricted segments of equal memory size. Supervisor-only access
 * register Program flash supervisor-only access bits SACCH0 SA[63:56] SACCH1
 * SA[55:48] SACCH2 SA[47:40] SACCH3 SA[39:32] SACCL0 SA[31:24] SACCL1 SA[23:16]
 * SACCL2 SA[15:8] SACCL3 SA[7:0] During the reset sequence, the SACC registers are
 * loaded with the logical AND of Program Flash IFR addresses A and B as
 * indicated in the following table. Supervisor-only access register Program Flash IFR
 * address A Program Flash IFR address B SACCH0 0xB3 0xBB SACCH1 0xB2 0xBA SACCH2
 * 0xB1 0xB9 SACCH3 0xB0 0xB8 SACCL0 0xB7 0xBF SACCL1 0xB6 0xBE SACCL2 0xB5 0xBD
 * SACCL3 0xB4 0xBC Use the Program Once command to program the supervisor-only
 * access control fields that are loaded during the reset sequence.
 */
typedef union _hw_ftfa_saccl1
{
    uint8_t U;
    struct _hw_ftfa_saccl1_bitfields
    {
        uint8_t SA : 8;                /*!< [7:0] Supervisor-only access control */
    } B;
} hw_ftfa_saccl1_t;

/*!
 * @name Constants and macros for entire FTFA_SACCL1 register
 */
/*@{*/
#define HW_FTFA_SACCL1_ADDR(x)   ((x) + 0x26U)

#define HW_FTFA_SACCL1(x)        (*(__I hw_ftfa_saccl1_t *) HW_FTFA_SACCL1_ADDR(x))
#define HW_FTFA_SACCL1_RD(x)     (HW_FTFA_SACCL1(x).U)
/*@}*/

/*
 * Constants & macros for individual FTFA_SACCL1 bitfields
 */

/*!
 * @name Register FTFA_SACCL1, field SA[7:0] (RO)
 *
 * Values:
 * - 0 - Associated segment is accessible in supervisor mode only
 * - 1 - Associated segment is accessible in user or supervisor mode
 */
/*@{*/
#define BP_FTFA_SACCL1_SA    (0U)          /*!< Bit position for FTFA_SACCL1_SA. */
#define BM_FTFA_SACCL1_SA    (0xFFU)       /*!< Bit mask for FTFA_SACCL1_SA. */
#define BS_FTFA_SACCL1_SA    (8U)          /*!< Bit field size in bits for FTFA_SACCL1_SA. */

/*! @brief Read current value of the FTFA_SACCL1_SA field. */
#define BR_FTFA_SACCL1_SA(x) (HW_FTFA_SACCL1(x).U)
/*@}*/

/*******************************************************************************
 * HW_FTFA_SACCL0 - Supervisor-only Access Registers
 ******************************************************************************/

/*!
 * @brief HW_FTFA_SACCL0 - Supervisor-only Access Registers (RO)
 *
 * Reset value: 0x00U
 *
 * The SACC registers define which logical program flash segments are restricted
 * to supervisor only or user and supervisor access. The eight SACC registers
 * allow up to 64 restricted segments of equal memory size. Supervisor-only access
 * register Program flash supervisor-only access bits SACCH0 SA[63:56] SACCH1
 * SA[55:48] SACCH2 SA[47:40] SACCH3 SA[39:32] SACCL0 SA[31:24] SACCL1 SA[23:16]
 * SACCL2 SA[15:8] SACCL3 SA[7:0] During the reset sequence, the SACC registers are
 * loaded with the logical AND of Program Flash IFR addresses A and B as
 * indicated in the following table. Supervisor-only access register Program Flash IFR
 * address A Program Flash IFR address B SACCH0 0xB3 0xBB SACCH1 0xB2 0xBA SACCH2
 * 0xB1 0xB9 SACCH3 0xB0 0xB8 SACCL0 0xB7 0xBF SACCL1 0xB6 0xBE SACCL2 0xB5 0xBD
 * SACCL3 0xB4 0xBC Use the Program Once command to program the supervisor-only
 * access control fields that are loaded during the reset sequence.
 */
typedef union _hw_ftfa_saccl0
{
    uint8_t U;
    struct _hw_ftfa_saccl0_bitfields
    {
        uint8_t SA : 8;                /*!< [7:0] Supervisor-only access control */
    } B;
} hw_ftfa_saccl0_t;

/*!
 * @name Constants and macros for entire FTFA_SACCL0 register
 */
/*@{*/
#define HW_FTFA_SACCL0_ADDR(x)   ((x) + 0x27U)

#define HW_FTFA_SACCL0(x)        (*(__I hw_ftfa_saccl0_t *) HW_FTFA_SACCL0_ADDR(x))
#define HW_FTFA_SACCL0_RD(x)     (HW_FTFA_SACCL0(x).U)
/*@}*/

/*
 * Constants & macros for individual FTFA_SACCL0 bitfields
 */

/*!
 * @name Register FTFA_SACCL0, field SA[7:0] (RO)
 *
 * Values:
 * - 0 - Associated segment is accessible in supervisor mode only
 * - 1 - Associated segment is accessible in user or supervisor mode
 */
/*@{*/
#define BP_FTFA_SACCL0_SA    (0U)          /*!< Bit position for FTFA_SACCL0_SA. */
#define BM_FTFA_SACCL0_SA    (0xFFU)       /*!< Bit mask for FTFA_SACCL0_SA. */
#define BS_FTFA_SACCL0_SA    (8U)          /*!< Bit field size in bits for FTFA_SACCL0_SA. */

/*! @brief Read current value of the FTFA_SACCL0_SA field. */
#define BR_FTFA_SACCL0_SA(x) (HW_FTFA_SACCL0(x).U)
/*@}*/

/*******************************************************************************
 * HW_FTFA_FACSS - Flash Access Segment Size Register
 ******************************************************************************/

/*!
 * @brief HW_FTFA_FACSS - Flash Access Segment Size Register (RO)
 *
 * Reset value: 0x00U
 *
 * The flash access segment size register determines which bits in the address
 * are used to index into the SACC and XACC bitmaps to get the appropriate
 * permission flags. All bits in the register are read-only. The contents of this
 * register are loaded during the reset sequence.
 */
typedef union _hw_ftfa_facss
{
    uint8_t U;
    struct _hw_ftfa_facss_bitfields
    {
        uint8_t SGSIZE : 8;            /*!< [7:0] Segment Size */
    } B;
} hw_ftfa_facss_t;

/*!
 * @name Constants and macros for entire FTFA_FACSS register
 */
/*@{*/
#define HW_FTFA_FACSS_ADDR(x)    ((x) + 0x28U)

#define HW_FTFA_FACSS(x)         (*(__I hw_ftfa_facss_t *) HW_FTFA_FACSS_ADDR(x))
#define HW_FTFA_FACSS_RD(x)      (HW_FTFA_FACSS(x).U)
/*@}*/

/*
 * Constants & macros for individual FTFA_FACSS bitfields
 */

/*!
 * @name Register FTFA_FACSS, field SGSIZE[7:0] (RO)
 *
 * The segment size is a fixed value based on the available program flash size
 * divided by NUMSG. Program Flash Size Segment Size Segment Size Encoding 64
 * KBytes 2 KBytes 0x3 128 KBytes 4 KBytes 0x4 160 KBytes 4 KBytes 0x4 256 KBytes 4
 * KBytes 0x4 512 KBytes 8 KBytes 0x5
 */
/*@{*/
#define BP_FTFA_FACSS_SGSIZE (0U)          /*!< Bit position for FTFA_FACSS_SGSIZE. */
#define BM_FTFA_FACSS_SGSIZE (0xFFU)       /*!< Bit mask for FTFA_FACSS_SGSIZE. */
#define BS_FTFA_FACSS_SGSIZE (8U)          /*!< Bit field size in bits for FTFA_FACSS_SGSIZE. */

/*! @brief Read current value of the FTFA_FACSS_SGSIZE field. */
#define BR_FTFA_FACSS_SGSIZE(x) (HW_FTFA_FACSS(x).U)
/*@}*/

/*******************************************************************************
 * HW_FTFA_FACSN - Flash Access Segment Number Register
 ******************************************************************************/

/*!
 * @brief HW_FTFA_FACSN - Flash Access Segment Number Register (RO)
 *
 * Reset value: 0x00U
 *
 * The flash access segment number register provides the number of program flash
 * segments that are available for XACC and SACC permissions. All bits in the
 * register are read-only. The contents of this register are loaded during the
 * reset sequence.
 */
typedef union _hw_ftfa_facsn
{
    uint8_t U;
    struct _hw_ftfa_facsn_bitfields
    {
        uint8_t NUMSG : 8;             /*!< [7:0] Number of Segments Indicator */
    } B;
} hw_ftfa_facsn_t;

/*!
 * @name Constants and macros for entire FTFA_FACSN register
 */
/*@{*/
#define HW_FTFA_FACSN_ADDR(x)    ((x) + 0x2BU)

#define HW_FTFA_FACSN(x)         (*(__I hw_ftfa_facsn_t *) HW_FTFA_FACSN_ADDR(x))
#define HW_FTFA_FACSN_RD(x)      (HW_FTFA_FACSN(x).U)
/*@}*/

/*
 * Constants & macros for individual FTFA_FACSN bitfields
 */

/*!
 * @name Register FTFA_FACSN, field NUMSG[7:0] (RO)
 *
 * The NUMSG field indicates the number of equal-sized segments in the program
 * flash.
 *
 * Values:
 * - 100000 - Program flash memory is divided into 32 segments (64 Kbytes, 128
 *     Kbytes)
 * - 101000 - Program flash memory is divided into 40 segments (160 Kbytes)
 * - 1000000 - Program flash memory is divided into 64 segments (256 Kbytes, 512
 *     Kbytes)
 */
/*@{*/
#define BP_FTFA_FACSN_NUMSG  (0U)          /*!< Bit position for FTFA_FACSN_NUMSG. */
#define BM_FTFA_FACSN_NUMSG  (0xFFU)       /*!< Bit mask for FTFA_FACSN_NUMSG. */
#define BS_FTFA_FACSN_NUMSG  (8U)          /*!< Bit field size in bits for FTFA_FACSN_NUMSG. */

/*! @brief Read current value of the FTFA_FACSN_NUMSG field. */
#define BR_FTFA_FACSN_NUMSG(x) (HW_FTFA_FACSN(x).U)
/*@}*/

/*******************************************************************************
 * hw_ftfa_t - module struct
 ******************************************************************************/
/*!
 * @brief All FTFA module registers.
 */
#pragma pack(1)
typedef struct _hw_ftfa
{
    __IO hw_ftfa_fstat_t FSTAT;            /*!< [0x0] Flash Status Register */
    __IO hw_ftfa_fcnfg_t FCNFG;            /*!< [0x1] Flash Configuration Register */
    __I hw_ftfa_fsec_t FSEC;               /*!< [0x2] Flash Security Register */
    __I hw_ftfa_fopt_t FOPT;               /*!< [0x3] Flash Option Register */
    __IO hw_ftfa_fccob3_t FCCOB3;          /*!< [0x4] Flash Common Command Object Registers */
    __IO hw_ftfa_fccob2_t FCCOB2;          /*!< [0x5] Flash Common Command Object Registers */
    __IO hw_ftfa_fccob1_t FCCOB1;          /*!< [0x6] Flash Common Command Object Registers */
    __IO hw_ftfa_fccob0_t FCCOB0;          /*!< [0x7] Flash Common Command Object Registers */
    __IO hw_ftfa_fccob7_t FCCOB7;          /*!< [0x8] Flash Common Command Object Registers */
    __IO hw_ftfa_fccob6_t FCCOB6;          /*!< [0x9] Flash Common Command Object Registers */
    __IO hw_ftfa_fccob5_t FCCOB5;          /*!< [0xA] Flash Common Command Object Registers */
    __IO hw_ftfa_fccob4_t FCCOB4;          /*!< [0xB] Flash Common Command Object Registers */
    __IO hw_ftfa_fccobb_t FCCOBB;          /*!< [0xC] Flash Common Command Object Registers */
    __IO hw_ftfa_fccoba_t FCCOBA;          /*!< [0xD] Flash Common Command Object Registers */
    __IO hw_ftfa_fccob9_t FCCOB9;          /*!< [0xE] Flash Common Command Object Registers */
    __IO hw_ftfa_fccob8_t FCCOB8;          /*!< [0xF] Flash Common Command Object Registers */
    __IO hw_ftfa_fprot3_t FPROT3;          /*!< [0x10] Program Flash Protection Registers */
    __IO hw_ftfa_fprot2_t FPROT2;          /*!< [0x11] Program Flash Protection Registers */
    __IO hw_ftfa_fprot1_t FPROT1;          /*!< [0x12] Program Flash Protection Registers */
    __IO hw_ftfa_fprot0_t FPROT0;          /*!< [0x13] Program Flash Protection Registers */
    uint8_t _reserved0[4];
    __I hw_ftfa_xacch3_t XACCH3;           /*!< [0x18] Execute-only Access Registers */
    __I hw_ftfa_xacch2_t XACCH2;           /*!< [0x19] Execute-only Access Registers */
    __I hw_ftfa_xacch1_t XACCH1;           /*!< [0x1A] Execute-only Access Registers */
    __I hw_ftfa_xacch0_t XACCH0;           /*!< [0x1B] Execute-only Access Registers */
    __I hw_ftfa_xaccl3_t XACCL3;           /*!< [0x1C] Execute-only Access Registers */
    __I hw_ftfa_xaccl2_t XACCL2;           /*!< [0x1D] Execute-only Access Registers */
    __I hw_ftfa_xaccl1_t XACCL1;           /*!< [0x1E] Execute-only Access Registers */
    __I hw_ftfa_xaccl0_t XACCL0;           /*!< [0x1F] Execute-only Access Registers */
    __I hw_ftfa_sacch3_t SACCH3;           /*!< [0x20] Supervisor-only Access Registers */
    __I hw_ftfa_sacch2_t SACCH2;           /*!< [0x21] Supervisor-only Access Registers */
    __I hw_ftfa_sacch1_t SACCH1;           /*!< [0x22] Supervisor-only Access Registers */
    __I hw_ftfa_sacch0_t SACCH0;           /*!< [0x23] Supervisor-only Access Registers */
    __I hw_ftfa_saccl3_t SACCL3;           /*!< [0x24] Supervisor-only Access Registers */
    __I hw_ftfa_saccl2_t SACCL2;           /*!< [0x25] Supervisor-only Access Registers */
    __I hw_ftfa_saccl1_t SACCL1;           /*!< [0x26] Supervisor-only Access Registers */
    __I hw_ftfa_saccl0_t SACCL0;           /*!< [0x27] Supervisor-only Access Registers */
    __I hw_ftfa_facss_t FACSS;             /*!< [0x28] Flash Access Segment Size Register */
    uint8_t _reserved1[2];
    __I hw_ftfa_facsn_t FACSN;             /*!< [0x2B] Flash Access Segment Number Register */
} hw_ftfa_t;
#pragma pack()

/*! @brief Macro to access all FTFA registers. */
/*! @param x FTFA module instance base address. */
/*! @return Reference (not a pointer) to the registers struct. To get a pointer to the struct,
 *     use the '&' operator, like <code>&HW_FTFA(FTFA_BASE)</code>. */
#define HW_FTFA(x)     (*(hw_ftfa_t *)(x))

#endif /* __HW_FTFA_REGISTERS_H__ */
/* EOF */
