/**
* @file STM811.c
* @brief library TouchScreen STM811
* @author Frederic BLANC
*/


#include "TS.h"
I2C i2c(P0_10, P0_11);//LPC1768 P0_10 SDA2 P0_11 SCL2 + pull up 3.3k 3.3VCC

int TS_Init (void) {
    int err=0;
//	err+=TS_Write (TS_TSC_CTRL, 0x03);		/* TSC_CTRL register   X, Y only mode, enable             */    
    err+=TS_Write (TS_SYS_CTRL1, 0x02);      /* Reset Touch-screen controller      */
   wait_ms(10);								/* Wait minimum of 10ms               */
    err+=TS_Write (TS_SYS_CTRL2, SYS_CTRL2_TS_OFF | SYS_CTRL2_GPIO_OFF);      /* 1.Enable TSC and ADC                 */
    err+=TS_Write (TS_INT_EN, INT_TOUCH_DET);       	/* 2.Enable Touch detect, FIFO          */
    err+=TS_Write (TS_ADC_CTRL1, 0x69);      /* 3.Set sample time , 12-bit mode      */
    wait_ms(2);									/* Wait minimum of 2ms                */
    err+=TS_Write (TS_ADC_CTRL2, 0x01);      /* 4.ADC frequency 3.25 MHz             */
	err+=TS_Write (TS_GPIO_AF, 0x00);		 /* 5. ALL IO in ADC/TS mode            */
    err+=TS_Write (TS_TSC_CFG, 0xF5);       	/* 6. Set TSC_CFG register               */
    err+=TS_Write (TS_FIFO_TH, 0x01);       	/* 6a.Threshold for FIFO                 */
    err+=TS_Write (TS_FIFO_STA, 0x01);       /* 7.FIFO reset                         */
    err+=TS_Write (TS_FIFO_STA, 0x00);       /* 8.FIFO not reset                     */
    err+=TS_Write (TS_TSC_FRACTION_Z, 0x07); /* 9.Fraction z                         */
    err+=TS_Write (TS_TSC_I_DRIVE, 0x01);    /* 10.Drive 50 mA typical                */
    err+=TS_Write (TS_TSC_CTRL, 0x01);       /* 11.Enable TSC                         */
    err+=TS_Write (TS_INT_STA, 0xFF);			/* 12.Clear interrupt status             */
    err+=TS_Write (TS_INT_CTRL, 0x01);       /* 13.Enable global interrupt            */

    return err;
}

int TS_Write (unsigned char reg,unsigned int val) {
    int err=0;
    int addr =0x82;
    char cmd[2];
    cmd[0] = reg;            // Register to be written
	cmd[1] = val;
    err+=i2c.write(addr, cmd,2); // Send addr cmd val
    return err;
}

unsigned int TS_Read (unsigned char reg, int num) {
    int addr =(0x82 | 0);
    unsigned int idata;
	char* data=(char*) &idata;
	data[1] =data[2] =data[3] =0;
    data[0] = reg;            // Register to be written
    i2c.write(addr, data,1); // Send command string
	do{
		i2c.read (addr, &data[--num], 1);
	}while (num);
	return idata;

}

int ts_XY( int *x,int *y,int *z) {
    int  tch_z   = 0;
    int tch_int  =  0;
    int tch_smpl =  0;
	tch_int = TS_Read (TS_INT_STA, 1);    /* Read Touch-screen interrupt status */
        if (tch_int & 2) {            /* If FIFO is above threshold         */
            tch_smpl = TS_Read (TS_FIFO_SIZE, 1);
            while (--tch_smpl) {
                TS_Read (TS_TSC_DATA_NAI, 4);
            }
		}
            tch_z = TS_Read (TS_TSC_DATA_NAI, 4);  /* Read coordinates                   */
            *x = (tch_z >> 20) & 0x00000FFF;
            *y = (tch_z >>  8) & 0x00000FFF;
            *z = (tch_z >>  0) & 0x0000000F;
    return 0;

}
